/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public abstract class AbstractCustomColumnHistoryReferencesTableModel<T extends HistoryReferencesTableEntry>
extends AbstractHistoryReferencesTableModel<T> {
    private static final long serialVersionUID = 3943406327364886416L;
    private final Map<Integer, Integer> cacheColumnIdxToIdxCustomColumnsOnly;

    public AbstractCustomColumnHistoryReferencesTableModel(HistoryReferencesTableModel.Column[] columnArray) {
        super(columnArray);
        this.cacheColumnIdxToIdxCustomColumnsOnly = AbstractCustomColumnHistoryReferencesTableModel.buildCacheColumnIdxToIdxCustomColumnsOnly(columnArray);
    }

    private static Map<Integer, Integer> buildCacheColumnIdxToIdxCustomColumnsOnly(HistoryReferencesTableModel.Column[] columnArray) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = 0;
        for (int i = 0; i < columnArray.length; ++i) {
            if (!AbstractCustomColumnHistoryReferencesTableModel.isCustomColumn(columnArray, i)) continue;
            treeMap.put(i, n);
            ++n;
        }
        if (treeMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return treeMap;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object t = this.getEntry(n);
        HistoryReferencesTableModel.Column column = this.getColumn(n2);
        if (column == HistoryReferencesTableModel.Column.CUSTOM) {
            return this.getCustomValueAt(t, n2);
        }
        return t.getValue(column);
    }

    protected abstract Object getCustomValueAt(T var1, int var2);

    @Override
    public String getColumnName(int n) {
        if (this.isCustomColumn(n)) {
            return this.getCustomColumnName(n);
        }
        return super.getColumnName(n);
    }

    protected abstract String getCustomColumnName(int var1);

    @Override
    public final Class<?> getColumnClass(int n) {
        HistoryReferencesTableModel.Column column = this.getColumn(n);
        if (column == HistoryReferencesTableModel.Column.CUSTOM) {
            return this.getCustomColumnClass(n);
        }
        return this.getColumnClass(column);
    }

    protected abstract Class<?> getColumnClass(HistoryReferencesTableModel.Column var1);

    protected abstract Class<?> getCustomColumnClass(int var1);

    @Override
    public Object getPrototypeValue(int n) {
        HistoryReferencesTableModel.Column column = this.getColumn(n);
        if (column == HistoryReferencesTableModel.Column.CUSTOM) {
            return this.getCustomPrototypeValue(n);
        }
        return this.getPrototypeValue(column);
    }

    protected abstract Object getPrototypeValue(HistoryReferencesTableModel.Column var1);

    protected abstract Object getCustomPrototypeValue(int var1);

    protected int getCustomColumnIndex(int n) {
        Integer n2 = this.cacheColumnIdxToIdxCustomColumnsOnly.get(n);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }
}

