/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.runtime.NativeLibLoader;
import com.sun.t2k.DFontDecoder;
import com.sun.t2k.T2KCompositeFontResource;
import com.sun.t2k.T2KFontFactory;
import com.sun.t2k.T2KFontFile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;

public class MacFontFinder {
    private static MacFontFinder theInstance = new MacFontFinder();
    private static HashMap<String, String> psNameToPathMap = null;
    private static String[] allAvailableFontFamilies = null;
    private static String[] allAvailableFonts = null;
    private static String[] allNativeFamilyFonts;

    public static MacFontFinder getInstance() {
        return theInstance;
    }

    private MacFontFinder() {
    }

    public String[] getFilePathsOfFontFamily(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (psNameToPathMap == null) {
            this.initPSFontNameToPathMap();
        }
        if ((stringArray = MacFontFinder.availableMembersOfFontFamily(string)) == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = psNameToPathMap.get(stringArray[i]);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean isValidFontFamily(String string) {
        String[] stringArray = null;
        if (allAvailableFontFamilies != null) {
            stringArray = allAvailableFontFamilies;
        } else if (allNativeFamilyFonts != null) {
            stringArray = allNativeFamilyFonts;
        } else {
            allNativeFamilyFonts = MacFontFinder.availableFontFamilies();
            Arrays.sort(allNativeFamilyFonts);
            stringArray = allNativeFamilyFonts;
        }
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = stringArray.length - 1;
        int n3 = (n + n2) / 2;
        while (n <= n2) {
            int n4 = string.compareToIgnoreCase(stringArray[n3]);
            if (n4 == 0) {
                return true;
            }
            if (n4 < 0) {
                n2 = n3 - 1;
                n3 = (n + n2) / 2;
                continue;
            }
            n = n3 + 1;
            n3 = (n + n2) / 2;
        }
        return false;
    }

    public String getFilePathOfFont(String string, float f) {
        String string2;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (psNameToPathMap == null) {
            this.initPSFontNameToPathMap();
        }
        if ((string2 = MacFontFinder.getPSNameOfFont(string, f)) == null || string2.isEmpty()) {
            return null;
        }
        return psNameToPathMap.get(string2);
    }

    private void initPSFontNameToPathMap() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        String[] stringArray2;
        int n;
        if (psNameToPathMap != null) {
            return;
        }
        psNameToPathMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray3 = MacFontFinder.availableFontURLs();
        for (n = 0; n < stringArray3.length; ++n) {
            try {
                stringArray2 = new URL(stringArray3[n]);
                stringArray = stringArray2.getRef();
                if (stringArray == null || (object4 = stringArray.split("\\=")) == null || ((String[])object4).length != 2 || !object4[0].contains("postscript-name")) continue;
                object3 = object4[1];
                object2 = stringArray2.toURI().getPath();
                object = ((String)object2).toLowerCase();
                if (((String)object).endsWith(".otf") && (((String)object).contains(" pro w") || ((String)object).contains(" pron w") || ((String)object).contains(" std w") || ((String)object).contains(" stdn w") || ((String)object).contains("hiragino"))) {
                    arrayList.add(stringArray3[n]);
                    continue;
                }
                psNameToPathMap.put((String)object3, (String)object2);
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        n = arrayList.size();
        stringArray2 = MacFontFinder.getFamilyNamesOfFontFiles(arrayList.toArray(new String[n]), n);
        stringArray = MacFontFinder.availableFontFamilies();
        object4 = new ArrayList(200);
        object3 = new MinStringHeap(stringArray.length, true);
        object2 = new MinStringHeap(stringArray2.length, true);
        ((MinStringHeap)object2).insertAll(Arrays.asList(stringArray2));
        for (String string : stringArray) {
            ((MinStringHeap)object3).insert(string);
        }
        object4 = new ArrayList();
        object = ((MinStringHeap)object2).getMin();
        while (!((MinStringHeap)object3).isEmpty()) {
            String string = ((MinStringHeap)object3).getMin();
            if (((String)object).equalsIgnoreCase(string)) {
                if (((MinStringHeap)object2).isEmpty()) {
                    while (!((MinStringHeap)object3).isEmpty()) {
                        ((ArrayList)object4).add(((MinStringHeap)object3).getMin());
                    }
                    break;
                }
                object = ((MinStringHeap)object2).getMin();
                continue;
            }
            ((ArrayList)object4).add(string);
        }
        allAvailableFontFamilies = ((ArrayList)object4).toArray(new String[((ArrayList)object4).size()]);
    }

    public String[] getAllAvailableFontFamilies() {
        if (allAvailableFontFamilies == null) {
            this.initPSFontNameToPathMap();
        }
        return allAvailableFontFamilies;
    }

    public String[] getAllAvailableFontFiles() {
        if (psNameToPathMap == null) {
            this.initPSFontNameToPathMap();
        }
        ArrayList<String> arrayList = new ArrayList<String>(psNameToPathMap.size());
        MinStringHeap minStringHeap = new MinStringHeap(psNameToPathMap.size(), true);
        minStringHeap.insertAll(psNameToPathMap.values());
        while (!minStringHeap.isEmpty()) {
            arrayList.add(minStringHeap.getMin());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getFontNamesOfFontFamily(String string) {
        Object object;
        int n;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (psNameToPathMap == null) {
            this.initPSFontNameToPathMap();
        }
        if (!MacFontFinder.isValidFontFamily(string)) {
            return null;
        }
        String[] stringArray = MacFontFinder.availableMembersOfFontFamily(string);
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        String string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            string2 = psNameToPathMap.get(stringArray[n]);
            if (string2 == null) continue;
            object = new File(string2);
            arrayList.add(((File)object).toURI().toASCIIString());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        n = arrayList.size();
        object = arrayList.toArray(new String[n]);
        String[] stringArray2 = MacFontFinder.getNamesOfFontFiles((String[])object, n);
        return stringArray2;
    }

    public static DFontDecoder checkDFont(String string, String string2) {
        block3: {
            if (string2.endsWith(".dfont")) {
                DFontDecoder dFontDecoder = new DFontDecoder();
                try {
                    dFontDecoder.openFile();
                    dFontDecoder.decode(string);
                    dFontDecoder.closeFile();
                    return dFontDecoder;
                }
                catch (Exception exception) {
                    dFontDecoder.deleteFile();
                    if (!T2KFontFactory.debugFonts) break block3;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    boolean populateFontFileNameMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        boolean bl = false;
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        if (hashMap == null || hashMap2 == null || hashMap3 == null) {
            return false;
        }
        Object[] objectArray = MacFontFinder.populateFontFileNameMap(hashMap, hashMap2, locale);
        Arrays.sort(objectArray);
        allAvailableFonts = objectArray;
        String string = "";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            String string2 = ((String)object).toLowerCase(locale);
            String string3 = hashMap2.get(string2);
            if (string3.contentEquals(string)) {
                arrayList.add(object);
            } else {
                if (!arrayList.isEmpty()) {
                    String string4 = string.toLowerCase(locale);
                    if (hashMap3.containsKey(string4)) {
                        ArrayList<String> arrayList2 = hashMap3.get(string4);
                        arrayList.addAll(arrayList2);
                    }
                    hashMap3.put(string4, arrayList);
                    arrayList = new ArrayList();
                }
                arrayList.add(object);
            }
            string = string3;
        }
        if (!arrayList.isEmpty()) {
            bl = true;
            String string5 = string.toLowerCase(locale);
            if (hashMap3.containsKey(string5)) {
                ArrayList<String> arrayList3 = hashMap3.get(string5);
                arrayList.addAll(arrayList3);
            }
            hashMap3.put(string5, arrayList);
        }
        return bl;
    }

    static FontResource getMacFontResource(String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = null;
        if (string == null || string.equals("")) {
            return null;
        }
        String string3 = string.toLowerCase();
        if (!MacFontFinder.isValidFontFamily(string3)) {
            return null;
        }
        String[] stringArray = MacFontFinder.getFontResource(string, bl, bl2);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length / 4;
        int n2 = (bl ? 2 : 0) + (bl2 ? 1 : 0);
        String string4 = null;
        FontResource fontResource = null;
        FontResource fontResource2 = null;
        ArrayList<FontResource> arrayList = new ArrayList<FontResource>(4);
        for (int i = 0; i < n; ++i) {
            string4 = stringArray[4 * i + 1];
            string2 = stringArray[4 * i + 2];
            String string5 = string4.toLowerCase();
            fontResource = T2KFontFactory.lookupResource(string5, bl3);
            if (fontResource != null) {
                return fontResource;
            }
            DFontDecoder dFontDecoder = MacFontFinder.checkDFont(string4, string2);
            if (dFontDecoder != null) {
                string2 = dFontDecoder.getFile().getPath();
            }
            fontResource = T2KFontFile.createFontResource(string4, string2);
            if (dFontDecoder != null) {
                if (fontResource != null) {
                    T2KFontFactory t2KFontFactory = T2KFontFactory.getFontFactory();
                    t2KFontFactory.addDecodedFont((T2KFontFile)fontResource);
                } else {
                    dFontDecoder.deleteFile();
                }
            }
            if (fontResource == null) continue;
            arrayList.add(fontResource);
            T2KFontFactory.storeInMap(string5, fontResource);
            int n3 = Integer.parseInt(stringArray[4 * i + 3]) & 3;
            boolean bl4 = (n3 & 1) != 0;
            boolean bl5 = (n3 & 2) != 0;
            String string6 = stringArray[4 * i].toLowerCase() + T2KFontFactory.dotStyleStr(bl5, bl4);
            T2KFontFactory.storeInMap(string6, fontResource);
            if (fontResource != null && bl3) {
                fontResource = new T2KCompositeFontResource(fontResource, string6);
            }
            if (n2 == n3 && fontResource2 == null) {
                fontResource2 = fontResource;
            }
            fontResource = null;
        }
        if (fontResource2 == null) {
            if (!arrayList.isEmpty()) {
                return (FontResource)arrayList.get(0);
            }
            return null;
        }
        return fontResource2;
    }

    private static native String[] availableMembersOfFontFamily(String var0);

    private static native String[] availableFontURLs();

    private static native String[] availableFontFamilies();

    private static native String[] getNamesOfFontFiles(String[] var0, int var1);

    private static native String[] getFamilyNamesOfFontFiles(String[] var0, int var1);

    private static native String[] populateFontFileNameMap(HashMap<String, String> var0, HashMap<String, String> var1, Locale var2);

    private static native String[] getFontResource(String var0, boolean var1, boolean var2);

    private static native String getPSNameOfFont(String var0, float var1);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NativeLibLoader.loadLibrary("javafx-font");
                return null;
            }
        });
        allNativeFamilyFonts = null;
    }

    private class MinStringHeap {
        private int max;
        private int index;
        private final int STEP_SIZE = 10;
        private String[] sHeap;
        private boolean unique = false;

        public MinStringHeap(int n) {
            this.max = n > 1 ? n : 10;
            this.sHeap = new String[this.max + 1];
            this.index = 1;
        }

        public MinStringHeap(int n, boolean bl) {
            this(n);
            this.unique = bl;
        }

        public String getMin() {
            if (this.isEmpty()) {
                return null;
            }
            String string = this.sHeap[1];
            this.sHeap[1] = this.sHeap[--this.index];
            this.fixDown(1);
            if (this.unique && string.equals(this.sHeap[1])) {
                this.getMin();
            }
            return string;
        }

        public void insert(String string) {
            if (this.index > this.max) {
                String[] stringArray = new String[this.max + 10 + 1];
                System.arraycopy(this.sHeap, 1, stringArray, 1, this.index - 1);
                this.max += 10;
                this.sHeap = stringArray;
            }
            this.sHeap[this.index] = string;
            this.fixUp(this.index++);
        }

        public void insertAll(Collection<String> collection) {
            String[] stringArray;
            if (collection.isEmpty()) {
                return;
            }
            if (collection.size() + this.index > this.max) {
                stringArray = new String[collection.size() + this.index];
                System.arraycopy(this.sHeap, 1, stringArray, 1, this.index - 1);
                this.max = collection.size() + this.index - 1;
                this.sHeap = stringArray;
            }
            stringArray = collection.iterator();
            while (stringArray.hasNext()) {
                this.insert((String)stringArray.next());
            }
        }

        private void fixDown(int n) {
            int n2 = n;
            int n3 = n2 * 2;
            if (n3 >= this.index) {
                return;
            }
            if (n3 + 1 == this.index) {
                if (this.sHeap[n2].compareTo(this.sHeap[n3]) > 0) {
                    this.swap(n2, n3);
                    return;
                }
            } else if (this.sHeap[n2].compareTo(this.sHeap[n3]) > 0 || this.sHeap[n2].compareTo(this.sHeap[n3 + 1]) > 0) {
                n3 = this.minIndex(n3, n3 + 1);
                this.swap(n2, n3);
                this.fixDown(n3);
            }
        }

        private int minIndex(int n, int n2) {
            return this.sHeap[n].compareTo(this.sHeap[n2]) < 0 ? n : n2;
        }

        private void fixUp(int n) {
            int n2 = n;
            if (n2 <= 1) {
                return;
            }
            if (this.sHeap[n2].compareTo(this.sHeap[n2 / 2]) < 0) {
                this.swap(n2, n2 / 2);
                this.fixUp(n2 / 2);
            }
        }

        private void swap(int n, int n2) {
            String string = this.sHeap[n];
            this.sHeap[n] = this.sHeap[n2];
            this.sHeap[n2] = string;
        }

        public boolean isEmpty() {
            return this.index == 1;
        }
    }
}

