/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;

class CbSlider
extends Canvas {
    int dir;
    int min;
    int max;
    int pos;
    CbSliderCallback callback;
    int px;
    int py;
    Color lc1 = Util.light_edge;
    Color lc2 = Util.body;
    Color lc3 = Util.dark_edge;
    Color hc1 = Util.light_edge_hi;
    Color hc2 = Util.body_hi;
    Color hc3 = Util.dark_edge_hi;
    int ticks = 0;
    boolean inside = false;
    boolean dragging = false;
    int dragx;

    public CbSlider(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null);
    }

    public CbSlider(int n, int n2, int n3, int n4, CbSliderCallback cbSliderCallback) {
        this.dir = n;
        this.min = n2;
        this.max = n3;
        this.pos = n4;
        this.callback = cbSliderCallback;
    }

    public void setTicks(int n) {
        this.ticks = n;
        this.repaint();
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int n) {
        if (this.pos != n) {
            this.pos = n;
            this.repaint();
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
        this.checkPos();
        this.repaint();
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
        this.checkPos();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Color color = this.inside ? this.hc1 : this.lc1;
        Color color2 = this.inside ? this.hc2 : this.lc2;
        Color color3 = this.inside ? this.hc3 : this.lc3;
        int n = this.size().width;
        int n2 = this.size().height;
        graphics.setColor(color2);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(color3);
        graphics.drawLine(8, n2 / 2, n - 8, n2 / 2);
        graphics.setColor(color);
        graphics.drawLine(8, n2 / 2 + 1, n - 8, n2 / 2 + 1);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.setColor(color3);
        graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        graphics.drawLine(n - 1, n2 - 1, 0, n2 - 1);
        if (this.inside) {
            graphics.drawLine(n - 2, n2 - 2, n - 2, 0);
            graphics.drawLine(n - 2, n2 - 2, 0, n2 - 2);
        }
        if (this.ticks != 0) {
            int n3 = this.max - this.min;
            for (int i = 0; i <= n3; i += this.ticks) {
                int n4 = (n - 16) * i / n3 + 8;
                graphics.setColor(color3);
                graphics.drawLine(n4, n2 / 2, n4, n2 / 2 - 6);
            }
        }
        this.px = (n - 16) * this.pos / (this.max - this.min) + 8;
        this.py = n2 / 2;
        graphics.setColor(color2);
        int[] nArray = new int[]{this.px - 3, this.px - 3, this.px, this.px + 3, this.px + 3};
        int[] nArray2 = new int[]{this.py + 5, this.py - 4, this.py - 6, this.py - 4, this.py + 5};
        graphics.fillPolygon(nArray, nArray2, 5);
        graphics.setColor(this.dragging ? color3 : color);
        graphics.drawLine(this.px - 3, this.py + 5, this.px - 3, this.py - 4);
        graphics.drawLine(this.px - 3, this.py - 4, this.px, this.py - 6);
        graphics.setColor(this.dragging ? color : color3);
        graphics.drawLine(this.px - 3, this.py + 5, this.px + 3, this.py + 5);
        graphics.drawLine(this.px + 3, this.py + 5, this.px + 3, this.py - 4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.inside = true;
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3;
        int n4 = n3 = this.ticks == 0 ? (this.max - this.min) / 10 : this.ticks;
        if (n < this.px - 3) {
            this.pos -= n3;
        } else if (n > this.px + 3) {
            this.pos += n3;
        } else {
            this.dragging = true;
            this.dragx = n - this.px;
        }
        this.checkPos();
        if (this.callback != null) {
            this.callback.moved(this, this.pos);
        }
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.dragging) {
            this.px = n - this.dragx;
            this.pos = (this.px - 8) * (this.max - this.min) / (this.size().width - 16);
            this.checkPos();
            if (this.callback != null) {
                this.callback.moving(this, this.pos);
            }
            this.repaint();
        }
        return this.dragging;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.dragging) {
            this.dragging = false;
            if (this.callback != null) {
                this.callback.moved(this, this.pos);
            }
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.inside = false;
        this.repaint();
        return true;
    }

    protected void checkPos() {
        if (this.pos < this.min) {
            this.pos = this.min;
        } else if (this.pos > this.max) {
            this.pos = this.max;
        }
    }

    public Dimension preferredSize() {
        return new Dimension(100, 20);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }
}

