/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jmol.util.Logger;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBODialogView;

abstract class NBODialogSearch
extends NBODialogView {
    int operator = 1;
    protected JPanel comboBox;
    protected JComboBox<String> bas2;
    protected JComboBox<String> orb;
    protected JComboBox<String> nbo1;
    protected JComboBox<String> nbo2;
    protected JComboBox<String> unit;
    protected JComboBox<String> at1;
    protected JComboBox<String> at2;
    protected JComboBox<String> row;
    protected JComboBox<String> col;
    protected JComboBox<String> opBas;
    protected String keyProp;
    protected JCheckBox viewAll;
    protected JSplitPane splitPane;
    protected DefaultTableModel listM;
    protected boolean home;
    private static final int KEYWD_NPA = 1;
    private static final int KEYWD_NBO = 2;
    private static final int KEYWD_BEND = 3;
    private static final int KEYWD_E2PERT = 4;
    private static final int KEYWD_NLMO = 5;
    private static final int KEYWD_NRT = 6;
    private static final int KEYWD_STERIC = 7;
    private static final int KEYWD_CMO = 8;
    private static final int KEYWD_DIPOLE = 9;
    private static final int KEYWD_OPBAS = 10;
    private static final int KEYWD_BAS1BAS2 = 11;
    private static final int NPA_VIS = 11;
    private static final int NBO_VIS = 7;
    private static final int BEND_VIS = 8;
    private static final int E2_VIS = 7;
    private static final int NLMO_VIS = 7;
    private static final int STERIC_VIS = 8;
    private static final int MO_VIS = 8;
    private static final int CMO_VIS = 9;
    protected String[] keyW = new String[]{"NPA     Atomic and NAO properties", "NBO     Natural Lewis Structure and NBO properties", "BEND    NHO directionality and bond-bending", "E2PERT  2nd-order energtics of NBO donor-acceptor interactions", "NLM     NLMO properties", "NRT     Natural Resonance Theory weightings and bond orders", "STERIC  Total/pairwise contributions to steric exchange energy", "CMO     NBO-based character of canonical molecular orbitals", "DIPOLE  L/NL contributions to electric dipole moment", "<OPBAS> Matrix elements of chosen operator in chosen basis set", "<B1B2>  Transformation matrix between chosen basis sets"};
    protected String[] npa = new String[]{"NPA Atomic Properties:", "  (1) NPA atomic charge", "  (2) NPA atomic spin density", "  (3) NEC atomic electron configuration", "NPA Molecular Unit Properties:", "  (4) NPA molecular unit charge", "  (5) NPA molecular unit spin density", "NAO Orbital Properties:", "  (6) NAO label", "  (7) NAO orbital population", "  (8) NAO orbital energy", "  (9) NAO orbital spin density", "  (10) NMB minimal basis %-accuracy", "Display Options:", "  (11) Display (P)NAO visualization", "  (12) Display atomic charges"};
    protected String[] nbo = new String[]{"NBO Orbital Properties:", "  (1) NBO orbital label", "  (2) NBO orbital population", "  (3) NBO orbital energy", "  (4) NBO ionicity", "Natural Lewis Structure Properties:", "  (5) NLS rho(NL)", "  (6) NLS %-rho(L)", "Display Options:", "  (7) Display (P)NAO visualization", "  (8) Display NLS diagram"};
    protected String[] bend = new String[]{"NHO Orbital Prperties:", "  (1) NHO orbital label", "  (2) NHO orbital population", "  (3) NHO orbital energy", "  (4) NHO hybrid composition", "  (5) NHO direction angles", "  (6) NHO bending deviation from line of centers", "  (7) Strongest bending deviation for any NHO", "Display Option", "  (8) Display (P)NHO visualiztion"};
    protected String[] e2 = new String[]{"E2 Values for Selected Donor-Acceptor NBOs:", "  (1) E(2) interaction for current d/a NBOs", "  (2) Strongest E(2) interaction for current d-NBO", "  (3) Strongest E(2) interaction for current a-NBO", "  (4) Strongest E(2) interaction for any d/a NBOs", "Intermolecular E2 Options:", "  (5) Strongest intermolecular E(2) for current unit", "  (6) Strongest intermolecular E(2) for any units", "Display Option:", "  (7) Display (P)NBO visualization for current d/a NBOs"};
    protected String[] nlmo = new String[]{"NLMO Orbital Properties:", "  (1) NLMO orbital label", "  (2) NLMO population", "  (3) NLMO orbital energy", "  (4) NLMO %-NBO parentage", "NLMO Delocalization Tail Properties:", "  (5) NLMO delocalization tail population", "  (6) NLMO delocalization tail NBO components", "Display Option:", "  (7) Display (P)NLMO visualization"};
    protected String[] nrt = new String[]{"Atom (A) Properties:", "  (1) atomic valency (total)", "  (2) atomic covalency", "  (3) atomic electrovalency", "Bond [A-A'] Properties:", "  (4) bond order (total)", "  (5) covalent bond order", "  (6) electrovalent bond order", "Resonance Structure Properties:", "  (7) RS weighting", "  (8) RS rho(NL) (reference structures only)", "Display Options:", "  (9) Display NRT atomic valencies", "  (10) Display NRT bond orders", "  (11) Display RS diagram"};
    protected String[] steric = new String[]{"Total Steric Exchange Energy (SXE) Estimates:", "  (1) Total SXE", "  (2) Sum of pairwise (PW-SXE) contributions", "Selected PW-SXE contributions:", "  (3) PW-SXE for current d-d' NLMOs", "  (4) Strongest PW-SXE for current d NLMO", "Intra- and intermolecular options:", "  (5) Strongest PW-SXE within current unit", "  (6) Strongest PW-SXE within any unit", "  (7) Strongest PW-SXE between any units", "Display Option:", "  (8) Display (P)NLMO diagram for current PW-SXE"};
    protected String[] mo = new String[]{"Character of current MO (c):", "  (1) Current MO energy and type", "  (2) Bonding character of current MO", "  (3) Nonbonding character of current MO", "  (4) Antibonding character of current MO", "NBO (n) %-contribution to selected MO (c):", "  (5) %-contribution of current NBO to current MO", "  (6) Largest %-contribution to current MO from any NBO", "  (7) Largest %-contribution of current NBO to any MO", "Display Options:", "  (8) Display current MO", "  (9) Display current NBO"};
    protected String[] dip = new String[]{"Total Dipole Properties:", "  (1) Total dipole moment", "  (2) Total L-type dipole", "  (3) Total NL-type (resonance) dipole", "Bond [NBO/NLMO] Dipole Properties:", "  (4) Dipole moment of current NLMO", "  (5) L-type (NBO bond dipole) contribution", "  (6) NL-type (resonance dipole) contribution", "Molecular Unit Dipole Properties:", "  (7) Dipole moment of current molecular unit", "  (8) L-type contribution to unit dipole", "  (9) NL-type contribution to unit dipole"};
    protected String[] op = new String[]{"***** Select OP *****", "  (1) S   overlap (unit) operator", "  (2) F   1e Hamiltonian (Fock/Kohn-Sham) operator", "  (3) K   kinetic energy operator", "  (4) V   1e potential (nuclear-electron attraction) operator", "  (5) DM  1e density matrix operator", "  (6) DIx dipole moment operator (x component)", "  (7) DIy dipole moment operator (y component)", "  (8) DIz dipole moment operator (z component)"};
    int orbStart = 0;
    private boolean secondPick = true;

    protected NBODialogSearch(JFrame f) {
        super(f);
        this.lists = new Hashtable();
    }

    protected void buildSearch(Container p) {
        if (this.tfExt != null && this.inputFile != null && this.tfExt.getText().equals("47") && !this.isJmolNBO && this.newNBOFile(this.inputFile, "nbo").exists()) {
            this.setInputFile(this.inputFile, "31", this.showWorkPathDone);
        }
        this.keyProp = "";
        this.reqInfo = "";
        this.keywordNumber = 0;
        p.removeAll();
        p.setLayout(new BorderLayout());
        if (this.topPanel == null) {
            this.topPanel = this.buildTopPanel();
        }
        p.add((Component)this.topPanel, "First");
        this.splitPane = new JSplitPane(1, this.searchP(true), this.searchS());
        this.splitPane.setDividerLocation(350);
        p.add((Component)this.splitPane, "Center");
        this.tfExt.setText("nbo");
        this.tfExt.setEditable(false);
        this.browse.setEnabled(true);
        this.statusLab.setText("");
        p.add((Component)this.statusPanel, "Last");
    }

    private JPanel searchP(boolean view) {
        JPanel selectPanel = new JPanel(new BorderLayout());
        this.listM = new DefaultTableModel(new String[]{""}, 20);
        Box box = Box.createHorizontalBox();
        box.add(this.folderBox());
        TitledBorder tb = new TitledBorder("Input File");
        tb.setTitleFont(titleFont);
        box.setBorder(tb);
        selectPanel.add((Component)box, "North");
        box = Box.createVerticalBox();
        final JTable opList = new JTable(this.listM){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        final JTextArea textArea = new JTextArea();
        opList.setRowHeight(27);
        opList.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    String s = value.toString();
                    if (!s.trim().startsWith("(")) {
                        textArea.setFont(new Font("Arial", 1, 14));
                        textArea.setBackground(Color.WHITE);
                    } else {
                        if (isSelected) {
                            textArea.setBackground(table.getSelectionBackground());
                        } else {
                            textArea.setBackground(Color.WHITE);
                        }
                        textArea.setFont(new Font("Arial", 0, 14));
                    }
                    textArea.setText(s);
                } else {
                    NBODialogSearch.this.listM.removeRow(row);
                }
                return textArea;
            }
        });
        final JComboBox<String> cb = new JComboBox<String>(this.keyW);
        cb.setUI(new NBODialogConfig.StyledComboBoxUI(250, 500));
        cb.setMaximumSize(new Dimension(350, 30));
        cb.setFont(new Font("MONOSPACED", 1, 14));
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogSearch.this.keywordNumber = cb.getSelectedIndex() + 1;
                NBODialogSearch.this.opBas.setVisible(false);
                NBODialogSearch.this.listClicked(NBODialogSearch.this.keywordNumber);
            }
        });
        this.keywordNumber = 1;
        this.changeKey(this.npa);
        this.home = true;
        opList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NBODialogSearch.this.goSearchClicked(opList.getSelectedRow(), opList.getValueAt(opList.getSelectedRow(), 0).toString());
            }
        });
        this.opBas = new JComboBox<String>(this.op);
        this.opBas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = NBODialogSearch.this.opBas.getSelectedItem().toString();
                NBODialogSearch.this.operator = NBODialogSearch.this.opBas.getSelectedIndex();
                NBODialogSearch.this.changeKey(NBODialogSearch.this.opBas(s.trim().split(" ")[1]));
            }
        });
        this.opBas.setVisible(false);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(opList);
        box.add(cb);
        box.add(this.opBas);
        box.add(sp);
        tb = new TitledBorder("Select Keyword");
        tb.setTitleFont(titleFont);
        box.setBorder(tb);
        box.setVisible(this.isJmolNBO);
        selectPanel.add(box);
        Box bo = Box.createHorizontalBox();
        this.viewAll = view ? new JCheckBox("View all") : null;
        return selectPanel;
    }

    private JPanel searchS() {
        this.keyProp = "";
        JPanel searchPanel = new JPanel();
        searchPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        searchPanel.setLayout(new BorderLayout());
        this.basis = new JComboBox<String>(basSet);
        this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
        this.comboBox = new JPanel(new BorderLayout());
        searchPanel.add((Component)this.comboBox, "First");
        searchPanel.add((Component)this.modelOut(), "Center");
        return searchPanel;
    }

    protected void getList1(final String get) {
        this.orbStart = 0;
        final SB sb = new SB();
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sb);
        this.appendToFile("GLOBAL I_KEYWORD " + this.keywordNumber + sep, sb);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sb);
        this.appendToFile("GLOBAL I_BAS_1 " + this.keywordNumber + sep, sb);
        final String key = get.split(" ")[0];
        this.appendToFile("CMD " + key, sb);
        this.nboService.queueJob("getSearchList", "Getting search list " + get.substring(get.indexOf("-") + 1), new Runnable(){

            @Override
            public void run() {
                NBODialogSearch.this.reqInfo = "";
                NBODialogSearch.this.nboService.rawCmdNew("s", sb, true, 33);
                String[] st = new String[NBODialogSearch.this.reqInfo.length() / 20];
                int i = 0;
                while ((i + 1) * 20 <= NBODialogSearch.this.reqInfo.length()) {
                    st[i] = NBODialogSearch.this.reqInfo.substring(i * 20, (i + 1) * 20);
                    if (key.equals("o") && NBODialogSearch.this.orbStart == 0 && !st[i].contains("(cr)")) {
                        NBODialogSearch.this.orbStart = i;
                    }
                    ++i;
                }
                NBODialogSearch.this.lists.put(get, st);
                System.out.println("created list " + get + " len=" + st.length + " " + NBODialogSearch.this.reqInfo);
                NBODialogSearch.this.reqInfo = null;
            }
        });
    }

    protected void showMessage() {
        JOptionPane.showMessageDialog(this, "Error getting lists, an error may have occured during run");
    }

    protected void setLists(final String[] get, final String[] labs) {
        this.comboBox.removeAll();
        this.nboService.queueJob("setLists", null, new Runnable(){

            @Override
            public void run() {
                JPanel l = new JPanel(new GridLayout(labs.length, 1));
                JPanel l2 = new JPanel(new GridLayout(labs.length, 1));
                for (int i = 0; i < labs.length; ++i) {
                    final String key = get[i].split(" ")[0];
                    l.add(new JLabel(labs[i]));
                    if (key.equals("b")) {
                        l2.add(new JLabel(NBODialogSearch.this.basis.getSelectedItem().toString()));
                        continue;
                    }
                    if (key.equals("o")) {
                        NBODialogSearch.this.orb = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(get[i]));
                        NBODialogSearch.this.orb.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.orb.getSelectedIndex() + 1);
                            }
                        });
                        NBODialogSearch.this.orb.setSelectedIndex(NBODialogSearch.this.orbStart);
                        l2.add(NBODialogSearch.this.orb);
                        continue;
                    }
                    if (key.equals("d") || get[i].equals("c cmo")) {
                        NBODialogSearch.this.nbo1 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(get[i]));
                        NBODialogSearch.this.nbo1.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.nbo1.getSelectedIndex() + 1);
                            }
                        });
                        NBODialogSearch.this.nbo1.setSelectedIndex(0);
                        l2.add(NBODialogSearch.this.nbo1);
                        continue;
                    }
                    if (key.equals("d'") || key.equals("n") || get[i].equals("a nbo")) {
                        NBODialogSearch.this.nbo2 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(get[i]));
                        NBODialogSearch.this.nbo2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (key.equals("n")) {
                                    NBODialogSearch.this.showOrbJmol("NBO", NBODialogSearch.this.nbo2.getSelectedIndex() + 1);
                                } else if (key.equals("a")) {
                                    NBODialogSearch.this.showOrbJmol("NBO", ((String[])NBODialogSearch.this.lists.get("d nbo")).length + 1 + NBODialogSearch.this.nbo2.getSelectedIndex());
                                } else {
                                    NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.nbo2.getSelectedIndex() + 1);
                                }
                            }
                        });
                        NBODialogSearch.this.nbo2.setSelectedIndex(0);
                        l2.add(NBODialogSearch.this.nbo2);
                        continue;
                    }
                    if (key.equals("u") || key.equals("rs")) {
                        NBODialogSearch.this.unit = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(get[i]));
                        l2.add(NBODialogSearch.this.unit);
                        continue;
                    }
                    if (key.equals("a")) {
                        NBODialogSearch.this.at1 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get(get[i]));
                        NBODialogSearch.this.at1.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (NBODialogSearch.this.at2 == null) {
                                    NBODialogSearch.this.nboService.runScriptQueued("select on; select {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]");
                                } else {
                                    NBODialogSearch.this.nboService.runScriptQueued("select on; select remove{*}; select add {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]; select add {*}[" + (NBODialogSearch.this.at2.getSelectedIndex() + 1) + "]");
                                }
                            }
                        });
                        NBODialogSearch.this.at1.setSelectedIndex(0);
                        l2.add(NBODialogSearch.this.at1);
                        continue;
                    }
                    if (key.equals("a'")) {
                        NBODialogSearch.this.at2 = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get("a"));
                        NBODialogSearch.this.at2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                NBODialogSearch.this.nboService.runScriptQueued("select on; select remove{*}; select add {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]; select add {*}[" + (NBODialogSearch.this.at2.getSelectedIndex() + 1) + "]");
                            }
                        });
                        NBODialogSearch.this.at2.setSelectedIndex(1);
                        l2.add(NBODialogSearch.this.at2);
                        continue;
                    }
                    if (key.equals("b1")) {
                        l2.add(NBODialogSearch.this.basis);
                        NBODialogSearch.this.basis.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (NBODialogSearch.this.keyProp.equals("B1B2")) {
                                    NBODialogSearch.this.basChange();
                                } else {
                                    NBODialogSearch.this.opBas(NBODialogSearch.this.opBas.getSelectedItem().toString().trim().split(" ")[1]);
                                }
                            }
                        });
                        continue;
                    }
                    if (key.equals("b2")) {
                        NBODialogSearch.this.bas2 = new JComboBox<String>(NBODialogView.basSet);
                        NBODialogSearch.this.bas2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                NBODialogSearch.this.basChange();
                            }
                        });
                        NBODialogSearch.this.bas2.setSelectedIndex(1);
                        l2.add(NBODialogSearch.this.bas2);
                        continue;
                    }
                    if (key.equals("b12")) {
                        NBODialogSearch.this.basis = new JComboBox<String>(NBODialogView.basSet);
                        NBODialogSearch.this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
                        l2.add(NBODialogSearch.this.basis);
                        continue;
                    }
                    if (key.equals("r")) {
                        NBODialogSearch.this.row = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get("r"));
                        l2.add(NBODialogSearch.this.row);
                        continue;
                    }
                    if (!key.equals("c")) continue;
                    NBODialogSearch.this.col = new JComboBox<Object>((Object[])NBODialogSearch.this.lists.get("c"));
                    l2.add(NBODialogSearch.this.col);
                }
                NBODialogSearch.this.appendOutputWithCaret(NBODialogSearch.this.keyProp + " Search Results:", 'i');
                NBODialogSearch.this.comboBox.add((Component)l, "West");
                NBODialogSearch.this.comboBox.add((Component)l2, "Center");
            }
        });
    }

    protected void basChange() {
        String[] b1b2 = new String[]{"Current (r,c) matrix element:", "  (1) current <" + this.basis.getSelectedItem().toString() + "(r)|" + this.bas2.getSelectedItem().toString() + "(c)> value", "Extremal off-diagonal values for current r(ow) orbital:", "  (2) max <" + this.basis.getSelectedItem().toString() + "(r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for current r", "  (3) min <" + this.basis.getSelectedItem().toString() + "(r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for current r", "Extremal off-diagonal values for current c(ol) orbital:", "  (4) max <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(c)> value for current c", "  (5) min <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(c)> value for current c", "Extremal off-diagonal values for any (*r,*c) orbitals:", "  (6) max <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for any *r,*c", "  (7) min <" + this.basis.getSelectedItem().toString() + "(*r)|" + this.bas2.getSelectedItem().toString() + "(*c)> value for any *r,*c"};
        this.changeKey(b1b2);
    }

    protected void changeKey(String[] s) {
        if (s.equals(this.keyW)) {
            this.home = true;
        }
        this.listM.setRowCount(s.length);
        for (int i = 0; i < s.length; ++i) {
            this.listM.setValueAt(s[i], i, 0);
        }
    }

    protected String[] opBas(String operator) {
        return new String[]{"Current [r,c] matrix element", "  (1) current <r\\" + operator + "\\c> value", "Extremal off-diagonal values for current r[ow] orbital:", "  (2) max <r\\" + operator + "\\*c> value for current r", "  (3) min <r\\" + operator + "\\*c> value for current r", "Extremal off-diagonal values for current c[ol] orbital:", "  (4) max <*r\\" + operator + "\\c> value for current c", "  (5) min <*r\\" + operator + "\\c> value for current c", "Extremal off-diagonal values for any [*r,*c] orbitals:", "  (6) max <*r\\" + operator + "\\*c> value for any *r,*c", "  (7) min <*r\\" + operator + "\\*c> value for any *r,*c"};
    }

    protected void listClicked(int index) {
        switch (index) {
            case 1: {
                this.at2 = null;
                this.basis.setSelectedIndex(2);
                this.keyProp = "NPA";
                if (this.lists.get("a") == null) {
                    this.getList1("a");
                }
                if (this.lists.get("o PNAO") == null) {
                    this.getList1("o PNAO");
                }
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists(new String[]{"b", "a", "o PNAO", "u"}, new String[]{"Basis: ", "Atom: ", "Orbital: ", "Unit: "});
                this.changeKey(this.npa);
                break;
            }
            case 2: {
                this.basis.setSelectedIndex(6);
                this.keyProp = "NBO";
                if (this.lists.get("o PNBO") == null) {
                    this.getList1("o PNBO");
                }
                this.setLists(new String[]{"b", "o PNBO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.nbo);
                break;
            }
            case 5: {
                this.basis.setSelectedIndex(8);
                this.keyProp = "NLMO";
                if (this.lists.get("o PNLMO") == null) {
                    this.getList1("o PNLMO");
                }
                this.setLists(new String[]{"b", "o PNLMO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.nlmo);
                break;
            }
            case 3: {
                this.basis.setSelectedIndex(4);
                this.keyProp = "BEND";
                if (this.lists.get("o PNHO") == null) {
                    this.getList1("o PNHO");
                }
                this.setLists(new String[]{"b", "o PNHO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.bend);
                break;
            }
            case 6: {
                this.keyProp = "NRT";
                if (this.lists.get("a") == null) {
                    this.getList1("a");
                }
                if (this.lists.get("rs") == null) {
                    this.getRs();
                }
                this.setLists("a a' rs".split(" "), new String[]{"Atom 1: ", "Atom 2: ", "Res Struct: "});
                this.changeKey(this.nrt);
                break;
            }
            case 4: {
                this.basis.setSelectedIndex(6);
                this.keyProp = "E2";
                if (this.lists.get("d nbo") == null) {
                    this.getList1("d nbo");
                }
                if (this.lists.get("a nbo") == null) {
                    this.getList1("a nbo");
                }
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists(new String[]{"b", "d nbo", "a nbo", "u"}, new String[]{"Basis: ", "d-NBO: ", "a-NBO:", "Unit: "});
                this.changeKey(this.e2);
                break;
            }
            case 7: {
                this.basis.setSelectedIndex(8);
                this.keyProp = "STERIC";
                if (this.lists.get("d nlmo") == null) {
                    this.getList1("d nlmo");
                }
                if (this.lists.get("d' nlmo") == null) {
                    this.getList1("d' nlmo");
                }
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists(new String[]{"b", "d nlmo", "d' nlmo", "u"}, new String[]{"Basis: ", "d-NLMO: ", "d'-NLMO:", "Unit: "});
                this.changeKey(this.steric);
                break;
            }
            case 8: {
                this.basis.setSelectedIndex(9);
                this.keyProp = "CMO";
                if (this.lists.get("c cmo") == null) {
                    this.getList1("c cmo");
                }
                if (this.lists.get("n") == null) {
                    this.getList1("n");
                }
                this.setLists(new String[]{"b", "c cmo", "n"}, new String[]{"Basis: ", "c-CMO: ", "n-NBO:"});
                this.changeKey(this.mo);
                break;
            }
            case 9: {
                this.basis.setSelectedIndex(8);
                this.keyProp = "DIPOLE";
                if (this.lists.get("u") == null) {
                    this.getList1("u");
                }
                this.setLists("b u".split(" "), new String[]{"Basis: ", "Unit:"});
                this.changeKey(this.dip);
                break;
            }
            case 10: {
                this.comboBox.removeAll();
                this.basis = new JComboBox<String>(basSet);
                this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
                this.basis.setEditable(false);
                this.opBas.setVisible(true);
                this.opBas.requestFocus();
                if (this.lists.get("r") == null) {
                    this.getList1("r");
                }
                if (this.lists.get("c") == null) {
                    this.getList1("c");
                }
                this.setLists("b1 r c".split(" "), new String[]{"Basis 1:", "Row:", "Collumn:"});
                this.changeKey(new String[0]);
                this.keyProp = "OPBAS";
                break;
            }
            case 11: {
                this.keyProp = "B1B2";
                if (this.lists.get("r") == null) {
                    this.getList1("r");
                }
                if (this.lists.get("c") == null) {
                    this.getList1("c");
                }
                this.setLists("b1 b2 r c".split(" "), new String[]{"Basis 1:", "Basis 2:", "Row:", "Collumn:"});
            }
        }
    }

    protected void labelAt() {
        int i;
        Logger.info(this.reqInfo);
        String[] st = this.reqInfo.trim().split(" |\\n");
        String[] st2 = new String[this.jmolAtomCount];
        for (i = 0; i < this.jmolAtomCount - 1; ++i) {
            st2[i] = st[i + 1];
            System.out.println("___" + st2[i] + "    =    " + st[i + 1]);
        }
        st2[this.jmolAtomCount - 1] = st[0];
        for (i = 0; i < this.jmolAtomCount; ++i) {
            this.nboService.runScriptQueued("select{*}[" + (i + 1) + "];label " + st2[i]);
        }
    }

    private void getRs() {
        final SB sb = new SB();
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sb);
        this.appendToFile("GLOBAL I_KEYWORD " + this.keywordNumber + sep, sb);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sb);
        this.appendToFile("GLOBAL I_BAS_1 " + this.keywordNumber + sep, sb);
        this.appendToFile("CMD  r", sb);
        this.nboService.queueJob("search", "getting resonance structures", new Runnable(){

            @Override
            public void run() {
                NBODialogSearch.this.reqInfo = "";
                NBODialogSearch.this.nboService.rawCmdNew("s", sb, true, 47);
                int r = Integer.parseInt(NBODialogSearch.this.reqInfo.substring(NBODialogSearch.this.reqInfo.lastIndexOf("-") + 1, NBODialogSearch.this.reqInfo.indexOf(")")));
                System.out.println("...." + r);
                String[] st = new String[r];
                for (int i = 0; i < r; ++i) {
                    st[i] = i + 1 + ". R.S. " + (i + 1);
                }
                NBODialogSearch.this.lists.put("rs", st);
            }
        });
    }

    protected void goSearchClicked(int index, String str) {
        final SB sb = new SB();
        this.appendToFile("GLOBAL I_KEYWORD " + this.keywordNumber + sep, sb);
        if (str.indexOf("(") < 0) {
            return;
        }
        int op = Integer.parseInt(str.substring(str.indexOf("(") + 1, str.indexOf(")")));
        boolean isImage = false;
        boolean isLabel = false;
        boolean isDrawing = false;
        switch (this.keywordNumber) {
            case 1: {
                this.appendToFile("GLOBAL I_ATOM_1 " + (this.at1.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sb);
                isImage = op == 11;
                isLabel = op == 12;
                break;
            }
            case 2: {
                isDrawing = op == 8;
                isImage = op == 7;
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 3: {
                isImage = op == 8;
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 4: {
                isImage = op == 7;
                this.appendToFile("GLOBAL I_d_NBO_1 " + (this.nbo1.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_a_NBO " + (this.nbo2.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 5: {
                isImage = op == 7;
                this.appendToFile("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 6: {
                this.appendToFile("GLOBAL I_ATOM_1 " + (this.at1.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_ATOM_2 " + (this.at2.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_RES_STR " + (this.unit.getSelectedIndex() + 1) + sep, sb);
                isLabel = op == 9 || op == 10;
                break;
            }
            case 7: {
                isImage = op == 8;
                this.appendToFile("GLOBAL I_d_NBO_1 " + (this.nbo1.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_d_NBO_2 " + (this.nbo2.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 8: {
                isImage = op == 9 || op == 8;
                this.appendToFile("GLOBAL I_CMO " + (this.nbo1.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_NBO " + (this.nbo2.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 9: {
                this.appendToFile("GLOBAL I_UNIT " + (this.unit.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 10: {
                this.appendToFile("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_OPERATOR " + this.operator + sep, sb);
                this.appendToFile("GLOBAL I_ROW " + (this.row.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_COLUMN " + (this.col.getSelectedIndex() + 1) + sep, sb);
                break;
            }
            case 11: {
                this.appendToFile("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_BAS_2 " + (this.bas2.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_ROW " + (this.row.getSelectedIndex() + 1) + sep, sb);
                this.appendToFile("GLOBAL I_COLUMN " + (this.col.getSelectedIndex() + 1) + sep, sb);
            }
        }
        if (this.viewAll != null && this.viewAll.isSelected() && (this.keyProp.equals("NPA") && op <= 9 || op <= 4)) {
            this.appendToFile("GLOBAL I_STAR 1" + sep, sb);
        }
        this.appendToFile("GLOBAL I_OPT_" + this.keyProp + " " + op, sb);
        if (isImage) {
            this.nboService.queueJob("search", "Raytracing, please be patient...", new Runnable(){

                @Override
                public void run() {
                    File f = new File(new File(NBODialogSearch.this.nboService.serverPath).getParent() + "\\pic.bmp");
                    if (f.exists()) {
                        f.delete();
                    }
                    System.out.println("-----" + f.toString());
                    NBODialogSearch.this.nboService.rawCmdNew("s", sb, false, 88);
                    while (!f.exists()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    try {
                        NBODialogSearch.this.nboService.runScriptQueued("image id pic close; image id pic \"" + f.toString().replaceAll("\\\\", "/") + "\"");
                        NBODialogSearch.this.statusLab.setText("");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (isLabel) {
            this.nboService.queueJob("search", "getting list...", new Runnable(){

                @Override
                public void run() {
                    NBODialogSearch.this.reqInfo = "";
                    NBODialogSearch.this.nboService.rawCmdNew("s", sb, false, 46);
                    while (NBODialogSearch.this.reqInfo.trim().split(" |\\n").length < NBODialogSearch.this.jmolAtomCount) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    try {
                        NBODialogSearch.this.labelAt();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (isDrawing) {
            this.nboService.runScriptQueued("select {*}; show drawing");
        } else {
            this.nboService.queueJob("search", "getting value...", new Runnable(){

                @Override
                public void run() {
                    NBODialogSearch.this.reqInfo = "";
                    NBODialogSearch.this.nboService.rawCmdNew("s", sb, false, 45);
                    NBODialogSearch.this.appendOutputWithCaret("  " + NBODialogSearch.this.reqInfo, 'b');
                }
            });
        }
    }

    protected void notifyCallbackS(int atomIndex) {
        if (this.at1 != null && this.at2 == null) {
            this.at1.setSelectedIndex(atomIndex);
        } else if (this.at1 != null && this.at2 != null) {
            if (this.secondPick) {
                this.at1.setSelectedIndex(atomIndex);
                this.secondPick = false;
            } else {
                this.at2.setSelectedIndex(atomIndex);
                this.secondPick = true;
            }
        }
    }

    protected void rawInputS(String cmd) {
        if (cmd.startsWith("O ")) {
            try {
                int i = Integer.parseInt(cmd.split(" ")[1]);
                this.orb.setSelectedIndex(i - 1);
            }
            catch (Exception e) {
                this.appendOutputWithCaret("Invalid command", 'i');
            }
        } else if (cmd.startsWith("A ")) {
            try {
                int i = Integer.parseInt(cmd.split(" ")[1]);
                this.at1.setSelectedIndex(i - 1);
            }
            catch (Exception e) {
                this.appendOutputWithCaret("Invalid command", 'i');
            }
        } else {
            try {
                int i = Integer.parseInt(cmd);
                this.goSearchClicked(i, "(" + i + ")");
            }
            catch (Exception e) {
                this.appendOutputWithCaret("Invalid command", 'i');
            }
        }
    }
}

