/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetClosedException
extends OsmTransferException {
    public static final String ERROR_HEADER_PATTERN = "The changeset (\\d+) was closed at (.*)";
    private long changesetId;
    private Date closedOn;
    private Source source;

    public static boolean errorHeaderMatchesPattern(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(ERROR_HEADER_PATTERN);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    protected final void parseErrorHeader(String string) {
        Pattern pattern = Pattern.compile(ERROR_HEADER_PATTERN);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.changesetId = Long.parseLong(matcher.group(1));
            try {
                this.closedOn = DateUtils.newOsmApiDateTimeFormat().parse(matcher.group(2));
            }
            catch (ParseException parseException) {
                Main.error(I18n.tr("Failed to parse date ''{0}'' replied by server.", matcher.group(2)));
                Main.error(parseException);
            }
        } else {
            Main.error(I18n.tr("Unexpected format of error header for conflict in changeset update. Got ''{0}''", string));
        }
    }

    public ChangesetClosedException(String string) {
        super(string);
        this.parseErrorHeader(string);
        this.source = Source.UNSPECIFIED;
    }

    public ChangesetClosedException(String string, Source source) {
        super(string);
        this.parseErrorHeader(string);
        this.source = source == null ? Source.UNSPECIFIED : source;
    }

    public ChangesetClosedException(long l, Date date, Source source) {
        super("");
        this.source = source == null ? Source.UNSPECIFIED : source;
        this.changesetId = l;
        this.closedOn = date;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public Date getClosedOn() {
        return this.closedOn;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source == null ? Source.UNSPECIFIED : source;
    }

    public static enum Source {
        UPDATE_CHANGESET,
        UPLOAD_DATA,
        UNSPECIFIED;

    }
}

