/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import writer2latex.api.Converter;
import writer2latex.api.ConverterResult;
import writer2latex.api.GraphicConverter;
import writer2latex.api.OutputFile;
import writer2latex.base.ConverterResultImpl;
import writer2latex.base.ImageConverter;
import writer2latex.office.EmbeddedObject;
import writer2latex.office.MetaData;
import writer2latex.office.OfficeDocument;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;

public abstract class ConverterBase
implements Converter {
    protected GraphicConverter graphicConverter = null;
    protected OfficeDocument odDoc;
    protected OfficeReader ofr;
    protected MetaData metaData;
    protected ImageConverter imageConverter;
    protected String sTargetFileName;
    protected ConverterResultImpl converterResult = new ConverterResultImpl();

    @Override
    public void setGraphicConverter(GraphicConverter graphicConverter) {
        this.graphicConverter = graphicConverter;
    }

    @Override
    public void readTemplate(InputStream is) throws IOException {
    }

    @Override
    public void readTemplate(File file) throws IOException {
    }

    @Override
    public void readStyleSheet(InputStream is) throws IOException {
    }

    @Override
    public void readStyleSheet(File file) throws IOException {
    }

    @Override
    public void readResource(InputStream is, String sFileName, String sMediaType) throws IOException {
    }

    @Override
    public void readResource(File file, String sFileName, String sMediaType) throws IOException {
    }

    @Override
    public ConverterResult convert(File source, String sTargetFileName) throws FileNotFoundException, IOException {
        return this.convert(new FileInputStream(source), sTargetFileName);
    }

    @Override
    public ConverterResult convert(InputStream is, String sTargetFileName) throws IOException {
        this.odDoc = new OfficeDocument();
        this.odDoc.read(is);
        return this.convert(sTargetFileName, true);
    }

    @Override
    public ConverterResult convert(Document dom, String sTargetFileName, boolean bDestructive) throws IOException {
        this.odDoc = new OfficeDocument();
        this.odDoc.read(dom);
        return this.convert(sTargetFileName, bDestructive);
    }

    private ConverterResult convert(String sTargetFileName, boolean bDestructive) throws IOException {
        this.ofr = new OfficeReader(this.odDoc, false);
        this.metaData = new MetaData(this.odDoc);
        this.imageConverter = new ImageConverter(this.ofr, bDestructive, true);
        this.imageConverter.setGraphicConverter(this.graphicConverter);
        this.sTargetFileName = sTargetFileName;
        this.converterResult.reset();
        this.converterResult.setMetaData(this.metaData);
        if (this.metaData.getLanguage() == null || this.metaData.getLanguage().length() == 0) {
            this.metaData.setLanguage(this.ofr.getMajorityLanguage());
        }
        this.convertInner();
        return this.converterResult;
    }

    public abstract void convertInner() throws IOException;

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ImageConverter getImageCv() {
        return this.imageConverter;
    }

    public void addDocument(OutputFile doc) {
        this.converterResult.addDocument(doc);
    }

    public EmbeddedObject getEmbeddedObject(String sHref) {
        return this.odDoc.getEmbeddedObject(sHref);
    }

    public Element getTexMathsEquation(Element node) {
        Element svgTitle = Misc.getChildByTagName(node, "svg:title");
        if (svgTitle != null && "TexMaths".equals(Misc.getPCDATA(svgTitle))) {
            return Misc.getChildByTagName(node, "svg:desc");
        }
        return null;
    }

    public TexMathsStyle getTexMathsStyle(String s) {
        String[] sContent = s.split("\u00a7");
        if (sContent.length >= 3) {
            if ("display".equals(sContent[1])) {
                return TexMathsStyle.display;
            }
            if ("latex".equals(sContent[1]) || "text".equals(sContent[1])) {
                return TexMathsStyle.latex;
            }
        }
        return TexMathsStyle.inline;
    }

    public String getTexMathsEquation(String s) {
        String[] sContent = s.split("\u00a7");
        if (sContent.length >= 3) {
            return sContent[2];
        }
        return "";
    }

    public static enum TexMathsStyle {
        inline,
        display,
        latex;

    }
}

