# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.6
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
This is a wrapper for The CD Input and Control library (libcdio) which
encapsulates CD-ROM reading and control. Python programs wishing to be
oblivious of the OS- and device-dependent properties of a CD-ROM can
use this library.
"""


from sys import version_info
if version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pycdio', [dirname(__file__)])
        except ImportError:
            import _pycdio
            return _pycdio
        if fp is not None:
            try:
                _mod = imp.load_module('_pycdio', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _pycdio = swig_import_helper()
    del swig_import_helper
else:
    import _pycdio
del version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.


def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr_nondynamic(self, class_type, name, static=1):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    if (not static):
        return object.__getattr__(self, name)
    else:
        raise AttributeError(name)

def _swig_getattr(self, class_type, name):
    return _swig_getattr_nondynamic(self, class_type, name, 0)


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object:
        pass
    _newclass = 0


class imaxdiv_t(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, imaxdiv_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, imaxdiv_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["quot"] = _pycdio.imaxdiv_t_quot_set
    __swig_getmethods__["quot"] = _pycdio.imaxdiv_t_quot_get
    if _newclass:
        quot = _swig_property(_pycdio.imaxdiv_t_quot_get, _pycdio.imaxdiv_t_quot_set)
    __swig_setmethods__["rem"] = _pycdio.imaxdiv_t_rem_set
    __swig_getmethods__["rem"] = _pycdio.imaxdiv_t_rem_get
    if _newclass:
        rem = _swig_property(_pycdio.imaxdiv_t_rem_get, _pycdio.imaxdiv_t_rem_set)

    def __init__(self):
        """
        get_num_tracks(p_cdio)->int

        Return the number of tracks on the CD. 
        On error pycdio.INVALID_TRACK is returned.
        """
        this = _pycdio.new_imaxdiv_t()
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _pycdio.delete_imaxdiv_t
    __del__ = lambda self: None
imaxdiv_t_swigregister = _pycdio.imaxdiv_t_swigregister
imaxdiv_t_swigregister(imaxdiv_t)


def imaxabs(n):
    return _pycdio.imaxabs(n)
imaxabs = _pycdio.imaxabs

def imaxdiv(numer, denom):
    return _pycdio.imaxdiv(numer, denom)
imaxdiv = _pycdio.imaxdiv

def wcstoimax(nptr, endptr, base):
    return _pycdio.wcstoimax(nptr, endptr, base)
wcstoimax = _pycdio.wcstoimax

def wcstoumax(nptr, endptr, base):
    return _pycdio.wcstoumax(nptr, endptr, base)
wcstoumax = _pycdio.wcstoumax

def strtoimax(nptr, endptr, base):
    return _pycdio.strtoimax(nptr, endptr, base)
strtoimax = _pycdio.strtoimax

def strtoumax(nptr, endptr, base):
    return _pycdio.strtoumax(nptr, endptr, base)
strtoumax = _pycdio.strtoumax

_pycdio.VERSION_NUM_swigconstant(_pycdio)
VERSION_NUM = _pycdio.VERSION_NUM

_pycdio.INVALID_LBA_swigconstant(_pycdio)
INVALID_LBA = _pycdio.INVALID_LBA

_pycdio.INVALID_LSN_swigconstant(_pycdio)
INVALID_LSN = _pycdio.INVALID_LSN

_pycdio.CD_FRAMESIZE_swigconstant(_pycdio)
CD_FRAMESIZE = _pycdio.CD_FRAMESIZE

_pycdio.CD_FRAMESIZE_RAW_swigconstant(_pycdio)
CD_FRAMESIZE_RAW = _pycdio.CD_FRAMESIZE_RAW

_pycdio.ISO_BLOCKSIZE_swigconstant(_pycdio)
ISO_BLOCKSIZE = _pycdio.ISO_BLOCKSIZE

_pycdio.M2F2_SECTOR_SIZE_swigconstant(_pycdio)
M2F2_SECTOR_SIZE = _pycdio.M2F2_SECTOR_SIZE

_pycdio.M2RAW_SECTOR_SIZE_swigconstant(_pycdio)
M2RAW_SECTOR_SIZE = _pycdio.M2RAW_SECTOR_SIZE

def audio_pause(p_cdio):
    """
    audio_pause(cdio)->status

    Pause playing CD through analog output.
    """
    return _pycdio.audio_pause(p_cdio)

def audio_play_lsn(p_cdio, start_lsn, end_lsn):
    """
    auto_play_lsn(cdio, start_lsn, end_lsn)->status

    Playing CD through analog output at the given lsn to the ending lsn
    """
    return _pycdio.audio_play_lsn(p_cdio, start_lsn, end_lsn)

def audio_resume(p_cdio):
    """
    audio_resume(cdio)->status
    Resume playing an audio CD.
    """
    return _pycdio.audio_resume(p_cdio)

def audio_set_volume_levels(p_cdio, vol1, vol2, arg4, arg5):
    """
    audio_resume(cdio)->status
    Resume playing an audio CD.
    """
    return _pycdio.audio_set_volume_levels(p_cdio, vol1, vol2, arg4, arg5)

def audio_stop(p_cdio):
    """
    audio_stop(cdio)->status
    Stop playing an audio CD.
    """
    return _pycdio.audio_stop(p_cdio)

_pycdio.READ_MODE_AUDIO_swigconstant(_pycdio)
READ_MODE_AUDIO = _pycdio.READ_MODE_AUDIO

_pycdio.READ_MODE_M1F1_swigconstant(_pycdio)
READ_MODE_M1F1 = _pycdio.READ_MODE_M1F1

_pycdio.READ_MODE_M1F2_swigconstant(_pycdio)
READ_MODE_M1F2 = _pycdio.READ_MODE_M1F2

_pycdio.READ_MODE_M2F1_swigconstant(_pycdio)
READ_MODE_M2F1 = _pycdio.READ_MODE_M2F1

_pycdio.READ_MODE_M2F2_swigconstant(_pycdio)
READ_MODE_M2F2 = _pycdio.READ_MODE_M2F2

def lseek(*args):
    """
    lseek(cdio, offset, whence)->int
    Reposition read offset
    Similar to (if not the same as) libc's fseek()

    cdio is object to get adjested, offset is amount to seek and 
    whence is like corresponding parameter in libc's lseek, e.g. 
    it should be SEEK_SET or SEEK_END.

    the offset is returned or -1 on error.
    """
    return _pycdio.lseek(*args)

def read_cd(p_cdio, p_buf):
    """
    read_cd(cdio, size)->[size, data]

    Reads into buf the next size bytes.
    Similar to (if not the same as) libc's read()

    The number of reads read is returned. -1 is returned on error.
    """
    return _pycdio.read_cd(p_cdio, p_buf)

def read_sectors(p_cdio, p_buf, i_lsn, read_mode):
    """
    read_sectors(bytes, lsn, read_mode)->[size, data]
    Reads a number of sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.

    If read_mode is pycdio.MODE_AUDIO, the return buffer size will be
    truncated to multiple of pycdio.CDIO_FRAMESIZE_RAW i_blocks bytes.

    If read_mode is pycdio.MODE_DATA, buffer will be truncated to a
    multiple of pycdio.ISO_BLOCKSIZE, pycdio.M1RAW_SECTOR_SIZE or
    pycdio.M2F2_SECTOR_SIZE bytes depending on what mode the data is in.
    If read_mode is pycdio.CDIO_MODE_M2F1, buffer will be truncated to a 
    multiple of pycdio.M2RAW_SECTOR_SIZE bytes.

    If read_mode is CDIO_MODE_M2F2, the return buffer size will be
    truncated to a multiple of pycdio.CD_FRAMESIZE bytes.

    If size <= 0 an error has occurred.
    """
    return _pycdio.read_sectors(p_cdio, p_buf, i_lsn, read_mode)

def read_data_bytes(p_cdio, p_buf, i_lsn, i_blocksize):
    """
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
    return _pycdio.read_data_bytes(p_cdio, p_buf, i_lsn, i_blocksize)

_pycdio.TRACK_FORMAT_AUDIO_swigconstant(_pycdio)
TRACK_FORMAT_AUDIO = _pycdio.TRACK_FORMAT_AUDIO

_pycdio.TRACK_FORMAT_CDI_swigconstant(_pycdio)
TRACK_FORMAT_CDI = _pycdio.TRACK_FORMAT_CDI

_pycdio.TRACK_FORMAT_XA_swigconstant(_pycdio)
TRACK_FORMAT_XA = _pycdio.TRACK_FORMAT_XA

_pycdio.TRACK_FORMAT_DATA_swigconstant(_pycdio)
TRACK_FORMAT_DATA = _pycdio.TRACK_FORMAT_DATA

_pycdio.TRACK_FORMAT_PSX_swigconstant(_pycdio)
TRACK_FORMAT_PSX = _pycdio.TRACK_FORMAT_PSX

_pycdio.CDIO_TRACK_FLAG_FALSE_swigconstant(_pycdio)
CDIO_TRACK_FLAG_FALSE = _pycdio.CDIO_TRACK_FLAG_FALSE

_pycdio.CDIO_TRACK_FLAG_TRUE_swigconstant(_pycdio)
CDIO_TRACK_FLAG_TRUE = _pycdio.CDIO_TRACK_FLAG_TRUE

_pycdio.CDIO_TRACK_FLAG_ERROR_swigconstant(_pycdio)
CDIO_TRACK_FLAG_ERROR = _pycdio.CDIO_TRACK_FLAG_ERROR

_pycdio.CDIO_TRACK_FLAG_UNKNOWN_swigconstant(_pycdio)
CDIO_TRACK_FLAG_UNKNOWN = _pycdio.CDIO_TRACK_FLAG_UNKNOWN

_pycdio.CDIO_CDROM_LBA_swigconstant(_pycdio)
CDIO_CDROM_LBA = _pycdio.CDIO_CDROM_LBA

_pycdio.CDIO_CDROM_MSF_swigconstant(_pycdio)
CDIO_CDROM_MSF = _pycdio.CDIO_CDROM_MSF

_pycdio.CDIO_CDROM_DATA_TRACK_swigconstant(_pycdio)
CDIO_CDROM_DATA_TRACK = _pycdio.CDIO_CDROM_DATA_TRACK

_pycdio.CDIO_CDROM_CDI_TRACK_swigconstant(_pycdio)
CDIO_CDROM_CDI_TRACK = _pycdio.CDIO_CDROM_CDI_TRACK

_pycdio.CDIO_CDROM_XA_TRACK_swigconstant(_pycdio)
CDIO_CDROM_XA_TRACK = _pycdio.CDIO_CDROM_XA_TRACK

_pycdio.AUDIO_swigconstant(_pycdio)
AUDIO = _pycdio.AUDIO

_pycdio.MODE1_swigconstant(_pycdio)
MODE1 = _pycdio.MODE1

_pycdio.MODE1_RAW_swigconstant(_pycdio)
MODE1_RAW = _pycdio.MODE1_RAW

_pycdio.MODE2_swigconstant(_pycdio)
MODE2 = _pycdio.MODE2

_pycdio.MODE2_FORM1_swigconstant(_pycdio)
MODE2_FORM1 = _pycdio.MODE2_FORM1

_pycdio.MODE2_FORM2_swigconstant(_pycdio)
MODE2_FORM2 = _pycdio.MODE2_FORM2

_pycdio.MODE2_FORM_MIX_swigconstant(_pycdio)
MODE2_FORM_MIX = _pycdio.MODE2_FORM_MIX

_pycdio.MODE2_RAW_swigconstant(_pycdio)
MODE2_RAW = _pycdio.MODE2_RAW

_pycdio.INVALID_TRACK_swigconstant(_pycdio)
INVALID_TRACK = _pycdio.INVALID_TRACK

_pycdio.CDROM_LEADOUT_TRACK_swigconstant(_pycdio)
CDROM_LEADOUT_TRACK = _pycdio.CDROM_LEADOUT_TRACK

def get_first_track_num(p_cdio):
    """
    get_first_track_num(p_cdio) -> int
    Get the number of the first track. 

    return the track number or pycdio.INVALID_TRACK if there was
    a problem.
    """
    return _pycdio.get_first_track_num(p_cdio)

def get_last_track_num(p_cdio):
    """
    get_last_track_num 
    Return the last track number.
    pycdio.INVALID_TRACK is if there was a problem.
    """
    return _pycdio.get_last_track_num(p_cdio)

def get_track(p_cdio, lsn):
    """
    cdio_get_track(lsn)->int

        Find the track which contains lsn.
        pycdio.INVALID_TRACK is returned if the lsn outside of the CD or
        if there was some error. 

        If the lsn is before the pregap of the first track, 0 is returned.
        Otherwise we return the track that spans the lsn.
    """
    return _pycdio.get_track(p_cdio, lsn)

def get_track_channels(p_cdio, i_track):
    """
    get_track_channels(cdio, track)->int

    Return number of channels in track: 2 or 4; -2 if implemented or -1
    for error.  Not meaningful if track is not an audio track.
    """
    return _pycdio.get_track_channels(p_cdio, i_track)

def get_track_copy_permit(p_cdio, i_track):
    """
    get_copy_permit(cdio, track)->int

    Return copy protection status on a track. Is this meaningful 
    not an audio track?

    """
    return _pycdio.get_track_copy_permit(p_cdio, i_track)

def get_track_format(p_cdio, i_track):
    """
    get_track_format(cdio, track)->format

    Get the format (audio, mode2, mode1) of track. 
    """
    return _pycdio.get_track_format(p_cdio, i_track)

def is_track_green(p_cdio, i_track):
    """
    is_track_green(cdio, track) -> bool

    Return True if we have XA data (green, mode2 form1) or
    XA data (green, mode2 form2). That is track begins:
     sync - header - subheader
    12     4      -  8

    FIXME: there's gotta be a better design for this and get_track_format?
    """
    return _pycdio.is_track_green(p_cdio, i_track)

def get_track_last_lsn(p_cdio, i_track):
    """
    cdio_get_track_last_lsn(cdio, track)->lsn

    Return the ending LSN for track number
    track in cdio.  CDIO_INVALID_LSN is returned on error.
    """
    return _pycdio.get_track_last_lsn(p_cdio, i_track)

def get_track_lba(p_cdio, i_track):
    """
    cdio_get_track_lba  
        Get the starting LBA for track number
        i_track in p_cdio.  Track numbers usually start at something 
        greater than 0, usually 1.

        The 'leadout' track is specified either by
        using i_track CDIO_CDROM_LEADOUT_TRACK or the total tracks+1.

        @param p_cdio object to get information from
        @param i_track  the track number we want the LSN for
        @return the starting LBA or CDIO_INVALID_LBA on error.
    """
    return _pycdio.get_track_lba(p_cdio, i_track)

def get_track_lsn(p_cdio, i_track):
    """
    cdio_get_track_lsn (cdio, track)->int

    Return the starting LSN for track number. 
    Track numbers usually start at something greater than 0, usually 1.

    The 'leadout' track is specified either by
    using i_track pycdio.CDROM_LEADOUT_TRACK or the total tracks+1.

    pycdio.INVALID_LSN is returned on error.
    """
    return _pycdio.get_track_lsn(p_cdio, i_track)

def get_track_msf(p_cdio, i_track):
    """
    get_track_msf(cdio,track)->string

      Return the starting MSF (minutes/secs/frames) for track number
      track.  Track numbers usually start at something 
      greater than 0, usually 1.

      The 'leadout' track is specified either by
      using i_track CDIO_CDROM_LEADOUT_TRACK or the total tracks+1.

    @return string mm:ss:ff if all good, or string 'error' on error.
    """
    return _pycdio.get_track_msf(p_cdio, i_track)

def get_track_preemphasis(p_cdio, i_track):
    """
    cdio_get_track_preemphasis(cdio, track)

    Get linear preemphasis status on an audio track.
    This is not meaningful if not an audio track?
    """
    return _pycdio.get_track_preemphasis(p_cdio, i_track)

def get_track_sec_count(p_cdio, i_track):
    """
    get_track_sec_count(cdio, track)->int

    Get the number of sectors between this track an the next.  This
    includes any pregap sectors before the start of the next track.
    Track numbers usually start at something 
    greater than 0, usually 1.

    0 is returned if there is an error.
    """
    return _pycdio.get_track_sec_count(p_cdio, i_track)

_pycdio.CDTEXT_ARRANGER_swigconstant(_pycdio)
CDTEXT_ARRANGER = _pycdio.CDTEXT_ARRANGER

_pycdio.CDTEXT_COMPOSER_swigconstant(_pycdio)
CDTEXT_COMPOSER = _pycdio.CDTEXT_COMPOSER

_pycdio.CDTEXT_DISCID_swigconstant(_pycdio)
CDTEXT_DISCID = _pycdio.CDTEXT_DISCID

_pycdio.CDTEXT_ISRC_swigconstant(_pycdio)
CDTEXT_ISRC = _pycdio.CDTEXT_ISRC

_pycdio.CDTEXT_MESSAGE_swigconstant(_pycdio)
CDTEXT_MESSAGE = _pycdio.CDTEXT_MESSAGE

_pycdio.CDTEXT_PERFORMER_swigconstant(_pycdio)
CDTEXT_PERFORMER = _pycdio.CDTEXT_PERFORMER

_pycdio.CDTEXT_FIELD_TITLE_swigconstant(_pycdio)
CDTEXT_FIELD_TITLE = _pycdio.CDTEXT_FIELD_TITLE

_pycdio.CDTEXT_FIELD_SONGWRITER_swigconstant(_pycdio)
CDTEXT_FIELD_SONGWRITER = _pycdio.CDTEXT_FIELD_SONGWRITER

_pycdio.CDTEXT_FIELD_UPC_EAN_swigconstant(_pycdio)
CDTEXT_FIELD_UPC_EAN = _pycdio.CDTEXT_FIELD_UPC_EAN

_pycdio.CDTEXT_GENRE_swigconstant(_pycdio)
CDTEXT_GENRE = _pycdio.CDTEXT_GENRE

_pycdio.CDTEXT_FIELD_INVALID_swigconstant(_pycdio)
CDTEXT_FIELD_INVALID = _pycdio.CDTEXT_FIELD_INVALID

_pycdio.CDTEXT_GENRE_UNUSED_swigconstant(_pycdio)
CDTEXT_GENRE_UNUSED = _pycdio.CDTEXT_GENRE_UNUSED

_pycdio.CDTEXT_GENRE_UNDEFINED_swigconstant(_pycdio)
CDTEXT_GENRE_UNDEFINED = _pycdio.CDTEXT_GENRE_UNDEFINED

_pycdio.CDTEXT_GENRE_ADULT_CONTEMP_swigconstant(_pycdio)
CDTEXT_GENRE_ADULT_CONTEMP = _pycdio.CDTEXT_GENRE_ADULT_CONTEMP

_pycdio.CDTEXT_GENRE_ALT_ROCK_swigconstant(_pycdio)
CDTEXT_GENRE_ALT_ROCK = _pycdio.CDTEXT_GENRE_ALT_ROCK

_pycdio.CDTEXT_GENRE_CHILDRENS_swigconstant(_pycdio)
CDTEXT_GENRE_CHILDRENS = _pycdio.CDTEXT_GENRE_CHILDRENS

_pycdio.CDTEXT_GENRE_CLASSIC_swigconstant(_pycdio)
CDTEXT_GENRE_CLASSIC = _pycdio.CDTEXT_GENRE_CLASSIC

_pycdio.CDTEXT_GENRE_CHRIST_CONTEMP_swigconstant(_pycdio)
CDTEXT_GENRE_CHRIST_CONTEMP = _pycdio.CDTEXT_GENRE_CHRIST_CONTEMP

_pycdio.CDTEXT_GENRE_COUNTRY_swigconstant(_pycdio)
CDTEXT_GENRE_COUNTRY = _pycdio.CDTEXT_GENRE_COUNTRY

_pycdio.CDTEXT_GENRE_DANCE_swigconstant(_pycdio)
CDTEXT_GENRE_DANCE = _pycdio.CDTEXT_GENRE_DANCE

_pycdio.CDTEXT_GENRE_EASY_LISTENING_swigconstant(_pycdio)
CDTEXT_GENRE_EASY_LISTENING = _pycdio.CDTEXT_GENRE_EASY_LISTENING

_pycdio.CDTEXT_GENRE_EROTIC_swigconstant(_pycdio)
CDTEXT_GENRE_EROTIC = _pycdio.CDTEXT_GENRE_EROTIC

_pycdio.CDTEXT_GENRE_FOLK_swigconstant(_pycdio)
CDTEXT_GENRE_FOLK = _pycdio.CDTEXT_GENRE_FOLK

_pycdio.CDTEXT_GENRE_GOSPEL_swigconstant(_pycdio)
CDTEXT_GENRE_GOSPEL = _pycdio.CDTEXT_GENRE_GOSPEL

_pycdio.CDTEXT_GENRE_HIPHOP_swigconstant(_pycdio)
CDTEXT_GENRE_HIPHOP = _pycdio.CDTEXT_GENRE_HIPHOP

_pycdio.CDTEXT_GENRE_JAZZ_swigconstant(_pycdio)
CDTEXT_GENRE_JAZZ = _pycdio.CDTEXT_GENRE_JAZZ

_pycdio.CDTEXT_GENRE_LATIN_swigconstant(_pycdio)
CDTEXT_GENRE_LATIN = _pycdio.CDTEXT_GENRE_LATIN

_pycdio.CDTEXT_GENRE_MUSICAL_swigconstant(_pycdio)
CDTEXT_GENRE_MUSICAL = _pycdio.CDTEXT_GENRE_MUSICAL

_pycdio.CDTEXT_GENRE_NEWAGE_swigconstant(_pycdio)
CDTEXT_GENRE_NEWAGE = _pycdio.CDTEXT_GENRE_NEWAGE

_pycdio.CDTEXT_GENRE_OPERA_swigconstant(_pycdio)
CDTEXT_GENRE_OPERA = _pycdio.CDTEXT_GENRE_OPERA

_pycdio.CDTEXT_GENRE_OPERETTA_swigconstant(_pycdio)
CDTEXT_GENRE_OPERETTA = _pycdio.CDTEXT_GENRE_OPERETTA

_pycdio.CDTEXT_GENRE_POP_swigconstant(_pycdio)
CDTEXT_GENRE_POP = _pycdio.CDTEXT_GENRE_POP

_pycdio.CDTEXT_GENRE_RAP_swigconstant(_pycdio)
CDTEXT_GENRE_RAP = _pycdio.CDTEXT_GENRE_RAP

_pycdio.CDTEXT_GENRE_REGGAE_swigconstant(_pycdio)
CDTEXT_GENRE_REGGAE = _pycdio.CDTEXT_GENRE_REGGAE

_pycdio.CDTEXT_GENRE_ROCK_swigconstant(_pycdio)
CDTEXT_GENRE_ROCK = _pycdio.CDTEXT_GENRE_ROCK

_pycdio.CDTEXT_GENRE_RYTHMANDBLUES_swigconstant(_pycdio)
CDTEXT_GENRE_RYTHMANDBLUES = _pycdio.CDTEXT_GENRE_RYTHMANDBLUES

_pycdio.CDTEXT_GENRE_SOUNDEFFECTS_swigconstant(_pycdio)
CDTEXT_GENRE_SOUNDEFFECTS = _pycdio.CDTEXT_GENRE_SOUNDEFFECTS

_pycdio.CDTEXT_GENRE_SOUNDTRACK_swigconstant(_pycdio)
CDTEXT_GENRE_SOUNDTRACK = _pycdio.CDTEXT_GENRE_SOUNDTRACK

_pycdio.CDTEXT_GENRE_SPOKEN_WORD_swigconstant(_pycdio)
CDTEXT_GENRE_SPOKEN_WORD = _pycdio.CDTEXT_GENRE_SPOKEN_WORD

_pycdio.CDTEXT_GENRE_WORLD_MUSIC_swigconstant(_pycdio)
CDTEXT_GENRE_WORLD_MUSIC = _pycdio.CDTEXT_GENRE_WORLD_MUSIC

_pycdio.CDTEXT_LANGUAGE_UNKNOWN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_UNKNOWN = _pycdio.CDTEXT_LANGUAGE_UNKNOWN

_pycdio.CDTEXT_LANGUAGE_ALBANIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ALBANIAN = _pycdio.CDTEXT_LANGUAGE_ALBANIAN

_pycdio.CDTEXT_LANGUAGE_BRETON_swigconstant(_pycdio)
CDTEXT_LANGUAGE_BRETON = _pycdio.CDTEXT_LANGUAGE_BRETON

_pycdio.CDTEXT_LANGUAGE_CATALAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_CATALAN = _pycdio.CDTEXT_LANGUAGE_CATALAN

_pycdio.CDTEXT_LANGUAGE_CROATIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_CROATIAN = _pycdio.CDTEXT_LANGUAGE_CROATIAN

_pycdio.CDTEXT_LANGUAGE_WELSH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_WELSH = _pycdio.CDTEXT_LANGUAGE_WELSH

_pycdio.CDTEXT_LANGUAGE_CZECH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_CZECH = _pycdio.CDTEXT_LANGUAGE_CZECH

_pycdio.CDTEXT_LANGUAGE_DANISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_DANISH = _pycdio.CDTEXT_LANGUAGE_DANISH

_pycdio.CDTEXT_LANGUAGE_GERMAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_GERMAN = _pycdio.CDTEXT_LANGUAGE_GERMAN

_pycdio.CDTEXT_LANGUAGE_ENGLISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ENGLISH = _pycdio.CDTEXT_LANGUAGE_ENGLISH

_pycdio.CDTEXT_LANGUAGE_SPANISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SPANISH = _pycdio.CDTEXT_LANGUAGE_SPANISH

_pycdio.CDTEXT_LANGUAGE_ESPERANTO_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ESPERANTO = _pycdio.CDTEXT_LANGUAGE_ESPERANTO

_pycdio.CDTEXT_LANGUAGE_ESTONIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ESTONIAN = _pycdio.CDTEXT_LANGUAGE_ESTONIAN

_pycdio.CDTEXT_LANGUAGE_BASQUE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_BASQUE = _pycdio.CDTEXT_LANGUAGE_BASQUE

_pycdio.CDTEXT_LANGUAGE_FAROESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_FAROESE = _pycdio.CDTEXT_LANGUAGE_FAROESE

_pycdio.CDTEXT_LANGUAGE_FRENCH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_FRENCH = _pycdio.CDTEXT_LANGUAGE_FRENCH

_pycdio.CDTEXT_LANGUAGE_FRISIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_FRISIAN = _pycdio.CDTEXT_LANGUAGE_FRISIAN

_pycdio.CDTEXT_LANGUAGE_IRISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_IRISH = _pycdio.CDTEXT_LANGUAGE_IRISH

_pycdio.CDTEXT_LANGUAGE_GAELIC_swigconstant(_pycdio)
CDTEXT_LANGUAGE_GAELIC = _pycdio.CDTEXT_LANGUAGE_GAELIC

_pycdio.CDTEXT_LANGUAGE_GALICIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_GALICIAN = _pycdio.CDTEXT_LANGUAGE_GALICIAN

_pycdio.CDTEXT_LANGUAGE_ICELANDIC_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ICELANDIC = _pycdio.CDTEXT_LANGUAGE_ICELANDIC

_pycdio.CDTEXT_LANGUAGE_ITALIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ITALIAN = _pycdio.CDTEXT_LANGUAGE_ITALIAN

_pycdio.CDTEXT_LANGUAGE_LAPPISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_LAPPISH = _pycdio.CDTEXT_LANGUAGE_LAPPISH

_pycdio.CDTEXT_LANGUAGE_LATIN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_LATIN = _pycdio.CDTEXT_LANGUAGE_LATIN

_pycdio.CDTEXT_LANGUAGE_LATVIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_LATVIAN = _pycdio.CDTEXT_LANGUAGE_LATVIAN

_pycdio.CDTEXT_LANGUAGE_LUXEMBOURGIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_LUXEMBOURGIAN = _pycdio.CDTEXT_LANGUAGE_LUXEMBOURGIAN

_pycdio.CDTEXT_LANGUAGE_LITHUANIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_LITHUANIAN = _pycdio.CDTEXT_LANGUAGE_LITHUANIAN

_pycdio.CDTEXT_LANGUAGE_HUNGARIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_HUNGARIAN = _pycdio.CDTEXT_LANGUAGE_HUNGARIAN

_pycdio.CDTEXT_LANGUAGE_MALTESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_MALTESE = _pycdio.CDTEXT_LANGUAGE_MALTESE

_pycdio.CDTEXT_LANGUAGE_DUTCH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_DUTCH = _pycdio.CDTEXT_LANGUAGE_DUTCH

_pycdio.CDTEXT_LANGUAGE_NORWEGIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_NORWEGIAN = _pycdio.CDTEXT_LANGUAGE_NORWEGIAN

_pycdio.CDTEXT_LANGUAGE_OCCITAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_OCCITAN = _pycdio.CDTEXT_LANGUAGE_OCCITAN

_pycdio.CDTEXT_LANGUAGE_POLISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_POLISH = _pycdio.CDTEXT_LANGUAGE_POLISH

_pycdio.CDTEXT_LANGUAGE_PORTUGUESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_PORTUGUESE = _pycdio.CDTEXT_LANGUAGE_PORTUGUESE

_pycdio.CDTEXT_LANGUAGE_ROMANIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ROMANIAN = _pycdio.CDTEXT_LANGUAGE_ROMANIAN

_pycdio.CDTEXT_LANGUAGE_ROMANSH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ROMANSH = _pycdio.CDTEXT_LANGUAGE_ROMANSH

_pycdio.CDTEXT_LANGUAGE_SERBIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SERBIAN = _pycdio.CDTEXT_LANGUAGE_SERBIAN

_pycdio.CDTEXT_LANGUAGE_SLOVAK_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SLOVAK = _pycdio.CDTEXT_LANGUAGE_SLOVAK

_pycdio.CDTEXT_LANGUAGE_SLOVENIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SLOVENIAN = _pycdio.CDTEXT_LANGUAGE_SLOVENIAN

_pycdio.CDTEXT_LANGUAGE_FINNISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_FINNISH = _pycdio.CDTEXT_LANGUAGE_FINNISH

_pycdio.CDTEXT_LANGUAGE_SWEDISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SWEDISH = _pycdio.CDTEXT_LANGUAGE_SWEDISH

_pycdio.CDTEXT_LANGUAGE_TURKISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_TURKISH = _pycdio.CDTEXT_LANGUAGE_TURKISH

_pycdio.CDTEXT_LANGUAGE_FLEMISH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_FLEMISH = _pycdio.CDTEXT_LANGUAGE_FLEMISH

_pycdio.CDTEXT_LANGUAGE_WALLON_swigconstant(_pycdio)
CDTEXT_LANGUAGE_WALLON = _pycdio.CDTEXT_LANGUAGE_WALLON

_pycdio.CDTEXT_LANGUAGE_ZULU_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ZULU = _pycdio.CDTEXT_LANGUAGE_ZULU

_pycdio.CDTEXT_LANGUAGE_VIETNAMESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_VIETNAMESE = _pycdio.CDTEXT_LANGUAGE_VIETNAMESE

_pycdio.CDTEXT_LANGUAGE_UZBEK_swigconstant(_pycdio)
CDTEXT_LANGUAGE_UZBEK = _pycdio.CDTEXT_LANGUAGE_UZBEK

_pycdio.CDTEXT_LANGUAGE_URDU_swigconstant(_pycdio)
CDTEXT_LANGUAGE_URDU = _pycdio.CDTEXT_LANGUAGE_URDU

_pycdio.CDTEXT_LANGUAGE_UKRAINIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_UKRAINIAN = _pycdio.CDTEXT_LANGUAGE_UKRAINIAN

_pycdio.CDTEXT_LANGUAGE_THAI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_THAI = _pycdio.CDTEXT_LANGUAGE_THAI

_pycdio.CDTEXT_LANGUAGE_TELUGU_swigconstant(_pycdio)
CDTEXT_LANGUAGE_TELUGU = _pycdio.CDTEXT_LANGUAGE_TELUGU

_pycdio.CDTEXT_LANGUAGE_TATAR_swigconstant(_pycdio)
CDTEXT_LANGUAGE_TATAR = _pycdio.CDTEXT_LANGUAGE_TATAR

_pycdio.CDTEXT_LANGUAGE_TAMIL_swigconstant(_pycdio)
CDTEXT_LANGUAGE_TAMIL = _pycdio.CDTEXT_LANGUAGE_TAMIL

_pycdio.CDTEXT_LANGUAGE_TADZHIK_swigconstant(_pycdio)
CDTEXT_LANGUAGE_TADZHIK = _pycdio.CDTEXT_LANGUAGE_TADZHIK

_pycdio.CDTEXT_LANGUAGE_SWAHILI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SWAHILI = _pycdio.CDTEXT_LANGUAGE_SWAHILI

_pycdio.CDTEXT_LANGUAGE_SRANANTONGO_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SRANANTONGO = _pycdio.CDTEXT_LANGUAGE_SRANANTONGO

_pycdio.CDTEXT_LANGUAGE_SOMALI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SOMALI = _pycdio.CDTEXT_LANGUAGE_SOMALI

_pycdio.CDTEXT_LANGUAGE_SINHALESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SINHALESE = _pycdio.CDTEXT_LANGUAGE_SINHALESE

_pycdio.CDTEXT_LANGUAGE_SHONA_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SHONA = _pycdio.CDTEXT_LANGUAGE_SHONA

_pycdio.CDTEXT_LANGUAGE_SERBO_CROAT_swigconstant(_pycdio)
CDTEXT_LANGUAGE_SERBO_CROAT = _pycdio.CDTEXT_LANGUAGE_SERBO_CROAT

_pycdio.CDTEXT_LANGUAGE_RUTHENIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_RUTHENIAN = _pycdio.CDTEXT_LANGUAGE_RUTHENIAN

_pycdio.CDTEXT_LANGUAGE_RUSSIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_RUSSIAN = _pycdio.CDTEXT_LANGUAGE_RUSSIAN

_pycdio.CDTEXT_LANGUAGE_QUECHUA_swigconstant(_pycdio)
CDTEXT_LANGUAGE_QUECHUA = _pycdio.CDTEXT_LANGUAGE_QUECHUA

_pycdio.CDTEXT_LANGUAGE_PUSHTU_swigconstant(_pycdio)
CDTEXT_LANGUAGE_PUSHTU = _pycdio.CDTEXT_LANGUAGE_PUSHTU

_pycdio.CDTEXT_LANGUAGE_PUNJABI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_PUNJABI = _pycdio.CDTEXT_LANGUAGE_PUNJABI

_pycdio.CDTEXT_LANGUAGE_PERSIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_PERSIAN = _pycdio.CDTEXT_LANGUAGE_PERSIAN

_pycdio.CDTEXT_LANGUAGE_PAPAMIENTO_swigconstant(_pycdio)
CDTEXT_LANGUAGE_PAPAMIENTO = _pycdio.CDTEXT_LANGUAGE_PAPAMIENTO

_pycdio.CDTEXT_LANGUAGE_ORIYA_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ORIYA = _pycdio.CDTEXT_LANGUAGE_ORIYA

_pycdio.CDTEXT_LANGUAGE_NEPALI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_NEPALI = _pycdio.CDTEXT_LANGUAGE_NEPALI

_pycdio.CDTEXT_LANGUAGE_NDEBELE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_NDEBELE = _pycdio.CDTEXT_LANGUAGE_NDEBELE

_pycdio.CDTEXT_LANGUAGE_MARATHI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_MARATHI = _pycdio.CDTEXT_LANGUAGE_MARATHI

_pycdio.CDTEXT_LANGUAGE_MOLDAVIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_MOLDAVIAN = _pycdio.CDTEXT_LANGUAGE_MOLDAVIAN

_pycdio.CDTEXT_LANGUAGE_MALAYSIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_MALAYSIAN = _pycdio.CDTEXT_LANGUAGE_MALAYSIAN

_pycdio.CDTEXT_LANGUAGE_MALAGASAY_swigconstant(_pycdio)
CDTEXT_LANGUAGE_MALAGASAY = _pycdio.CDTEXT_LANGUAGE_MALAGASAY

_pycdio.CDTEXT_LANGUAGE_MACEDONIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_MACEDONIAN = _pycdio.CDTEXT_LANGUAGE_MACEDONIAN

_pycdio.CDTEXT_LANGUAGE_LAOTIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_LAOTIAN = _pycdio.CDTEXT_LANGUAGE_LAOTIAN

_pycdio.CDTEXT_LANGUAGE_KOREAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_KOREAN = _pycdio.CDTEXT_LANGUAGE_KOREAN

_pycdio.CDTEXT_LANGUAGE_KHMER_swigconstant(_pycdio)
CDTEXT_LANGUAGE_KHMER = _pycdio.CDTEXT_LANGUAGE_KHMER

_pycdio.CDTEXT_LANGUAGE_KAZAKH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_KAZAKH = _pycdio.CDTEXT_LANGUAGE_KAZAKH

_pycdio.CDTEXT_LANGUAGE_KANNADA_swigconstant(_pycdio)
CDTEXT_LANGUAGE_KANNADA = _pycdio.CDTEXT_LANGUAGE_KANNADA

_pycdio.CDTEXT_LANGUAGE_JAPANESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_JAPANESE = _pycdio.CDTEXT_LANGUAGE_JAPANESE

_pycdio.CDTEXT_LANGUAGE_INDONESIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_INDONESIAN = _pycdio.CDTEXT_LANGUAGE_INDONESIAN

_pycdio.CDTEXT_LANGUAGE_HINDI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_HINDI = _pycdio.CDTEXT_LANGUAGE_HINDI

_pycdio.CDTEXT_LANGUAGE_HEBREW_swigconstant(_pycdio)
CDTEXT_LANGUAGE_HEBREW = _pycdio.CDTEXT_LANGUAGE_HEBREW

_pycdio.CDTEXT_LANGUAGE_HAUSA_swigconstant(_pycdio)
CDTEXT_LANGUAGE_HAUSA = _pycdio.CDTEXT_LANGUAGE_HAUSA

_pycdio.CDTEXT_LANGUAGE_GURANI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_GURANI = _pycdio.CDTEXT_LANGUAGE_GURANI

_pycdio.CDTEXT_LANGUAGE_GUJURATI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_GUJURATI = _pycdio.CDTEXT_LANGUAGE_GUJURATI

_pycdio.CDTEXT_LANGUAGE_GREEK_swigconstant(_pycdio)
CDTEXT_LANGUAGE_GREEK = _pycdio.CDTEXT_LANGUAGE_GREEK

_pycdio.CDTEXT_LANGUAGE_GEORGIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_GEORGIAN = _pycdio.CDTEXT_LANGUAGE_GEORGIAN

_pycdio.CDTEXT_LANGUAGE_FULANI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_FULANI = _pycdio.CDTEXT_LANGUAGE_FULANI

_pycdio.CDTEXT_LANGUAGE_DARI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_DARI = _pycdio.CDTEXT_LANGUAGE_DARI

_pycdio.CDTEXT_LANGUAGE_CHURASH_swigconstant(_pycdio)
CDTEXT_LANGUAGE_CHURASH = _pycdio.CDTEXT_LANGUAGE_CHURASH

_pycdio.CDTEXT_LANGUAGE_CHINESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_CHINESE = _pycdio.CDTEXT_LANGUAGE_CHINESE

_pycdio.CDTEXT_LANGUAGE_BURMESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_BURMESE = _pycdio.CDTEXT_LANGUAGE_BURMESE

_pycdio.CDTEXT_LANGUAGE_BULGARIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_BULGARIAN = _pycdio.CDTEXT_LANGUAGE_BULGARIAN

_pycdio.CDTEXT_LANGUAGE_BENGALI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_BENGALI = _pycdio.CDTEXT_LANGUAGE_BENGALI

_pycdio.CDTEXT_LANGUAGE_BIELORUSSIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_BIELORUSSIAN = _pycdio.CDTEXT_LANGUAGE_BIELORUSSIAN

_pycdio.CDTEXT_LANGUAGE_BAMBORA_swigconstant(_pycdio)
CDTEXT_LANGUAGE_BAMBORA = _pycdio.CDTEXT_LANGUAGE_BAMBORA

_pycdio.CDTEXT_LANGUAGE_AZERBAIJANI_swigconstant(_pycdio)
CDTEXT_LANGUAGE_AZERBAIJANI = _pycdio.CDTEXT_LANGUAGE_AZERBAIJANI

_pycdio.CDTEXT_LANGUAGE_ASSAMESE_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ASSAMESE = _pycdio.CDTEXT_LANGUAGE_ASSAMESE

_pycdio.CDTEXT_LANGUAGE_ARMENIAN_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ARMENIAN = _pycdio.CDTEXT_LANGUAGE_ARMENIAN

_pycdio.CDTEXT_LANGUAGE_ARABIC_swigconstant(_pycdio)
CDTEXT_LANGUAGE_ARABIC = _pycdio.CDTEXT_LANGUAGE_ARABIC

_pycdio.CDTEXT_LANGUAGE_AMHARIC_swigconstant(_pycdio)
CDTEXT_LANGUAGE_AMHARIC = _pycdio.CDTEXT_LANGUAGE_AMHARIC

_pycdio.MIN_CDTEXT_FIELD_swigconstant(_pycdio)
MIN_CDTEXT_FIELD = _pycdio.MIN_CDTEXT_FIELD

_pycdio.MAX_CDTEXT_FIELDS_swigconstant(_pycdio)
MAX_CDTEXT_FIELDS = _pycdio.MAX_CDTEXT_FIELDS

def cdtext_field2str(i):
    """cdtext_field2str(cdtext_field_t i) -> char const *"""
    return _pycdio.cdtext_field2str(i)

def cdtext_lang2str(i):
    """cdtext_lang2str(cdtext_lang_t i) -> char const *"""
    return _pycdio.cdtext_lang2str(i)

def cdtext_genre2str(i):
    """cdtext_genre2str(cdtext_genre_t i) -> char const *"""
    return _pycdio.cdtext_genre2str(i)

def cdtext_init():
    """cdtext_init() -> cdtext_t *"""
    return _pycdio.cdtext_init()

def cdtext_destroy(p_cdtext):
    """cdtext_destroy(cdtext_t * p_cdtext)"""
    return _pycdio.cdtext_destroy(p_cdtext)

def cdtext_get(p_cdtext, key, track):
    """cdtext_get(cdtext_t const * p_cdtext, cdtext_field_t key, track_t track) -> char *"""
    return _pycdio.cdtext_get(p_cdtext, key, track)

def cdtext_get_const(p_cdtext, key, track):
    """cdtext_get_const(cdtext_t const * p_cdtext, cdtext_field_t key, track_t track) -> char const *"""
    return _pycdio.cdtext_get_const(p_cdtext, key, track)

def cdtext_get_language(p_cdtext):
    """cdtext_get_language(cdtext_t const * p_cdtext) -> cdtext_lang_t"""
    return _pycdio.cdtext_get_language(p_cdtext)

def cdtext_select_language(p_cdtext, lang):
    """cdtext_select_language(cdtext_t * p_cdtext, cdtext_lang_t lang) -> bool"""
    return _pycdio.cdtext_select_language(p_cdtext, lang)

def cdtext_list_languages(p_cdtext):
    """cdtext_list_languages(cdtext_t const * p_cdtext) -> cdtext_lang_t *"""
    return _pycdio.cdtext_list_languages(p_cdtext)

def cdtext_set(p_cdtext, key, value, track, charset):
    """cdtext_set(cdtext_t * p_cdtext, cdtext_field_t key, uint8_t const * value, track_t track, char const * charset)"""
    return _pycdio.cdtext_set(p_cdtext, key, value, track, charset)

def get_cdtext(p_cdio):
    """get_cdtext(CdIo_t * p_cdio) -> cdtext_t *"""
    return _pycdio.get_cdtext(p_cdio)

_pycdio.DRIVE_CAP_ERROR_swigconstant(_pycdio)
DRIVE_CAP_ERROR = _pycdio.DRIVE_CAP_ERROR

_pycdio.DRIVE_CAP_UNKNOWN_swigconstant(_pycdio)
DRIVE_CAP_UNKNOWN = _pycdio.DRIVE_CAP_UNKNOWN

_pycdio.DRIVE_CAP_MISC_CLOSE_TRAY_swigconstant(_pycdio)
DRIVE_CAP_MISC_CLOSE_TRAY = _pycdio.DRIVE_CAP_MISC_CLOSE_TRAY

_pycdio.DRIVE_CAP_MISC_EJECT_swigconstant(_pycdio)
DRIVE_CAP_MISC_EJECT = _pycdio.DRIVE_CAP_MISC_EJECT

_pycdio.DRIVE_CAP_MISC_LOCK_swigconstant(_pycdio)
DRIVE_CAP_MISC_LOCK = _pycdio.DRIVE_CAP_MISC_LOCK

_pycdio.DRIVE_CAP_MISC_SELECT_SPEED_swigconstant(_pycdio)
DRIVE_CAP_MISC_SELECT_SPEED = _pycdio.DRIVE_CAP_MISC_SELECT_SPEED

_pycdio.DRIVE_CAP_MISC_SELECT_DISC_swigconstant(_pycdio)
DRIVE_CAP_MISC_SELECT_DISC = _pycdio.DRIVE_CAP_MISC_SELECT_DISC

_pycdio.DRIVE_CAP_MISC_MULTI_SESSION_swigconstant(_pycdio)
DRIVE_CAP_MISC_MULTI_SESSION = _pycdio.DRIVE_CAP_MISC_MULTI_SESSION

_pycdio.DRIVE_CAP_MISC_MEDIA_CHANGED_swigconstant(_pycdio)
DRIVE_CAP_MISC_MEDIA_CHANGED = _pycdio.DRIVE_CAP_MISC_MEDIA_CHANGED

_pycdio.DRIVE_CAP_MISC_RESET_swigconstant(_pycdio)
DRIVE_CAP_MISC_RESET = _pycdio.DRIVE_CAP_MISC_RESET

_pycdio.DRIVE_CAP_MISC_FILE_swigconstant(_pycdio)
DRIVE_CAP_MISC_FILE = _pycdio.DRIVE_CAP_MISC_FILE

_pycdio.DRIVE_CAP_READ_AUDIO_swigconstant(_pycdio)
DRIVE_CAP_READ_AUDIO = _pycdio.DRIVE_CAP_READ_AUDIO

_pycdio.DRIVE_CAP_READ_CD_DA_swigconstant(_pycdio)
DRIVE_CAP_READ_CD_DA = _pycdio.DRIVE_CAP_READ_CD_DA

_pycdio.DRIVE_CAP_READ_CD_G_swigconstant(_pycdio)
DRIVE_CAP_READ_CD_G = _pycdio.DRIVE_CAP_READ_CD_G

_pycdio.DRIVE_CAP_READ_CD_R_swigconstant(_pycdio)
DRIVE_CAP_READ_CD_R = _pycdio.DRIVE_CAP_READ_CD_R

_pycdio.DRIVE_CAP_READ_CD_RW_swigconstant(_pycdio)
DRIVE_CAP_READ_CD_RW = _pycdio.DRIVE_CAP_READ_CD_RW

_pycdio.DRIVE_CAP_READ_DVD_R_swigconstant(_pycdio)
DRIVE_CAP_READ_DVD_R = _pycdio.DRIVE_CAP_READ_DVD_R

_pycdio.DRIVE_CAP_READ_DVD_PR_swigconstant(_pycdio)
DRIVE_CAP_READ_DVD_PR = _pycdio.DRIVE_CAP_READ_DVD_PR

_pycdio.DRIVE_CAP_READ_DVD_RAM_swigconstant(_pycdio)
DRIVE_CAP_READ_DVD_RAM = _pycdio.DRIVE_CAP_READ_DVD_RAM

_pycdio.DRIVE_CAP_READ_DVD_ROM_swigconstant(_pycdio)
DRIVE_CAP_READ_DVD_ROM = _pycdio.DRIVE_CAP_READ_DVD_ROM

_pycdio.DRIVE_CAP_READ_DVD_RW_swigconstant(_pycdio)
DRIVE_CAP_READ_DVD_RW = _pycdio.DRIVE_CAP_READ_DVD_RW

_pycdio.DRIVE_CAP_READ_DVD_RPW_swigconstant(_pycdio)
DRIVE_CAP_READ_DVD_RPW = _pycdio.DRIVE_CAP_READ_DVD_RPW

_pycdio.DRIVE_CAP_READ_C2_ERRS_swigconstant(_pycdio)
DRIVE_CAP_READ_C2_ERRS = _pycdio.DRIVE_CAP_READ_C2_ERRS

_pycdio.DRIVE_CAP_READ_MODE2_FORM1_swigconstant(_pycdio)
DRIVE_CAP_READ_MODE2_FORM1 = _pycdio.DRIVE_CAP_READ_MODE2_FORM1

_pycdio.DRIVE_CAP_READ_MODE2_FORM2_swigconstant(_pycdio)
DRIVE_CAP_READ_MODE2_FORM2 = _pycdio.DRIVE_CAP_READ_MODE2_FORM2

_pycdio.DRIVE_CAP_READ_MCN_swigconstant(_pycdio)
DRIVE_CAP_READ_MCN = _pycdio.DRIVE_CAP_READ_MCN

_pycdio.DRIVE_CAP_READ_ISRC_swigconstant(_pycdio)
DRIVE_CAP_READ_ISRC = _pycdio.DRIVE_CAP_READ_ISRC

_pycdio.DRIVE_CAP_WRITE_CD_R_swigconstant(_pycdio)
DRIVE_CAP_WRITE_CD_R = _pycdio.DRIVE_CAP_WRITE_CD_R

_pycdio.DRIVE_CAP_WRITE_CD_RW_swigconstant(_pycdio)
DRIVE_CAP_WRITE_CD_RW = _pycdio.DRIVE_CAP_WRITE_CD_RW

_pycdio.DRIVE_CAP_WRITE_DVD_R_swigconstant(_pycdio)
DRIVE_CAP_WRITE_DVD_R = _pycdio.DRIVE_CAP_WRITE_DVD_R

_pycdio.DRIVE_CAP_WRITE_DVD_PR_swigconstant(_pycdio)
DRIVE_CAP_WRITE_DVD_PR = _pycdio.DRIVE_CAP_WRITE_DVD_PR

_pycdio.DRIVE_CAP_WRITE_DVD_RAM_swigconstant(_pycdio)
DRIVE_CAP_WRITE_DVD_RAM = _pycdio.DRIVE_CAP_WRITE_DVD_RAM

_pycdio.DRIVE_CAP_WRITE_DVD_RW_swigconstant(_pycdio)
DRIVE_CAP_WRITE_DVD_RW = _pycdio.DRIVE_CAP_WRITE_DVD_RW

_pycdio.DRIVE_CAP_WRITE_DVD_RPW_swigconstant(_pycdio)
DRIVE_CAP_WRITE_DVD_RPW = _pycdio.DRIVE_CAP_WRITE_DVD_RPW

_pycdio.DRIVE_CAP_WRITE_MT_RAINIER_swigconstant(_pycdio)
DRIVE_CAP_WRITE_MT_RAINIER = _pycdio.DRIVE_CAP_WRITE_MT_RAINIER

_pycdio.DRIVE_CAP_WRITE_BURN_PROOF_swigconstant(_pycdio)
DRIVE_CAP_WRITE_BURN_PROOF = _pycdio.DRIVE_CAP_WRITE_BURN_PROOF

_pycdio.DRIVE_CAP_WRITE_CD_swigconstant(_pycdio)
DRIVE_CAP_WRITE_CD = _pycdio.DRIVE_CAP_WRITE_CD

_pycdio.DRIVE_CAP_WRITE_DVD_swigconstant(_pycdio)
DRIVE_CAP_WRITE_DVD = _pycdio.DRIVE_CAP_WRITE_DVD

_pycdio.DRIVE_CAP_WRITE_swigconstant(_pycdio)
DRIVE_CAP_WRITE = _pycdio.DRIVE_CAP_WRITE

_pycdio.MMC_HW_VENDOR_LEN_swigconstant(_pycdio)
MMC_HW_VENDOR_LEN = _pycdio.MMC_HW_VENDOR_LEN

_pycdio.MMC_HW_MODEL_LEN_swigconstant(_pycdio)
MMC_HW_MODEL_LEN = _pycdio.MMC_HW_MODEL_LEN

_pycdio.MMC_HW_REVISION_LEN_swigconstant(_pycdio)
MMC_HW_REVISION_LEN = _pycdio.MMC_HW_REVISION_LEN

_pycdio.SRC_IS_DISK_IMAGE_MASK_swigconstant(_pycdio)
SRC_IS_DISK_IMAGE_MASK = _pycdio.SRC_IS_DISK_IMAGE_MASK

_pycdio.SRC_IS_DEVICE_MASK_swigconstant(_pycdio)
SRC_IS_DEVICE_MASK = _pycdio.SRC_IS_DEVICE_MASK

_pycdio.SRC_IS_SCSI_MASK_swigconstant(_pycdio)
SRC_IS_SCSI_MASK = _pycdio.SRC_IS_SCSI_MASK

_pycdio.SRC_IS_NATIVE_MASK_swigconstant(_pycdio)
SRC_IS_NATIVE_MASK = _pycdio.SRC_IS_NATIVE_MASK

_pycdio.DRIVER_UNKNOWN_swigconstant(_pycdio)
DRIVER_UNKNOWN = _pycdio.DRIVER_UNKNOWN

_pycdio.DRIVER_AIX_swigconstant(_pycdio)
DRIVER_AIX = _pycdio.DRIVER_AIX

_pycdio.DRIVER_BSDI_swigconstant(_pycdio)
DRIVER_BSDI = _pycdio.DRIVER_BSDI

_pycdio.DRIVER_FREEBSD_swigconstant(_pycdio)
DRIVER_FREEBSD = _pycdio.DRIVER_FREEBSD

_pycdio.DRIVER_LINUX_swigconstant(_pycdio)
DRIVER_LINUX = _pycdio.DRIVER_LINUX

_pycdio.DRIVER_SOLARIS_swigconstant(_pycdio)
DRIVER_SOLARIS = _pycdio.DRIVER_SOLARIS

_pycdio.DRIVER_OSX_swigconstant(_pycdio)
DRIVER_OSX = _pycdio.DRIVER_OSX

_pycdio.DRIVER_NETBSD_swigconstant(_pycdio)
DRIVER_NETBSD = _pycdio.DRIVER_NETBSD

_pycdio.DRIVER_WIN32_swigconstant(_pycdio)
DRIVER_WIN32 = _pycdio.DRIVER_WIN32

_pycdio.DRIVER_CDRDAO_swigconstant(_pycdio)
DRIVER_CDRDAO = _pycdio.DRIVER_CDRDAO

_pycdio.DRIVER_BINCUE_swigconstant(_pycdio)
DRIVER_BINCUE = _pycdio.DRIVER_BINCUE

_pycdio.DRIVER_NRG_swigconstant(_pycdio)
DRIVER_NRG = _pycdio.DRIVER_NRG

_pycdio.DRIVER_DEVICE_swigconstant(_pycdio)
DRIVER_DEVICE = _pycdio.DRIVER_DEVICE

_pycdio.DRIVER_OP_SUCCESS_swigconstant(_pycdio)
DRIVER_OP_SUCCESS = _pycdio.DRIVER_OP_SUCCESS

_pycdio.DRIVER_OP_ERROR_swigconstant(_pycdio)
DRIVER_OP_ERROR = _pycdio.DRIVER_OP_ERROR

_pycdio.DRIVER_OP_UNSUPPORTED_swigconstant(_pycdio)
DRIVER_OP_UNSUPPORTED = _pycdio.DRIVER_OP_UNSUPPORTED

_pycdio.DRIVER_OP_UNINIT_swigconstant(_pycdio)
DRIVER_OP_UNINIT = _pycdio.DRIVER_OP_UNINIT

_pycdio.DRIVER_OP_NOT_PERMITTED_swigconstant(_pycdio)
DRIVER_OP_NOT_PERMITTED = _pycdio.DRIVER_OP_NOT_PERMITTED

_pycdio.DRIVER_OP_BAD_PARAMETER_swigconstant(_pycdio)
DRIVER_OP_BAD_PARAMETER = _pycdio.DRIVER_OP_BAD_PARAMETER

_pycdio.DRIVER_OP_BAD_POINTER_swigconstant(_pycdio)
DRIVER_OP_BAD_POINTER = _pycdio.DRIVER_OP_BAD_POINTER

_pycdio.DRIVER_OP_NO_DRIVER_swigconstant(_pycdio)
DRIVER_OP_NO_DRIVER = _pycdio.DRIVER_OP_NO_DRIVER

_pycdio.FS_AUDIO_swigconstant(_pycdio)
FS_AUDIO = _pycdio.FS_AUDIO

_pycdio.FS_HIGH_SIERRA_swigconstant(_pycdio)
FS_HIGH_SIERRA = _pycdio.FS_HIGH_SIERRA

_pycdio.FS_ISO_9660_swigconstant(_pycdio)
FS_ISO_9660 = _pycdio.FS_ISO_9660

_pycdio.FS_INTERACTIVE_swigconstant(_pycdio)
FS_INTERACTIVE = _pycdio.FS_INTERACTIVE

_pycdio.FS_HFS_swigconstant(_pycdio)
FS_HFS = _pycdio.FS_HFS

_pycdio.FS_UFS_swigconstant(_pycdio)
FS_UFS = _pycdio.FS_UFS

_pycdio.FS_EXT2_swigconstant(_pycdio)
FS_EXT2 = _pycdio.FS_EXT2

_pycdio.FS_ISO_HFS_swigconstant(_pycdio)
FS_ISO_HFS = _pycdio.FS_ISO_HFS

_pycdio.FS_ISO_9660_INTERACTIVE_swigconstant(_pycdio)
FS_ISO_9660_INTERACTIVE = _pycdio.FS_ISO_9660_INTERACTIVE

_pycdio.FS_3DO_swigconstant(_pycdio)
FS_3DO = _pycdio.FS_3DO

_pycdio.FS_XISO_swigconstant(_pycdio)
FS_XISO = _pycdio.FS_XISO

_pycdio.FS_UDFX_swigconstant(_pycdio)
FS_UDFX = _pycdio.FS_UDFX

_pycdio.FS_UDF_swigconstant(_pycdio)
FS_UDF = _pycdio.FS_UDF

_pycdio.FS_ISO_UDF_swigconstant(_pycdio)
FS_ISO_UDF = _pycdio.FS_ISO_UDF

_pycdio.FS_ANAL_XA_swigconstant(_pycdio)
FS_ANAL_XA = _pycdio.FS_ANAL_XA

_pycdio.FS_ANAL_MULTISESSION_swigconstant(_pycdio)
FS_ANAL_MULTISESSION = _pycdio.FS_ANAL_MULTISESSION

_pycdio.FS_ANAL_PHOTO_CD_swigconstant(_pycdio)
FS_ANAL_PHOTO_CD = _pycdio.FS_ANAL_PHOTO_CD

_pycdio.FS_ANAL_HIDDEN_TRACK_swigconstant(_pycdio)
FS_ANAL_HIDDEN_TRACK = _pycdio.FS_ANAL_HIDDEN_TRACK

_pycdio.FS_ANAL_CDTV_swigconstant(_pycdio)
FS_ANAL_CDTV = _pycdio.FS_ANAL_CDTV

_pycdio.FS_ANAL_BOOTABLE_swigconstant(_pycdio)
FS_ANAL_BOOTABLE = _pycdio.FS_ANAL_BOOTABLE

_pycdio.FS_ANAL_VIDEOCD_swigconstant(_pycdio)
FS_ANAL_VIDEOCD = _pycdio.FS_ANAL_VIDEOCD

_pycdio.FS_ANAL_ROCKRIDGE_swigconstant(_pycdio)
FS_ANAL_ROCKRIDGE = _pycdio.FS_ANAL_ROCKRIDGE

_pycdio.FS_ANAL_JOLIET_swigconstant(_pycdio)
FS_ANAL_JOLIET = _pycdio.FS_ANAL_JOLIET

_pycdio.FS_ANAL_SVCD_swigconstant(_pycdio)
FS_ANAL_SVCD = _pycdio.FS_ANAL_SVCD

_pycdio.FS_ANAL_CVD_swigconstant(_pycdio)
FS_ANAL_CVD = _pycdio.FS_ANAL_CVD

_pycdio.FS_ANAL_XISO_swigconstant(_pycdio)
FS_ANAL_XISO = _pycdio.FS_ANAL_XISO

_pycdio.FS_MATCH_ALL_swigconstant(_pycdio)
FS_MATCH_ALL = _pycdio.FS_MATCH_ALL

_pycdio.FS_UNKNOWN_swigconstant(_pycdio)
FS_UNKNOWN = _pycdio.FS_UNKNOWN

def close_tray(*args):
    """
    close_tray(drive=None, driver_id=None) -> [status, driver_id]

    close media tray in CD drive if there is a routine to do so. 
    The driver id is returned. An exception is thrown on error.
    """
    return _pycdio.close_tray(*args)

def close(p_cdio):
    """
    destroy(p_cdio)
    Free resources associated with p_cdio.  Call this when done using
    using CD reading/control operations for the current device.

    """
    return _pycdio.close(p_cdio)

def eject_media(p_cdio):
    """
    eject_media(cdio)->return_code

    Eject media in CD drive if there is a routine to do so. 

    """
    return _pycdio.eject_media(p_cdio)

def eject_media_drive(psz_drive=None):
    """
    eject_media_drive(drive=None)->return_code
    Eject media in CD drive if there is a routine to do so. 

    psz_drive: the name of the device to be acted upon. 
    The operation status is returned.
    """
    return _pycdio.eject_media_drive(psz_drive)

def get_arg(p_cdio, key):
    """
    get_arg(p_cdio, key)->string

    Get the value associatied with key.
    """
    return _pycdio.get_arg(p_cdio, key)

def get_device(p_cdio=None):
    """
    get_device(cdio)->str

    Get the CD device associated with cdio.
    If cdio is NULL (we haven't initialized a specific device driver), 
    then find a suitable one and return the default device for that.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it and it is possible for this routine to return
    None even though there may be a hardware CD-ROM.
    """
    return _pycdio.get_device(p_cdio)

def get_default_device_driver(p_driver_id):
    """
    get_default_device_driver(driver_id=None)->[device, driver]
    Return a string containing the default CD device if none is specified.
    if p_driver_id is DRIVER_UNKNOWN or DRIVER_DEVICE then find a suitable
    one set the default device for that.

    None is returned as the device if we couldn't get a default device.
    """
    return _pycdio.get_default_device_driver(p_driver_id)

def get_devices(driver_id):
    """
    get_devices(driver_id)->[device1, device2, ...]

    Get an list of device names.
    """
    return _pycdio.get_devices(driver_id)

def get_devices_ret(driver_id):
    """
    get_devices_ret(driver_id)->[device1, device2, ... driver_id]

    Like get_devices, but return the p_driver_id which may be different
    from the passed-in driver_id if it was pycdio.DRIVER_DEVICE or
    pycdio.DRIVER_UNKNOWN. The return driver_id may be useful because
    often one wants to get a drive name and then *open* it
    afterwards. Giving the driver back facilitates this, and speeds things
    up for libcdio as well.
    """
    return _pycdio.get_devices_ret(driver_id)

def get_devices_with_cap(capabilities, b_any):
    """
    get_devices_with_cap(capabilities, any)->[device1, device2...]
    Get an array of device names in search_devices that have at least
    the capabilities listed by the capabities parameter.  

    If any is False then every capability listed in the
    extended portion of capabilities (i.e. not the basic filesystem)
    must be satisified. If any is True, then if any of the
    capabilities matches, we call that a success.

    To find a CD-drive of any type, use the mask pycdio.CDIO_FS_MATCH_ALL.

    The array of device names is returned or NULL if we couldn't get a
    default device.  It is also possible to return a non NULL but after
    dereferencing the the value is NULL. This also means nothing was
    found.
    """
    return _pycdio.get_devices_with_cap(capabilities, b_any)

def get_devices_with_cap_ret(capabilities, b_any):
    """
    Like cdio_get_devices_with_cap but we return the driver we found
    as well. This is because often one wants to search for kind of drive
    and then *open* it afterwards. Giving the driver back facilitates this,
      and speeds things up for libcdio as well.
    """
    return _pycdio.get_devices_with_cap_ret(capabilities, b_any)

def get_drive_cap(*args):
    """
    get_drive_cap()->(read_cap, write_cap, misc_cap)

    Get drive capabilities of device.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it. In this situation capabilities will show up as 
    empty even though there is a hardware CD-ROM.
    get_drive_cap_dev()->(read_cap, write_cap, misc_cap)

    Get drive capabilities of device.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it. In this situation capabilities will show up as 
    empty even though there is a hardware CD-ROM.
    """
    return _pycdio.get_drive_cap(*args)

def get_driver_name(p_cdio):
    """
    get_driver_name(cdio)-> string

    return a string containing the name of the driver in use.

    An IOError exception is raised on error.

    """
    return _pycdio.get_driver_name(p_cdio)

def get_driver_id(p_cdio):
    """
    get_driver_id(cdio)-> int

    Return the driver id of the driver in use.
    if cdio has not been initialized or is None, 
    return pycdio.DRIVER_UNKNOWN.
    """
    return _pycdio.get_driver_id(p_cdio)

def get_last_session(p_cdio):
    """
    get_last_session(p_cdio) -> int
    Get the LSN of the first track of the last session of on the CD.
    An exception is thrown on error.
    """
    return _pycdio.get_last_session(p_cdio)

def have_driver(driver_id):
    """
    have_driver(driver_id) -> int

    Return 1 if we have driver driver_id, 0 if not and -1 
    if driver id is out of range.
    """
    return _pycdio.have_driver(driver_id)

def have_ATAPI(p_cdio):
    """
    have_ATAPI(CdIo_t *p_cdio)->bool
    return True if CD-ROM understand ATAPI commands.
    """
    return _pycdio.have_ATAPI(p_cdio)

def is_binfile(bin_name):
    """
    is_binfile(binfile_name)->cue_name

    Determine if binfile_name is the BIN file part of a CDRWIN CD disk
    image.

    Return the corresponding CUE file if bin_name is a BIN file or
    None if not a BIN file.
    """
    return _pycdio.is_binfile(bin_name)

def is_cuefile(cue_name):
    """
    is_cuefile(cuefile_name)->bin_name

    Determine if cuefile_name is the CUE file part of a CDRWIN CD disk
    image.

    Return the corresponding BIN file if bin_name is a CUE file or
    None if not a CUE file.
    """
    return _pycdio.is_cuefile(cue_name)

def is_device(*args):
    """
    is_cuefile(cuefile_name)->bin_name

    Determine if cuefile_name is the CUE file part of a CDRWIN CD disk
    image.

    Return the corresponding BIN file if bin_name is a CUE file or
    None if not a CUE file.
    """
    return _pycdio.is_device(*args)

def is_nrg(nrg_name):
    """
    is_nrg(cue_name)->bool

    Determine if nrg_name is a Nero CD disc image
    """
    return _pycdio.is_nrg(nrg_name)

def is_tocfile(tocfile_name):
    """
    is_tocfile(tocfile_name)->bool

    Determine if tocfile_name is a cdrdao CD disc image
    """
    return _pycdio.is_tocfile(tocfile_name)

def get_media_changed(p_cdio):
    """
    get_media_changed(cdio) -> int

    Find out if media has changed since the last call.
    Return 1 if media has changed since last call, 0 if not. Error
    return codes are the same as driver_return_code_t
    """
    return _pycdio.get_media_changed(p_cdio)

def get_hwinfo(p_cdio):
    """
    get_hwinfo(p_cdio)->[drc, vendor, model, release]
    Get the CD-ROM hardware info via a SCSI MMC INQUIRY command.
    """
    return _pycdio.get_hwinfo(p_cdio)

def set_blocksize(p_cdio, i_blocksize):
    """
    set_blocksize(cdio, blocksize)->return_status

    Set the blocksize for subsequent reads.
    """
    return _pycdio.set_blocksize(p_cdio, i_blocksize)

def set_speed(p_cdio, i_speed):
    """
    cdio_set_speed(cdio, speed)->return_status
    Set the drive speed.
    """
    return _pycdio.set_speed(p_cdio, i_speed)

def open_cd(*args):
    """
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name. 

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or 
    None on error or no device.
    """
    return _pycdio.open_cd(*args)

def set_python_errstring(drc):
    """
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name. 

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or 
    None on error or no device.
    """
    return _pycdio.set_python_errstring(drc)

_pycdio.DISC_MODE_CD_DA_swigconstant(_pycdio)
DISC_MODE_CD_DA = _pycdio.DISC_MODE_CD_DA

_pycdio.DISC_MODE_CD_DATA_swigconstant(_pycdio)
DISC_MODE_CD_DATA = _pycdio.DISC_MODE_CD_DATA

_pycdio.DISC_MODE_CD_XA_swigconstant(_pycdio)
DISC_MODE_CD_XA = _pycdio.DISC_MODE_CD_XA

_pycdio.DISC_MODE_CD_MIXED_swigconstant(_pycdio)
DISC_MODE_CD_MIXED = _pycdio.DISC_MODE_CD_MIXED

_pycdio.DISC_MODE_DVD_ROM_swigconstant(_pycdio)
DISC_MODE_DVD_ROM = _pycdio.DISC_MODE_DVD_ROM

_pycdio.DISC_MODE_DVD_RAM_swigconstant(_pycdio)
DISC_MODE_DVD_RAM = _pycdio.DISC_MODE_DVD_RAM

_pycdio.DISC_MODE_DVD_R_swigconstant(_pycdio)
DISC_MODE_DVD_R = _pycdio.DISC_MODE_DVD_R

_pycdio.DISC_MODE_DVD_RW_swigconstant(_pycdio)
DISC_MODE_DVD_RW = _pycdio.DISC_MODE_DVD_RW

_pycdio.DISC_MODE_DVD_PR_swigconstant(_pycdio)
DISC_MODE_DVD_PR = _pycdio.DISC_MODE_DVD_PR

_pycdio.DISC_MODE_DVD_PRW_swigconstant(_pycdio)
DISC_MODE_DVD_PRW = _pycdio.DISC_MODE_DVD_PRW

_pycdio.DISC_MODE_DVD_OTHER_swigconstant(_pycdio)
DISC_MODE_DVD_OTHER = _pycdio.DISC_MODE_DVD_OTHER

_pycdio.DISC_MODE_NO_INFO_swigconstant(_pycdio)
DISC_MODE_NO_INFO = _pycdio.DISC_MODE_NO_INFO

_pycdio.DISC_MODE_ERROR_swigconstant(_pycdio)
DISC_MODE_ERROR = _pycdio.DISC_MODE_ERROR

_pycdio.DISC_MODE_CD_I_swigconstant(_pycdio)
DISC_MODE_CD_I = _pycdio.DISC_MODE_CD_I

def get_disc_last_lsn(p_cdio):
    """
    get_disc_last_lsn(cdio)->lsn
    Get the LSN of the end of the CD.

    pycdio.INVALID_LSN is returned on error.
    """
    return _pycdio.get_disc_last_lsn(p_cdio)

def get_disc_mode(p_cdio):
    """
    get_disc_mode(p_cdio) -> str

    Get disc mode - the kind of CD (CD-DA, CD-ROM mode 1, CD-MIXED, ...)
    that we've got. The notion of 'CD' is extended a little to include
    DVD's.
    """
    return _pycdio.get_disc_mode(p_cdio)

def get_joliet_level(p_cdio):
    """
    get_joliet_level(cdio)->int

    Return the Joliet level recognized for cdio.
    This only makes sense for something that has an ISO-9660
    filesystem.
    """
    return _pycdio.get_joliet_level(p_cdio)

def get_mcn(p_cdio):
    """
    get_mcn(cdio) -> str

    Get the media catalog number (MCN) from the CD.
    """
    return _pycdio.get_mcn(p_cdio)

def get_num_tracks(p_cdio):
    """
    get_num_tracks(p_cdio)->int

    Return the number of tracks on the CD. 
    On error pycdio.INVALID_TRACK is returned.
    """
    return _pycdio.get_num_tracks(p_cdio)

_pycdio.INCLUDE_CLASS_swigconstant(_pycdio)
INCLUDE_CLASS = _pycdio.INCLUDE_CLASS
# This file is compatible with both classic and new-style classes.

cvar = _pycdio.cvar

