/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.type;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.type.ApplicationType;
import com.sun.tools.visualvm.application.type.EclipseApplicationType;
import com.sun.tools.visualvm.application.type.MainClassApplicationTypeFactory;
import java.util.Properties;

public class EclipseApplicationTypeFactory
extends MainClassApplicationTypeFactory {
    private static final String MAIN_CLASS = "org.eclipse.equinox.launcher.Main";
    private static final String ECLIPSE_ID = "-Dosgi.requiredJavaVersion=";
    private static final String ECLIPSE_ID2 = "-XstartOnFirstThread";
    private static final String ECLIPSE_SYSPROP_ID = "eclipse.buildId";
    private static final String ECLIPSE_NAME = "Eclipse";

    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        String name;
        String args;
        if (MAIN_CLASS.equals(mainClass)) {
            String name2 = this.getName(jvm);
            if (name2 == null) {
                name2 = ECLIPSE_NAME;
            }
            return new EclipseApplicationType(app, name2);
        }
        if ((mainClass == null || mainClass.length() == 0) && (args = jvm.getJvmArgs()) != null && (args.contains(ECLIPSE_ID) || args.contains(ECLIPSE_ID2)) && (name = this.getName(jvm)) != null) {
            return new EclipseApplicationType(app, name);
        }
        return null;
    }

    private String getName(Jvm jvm) {
        Properties p;
        if (jvm.isGetSystemPropertiesSupported() && (p = jvm.getSystemProperties()) != null && p.containsKey(ECLIPSE_SYSPROP_ID)) {
            return ECLIPSE_NAME;
        }
        return null;
    }
}

