/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public final class PauseAction
extends ProfilingAwareAction {
    private static final int[] ENABLED_STATES = new int[]{4, 8};
    private boolean suspended = false;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.LBL_PauseAction();
    }

    public void performAction() {
        try {
            TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
            if (this.suspended) {
                targetAppRunner.suspendTargetAppIfRunning();
                this.suspended = false;
                this.setIcon(null);
                this.firePropertyChange("icon", null, null);
            } else {
                targetAppRunner.resumeTargetAppIfSuspended();
                this.suspended = true;
                this.setIcon(null);
                this.firePropertyChange("icon", null, null);
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            ProfilerDialogs.displayWarning((String)targetAppOrVMTerminated.getMessage());
            ProfilerLogger.log((String)targetAppOrVMTerminated.getMessage());
        }
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    protected String iconResource() {
        if (this.suspended) {
            return Icons.getResource((String)"GeneralIcons.Resume");
        }
        return Icons.getResource((String)"GeneralIcons.Pause");
    }
}

