/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.Main;
import org.openide.util.Exceptions;

final class TopThreadGroup
extends ThreadGroup
implements Runnable {
    private String[] args;
    private boolean finished;

    public TopThreadGroup(String string, String[] stringArray) {
        super(string);
        this.args = stringArray;
    }

    public TopThreadGroup(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (!(throwable instanceof ThreadDeath)) {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(thread, throwable);
                return;
            }
            if (throwable instanceof VirtualMachineError) {
                throwable.printStackTrace();
            }
            System.err.flush();
            Exceptions.printStackTrace((Throwable)throwable);
        } else {
            super.uncaughtException(thread, throwable);
        }
    }

    public synchronized void start() throws InterruptedException {
        Thread thread = new Thread(this, this, "main");
        thread.start();
        while (!this.finished) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Main.start(this.args);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            TopSecurityManager.exit((int)2);
        }
        finally {
            TopThreadGroup topThreadGroup = this;
            synchronized (topThreadGroup) {
                this.finished = true;
                this.notify();
            }
        }
    }
}

