/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.ui.components.AnimationLayout;
import org.netbeans.lib.profiler.ui.components.CustomTaskButtonBorder;

public class AnimatedContainer
extends JPanel {
    public static final int WIDTH = 10;
    public static final int HEIGHT = 20;
    private static final int BOTH = 30;
    private AnimationLayout layout = new AnimationLayout();
    private CustomTaskButtonBorder border;
    private JComponent content;
    private JComponent targetContent;
    private JComponent transContent;
    private int animatedDimension = 30;
    private int origHeight;
    private int origWidth;
    private int targetHeight;
    private int targetWidth;

    public AnimatedContainer(Color color) {
        this.setLayout(this.layout);
        this.border = new CustomTaskButtonBorder(color, super.getBackground());
        this.setBorder(this.border);
    }

    public void setAnimatedDimension(int n) {
        this.animatedDimension = n;
    }

    public void setAnimation(JComponent jComponent, JComponent jComponent2) {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        if (jComponent == null) {
            this.targetContent = this.content;
        } else if (jComponent2 == null) {
            this.transContent = this.content;
        } else {
            this.targetContent = jComponent;
            this.transContent = jComponent2;
            this.targetWidth = (int)jComponent.getPreferredSize().getWidth();
            this.targetHeight = (int)jComponent.getPreferredSize().getHeight();
        }
    }

    public void setAnimation(JComponent jComponent) {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        if (jComponent == null) {
            this.targetContent = this.content;
        } else {
            this.targetContent = jComponent;
            this.targetWidth = (int)this.targetContent.getPreferredSize().getWidth();
            this.targetHeight = (int)this.targetContent.getPreferredSize().getHeight();
        }
    }

    public void setAnimation(Dimension dimension) {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        this.targetContent = null;
        this.transContent = this.content;
        this.targetWidth = (int)dimension.getWidth();
        this.targetHeight = (int)dimension.getHeight();
    }

    public void setAnimation() {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        this.transContent = this.content;
        this.targetContent = this.content;
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
    }

    public void setDefaultBorder() {
        this.border.setDefault();
        this.repaint();
    }

    public void setFinishState() {
        this.removeAll();
        if (this.targetContent != null) {
            this.add(this.targetContent);
            this.setPreferredSize(new Dimension(this.targetWidth, this.targetHeight));
            this.setMinimumSize(new Dimension(this.targetWidth, this.targetHeight));
        } else if (this.transContent != null) {
            this.add(this.transContent);
            this.setPreferredSize(this.transContent.getPreferredSize());
            this.setMinimumSize(this.transContent.getPreferredSize());
        }
        this.setPreferredSize(this.content.getPreferredSize());
        this.setMinimumSize(this.content.getPreferredSize());
    }

    public void setFocusedBorder() {
        this.border.setFocused();
        this.repaint();
    }

    public void setSelectedBorder() {
        this.border.setSelected();
        this.repaint();
    }

    public void setState(int n) {
        int n2 = this.targetWidth;
        int n3 = this.targetHeight;
        this.origWidth = (int)this.getSize().getWidth();
        this.origHeight = (int)this.getSize().getHeight();
        int n4 = n2 - this.origWidth;
        int n5 = n3 - this.origHeight;
        double d = (double)n / 100.0;
        Dimension dimension = this.animatedDimension == 10 ? new Dimension((int)((double)this.origWidth + (double)n4 * d), this.origHeight) : (this.animatedDimension == 20 ? new Dimension(this.origWidth, (int)((double)this.origHeight + (double)n5 * d)) : new Dimension((int)((double)this.origWidth + (double)n4 * d), (int)((double)this.origHeight + (double)n5 * d)));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
    }

    public void setTargetContent(JComponent jComponent) {
        this.targetContent = jComponent;
    }

    public void setTransContent(JComponent jComponent) {
        this.transContent = jComponent;
    }

    @Override
    public Component add(Component component) {
        this.content = (JComponent)component;
        return super.add(component);
    }

    public void lockContentResizing(boolean bl) {
        if (bl && this.transContent != null) {
            this.layout.setLockedSize(this.transContent.getSize());
        } else {
            this.layout.setLockedSize(null);
        }
    }
}

