/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;

final class RowForegroundDecorator
implements ChartDecorator {
    private static final Color SELECTED_FILTER = new Color(0, 0, 200, 25);
    private static final float[] FRACTIONS = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
    private static final Color[] COLORS = new Color[]{new Color(250, 251, 252, 120), new Color(237, 240, 242, 120), new Color(229, 233, 236, 125), new Color(215, 221, 226, 130)};
    private final TimelineChart chart;
    private final boolean gradient;
    private final boolean selection;

    RowForegroundDecorator(TimelineChart timelineChart, boolean bl, boolean bl2) {
        this.chart = timelineChart;
        this.gradient = bl;
        this.selection = bl2;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle, ChartContext chartContext) {
        if (this.gradient || this.selection) {
            int n = this.chart.getRowsCount();
            for (int i = 0; i < n; ++i) {
                TimelineChart.Row row = this.chart.getRow(i);
                ChartContext chartContext2 = row.getContext();
                int n2 = Utils.checkedInt((double)chartContext2.getViewportOffsetY());
                int n3 = Utils.checkedInt((double)(chartContext2.getViewportHeight() - 1));
                if (this.gradient) {
                    graphics2D.setPaint(new LinearGradientPaint(0.0f, n2, 0.0f, n2 + n3, FRACTIONS, COLORS));
                    graphics2D.fillRect(0, n2, this.chart.getWidth(), n3);
                }
                if (!this.selection || !this.chart.isRowSelected(row)) continue;
                graphics2D.setColor(SELECTED_FILTER);
                graphics2D.fillRect(0, n2, this.chart.getWidth(), n3);
            }
        }
    }
}

