/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.search.SearchPattern;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class FindDialogMemory {
    private static final int maxFileNamePatternCount = 10;
    private static FindDialogMemory singleton;
    private List<String> fileNamePatterns;
    private boolean wholeWords;
    private boolean caseSensitive;
    private boolean preserveCase;
    private SearchPattern.MatchType matchType;
    private boolean textPatternSpecified;
    private boolean replacePatternSpecified;
    private String scopeTypeId;
    private boolean fileNamePatternSpecified;
    private boolean searchInArchives;
    private boolean searchInGenerated;
    private boolean filePathRegex;
    private boolean useIgnoreList;
    private List<String> ignoreList;
    private String textSandboxContent;
    private String pathSandboxContent;
    private String resultsColumnWidths;
    private String resultsColumnWidthsDetails;
    private String resultsColumnWidthsReplacing;
    private int replaceResultsDivider;
    private String resultsViewMode;
    private String provider;
    private boolean openInNewTab;
    private static Preferences prefs;
    private static final String PREFS_NODE = "FindDialogMemory";
    private static final String PROP_WHOLE_WORDS = "whole_words";
    private static final String PROP_CASE_SENSITIVE = "case_sensitive";
    private static final String PROP_PRESERVE_CASE = "preserve_case";
    private static final String PROP_MATCH_TYPE = "match_type";
    private static final String PROP_SCOPE_TYPE_ID = "scope_type_id";
    private static final String PROP_FILENAME_PATTERN_SPECIFIED = "filename_specified";
    private static final String PROP_FILENAME_PATTERN_PREFIX = "filename_pattern_";
    private static final String PROP_REPLACE_PATTERN_PREFIX = "replace_pattern_";
    private static final String PROP_SEARCH_IN_ARCHIVES = "search_in_archives";
    private static final String PROP_SEARCH_IN_GENERATED = "search_in_generated";
    private static final String PROP_FILE_PATH_REGEX = "file_path_regex";
    private static final String PROP_USE_IGNORE_LIST = "use_ignore_list";
    private static final String PROP_IGNORE_LIST_PREFIX = "ignore_list_";
    private static final String PROP_TEXT_SANDBOX_CONTENT = "text_sandbox_content";
    private static final String PROP_PATH_SANDBOX_CONTENT = "path_sandbox_content";
    private static final String PROP_RESULTS_COLUMN_WIDTHS = "results_column_widths";
    private static final String PROP_RESULTS_COLUMN_WIDTHS_DETAILS = "results_column_widths_details";
    private static final String PROP_RESULTS_COLUMN_WIDTHS_REPLACING = "results_column_widths_replacing";
    private static final String PROP_REPLACE_RESULTS_DIVIDER = "replace_results_divider";
    private static final String PROP_RESULTS_VIEW_MODE = "results_view_mode";
    private static final String PROP_PROVIDER = "provider";
    private static final String PROP_OPEN_IN_NEW_TAB = "open_in_new_tab";

    private FindDialogMemory() {
        prefs = NbPreferences.forModule(FindDialogMemory.class).node(PREFS_NODE);
        this.load();
    }

    public static FindDialogMemory getDefault() {
        if (singleton == null) {
            singleton = new FindDialogMemory();
        }
        return singleton;
    }

    private void load() {
        String string;
        int n;
        this.wholeWords = prefs.getBoolean(PROP_WHOLE_WORDS, false);
        this.caseSensitive = prefs.getBoolean(PROP_CASE_SENSITIVE, false);
        try {
            String string2 = prefs.get(PROP_MATCH_TYPE, SearchPattern.MatchType.LITERAL.name());
            this.matchType = SearchPattern.MatchType.valueOf(string2);
        }
        catch (Exception exception) {
            this.matchType = SearchPattern.MatchType.LITERAL;
        }
        this.preserveCase = prefs.getBoolean(PROP_PRESERVE_CASE, false);
        this.scopeTypeId = prefs.get(PROP_SCOPE_TYPE_ID, "open projects");
        this.fileNamePatternSpecified = prefs.getBoolean(PROP_FILENAME_PATTERN_SPECIFIED, false);
        this.searchInArchives = prefs.getBoolean(PROP_SEARCH_IN_ARCHIVES, false);
        this.searchInGenerated = prefs.getBoolean(PROP_SEARCH_IN_GENERATED, false);
        this.filePathRegex = prefs.getBoolean(PROP_FILE_PATH_REGEX, false);
        this.useIgnoreList = prefs.getBoolean(PROP_USE_IGNORE_LIST, false);
        this.textSandboxContent = prefs.get(PROP_TEXT_SANDBOX_CONTENT, this.getText("TextPatternSandbox.textPane.text.default"));
        this.pathSandboxContent = prefs.get(PROP_PATH_SANDBOX_CONTENT, this.getText("PathPatternSandbox.textPane.text.default"));
        this.resultsColumnWidths = prefs.get(PROP_RESULTS_COLUMN_WIDTHS, "100:-1:-1:-1:|0:");
        this.resultsColumnWidthsDetails = prefs.get(PROP_RESULTS_COLUMN_WIDTHS_DETAILS, "100:-1:-1:-1:-1:|0:");
        this.resultsColumnWidthsReplacing = prefs.get(PROP_RESULTS_COLUMN_WIDTHS_REPLACING, "100:-1:-1:-1:-1:|0:");
        this.replaceResultsDivider = prefs.getInt(PROP_REPLACE_RESULTS_DIVIDER, -1);
        this.resultsViewMode = prefs.get(PROP_RESULTS_VIEW_MODE, null);
        this.provider = prefs.get(PROP_PROVIDER, null);
        this.openInNewTab = prefs.getBoolean(PROP_OPEN_IN_NEW_TAB, true);
        this.fileNamePatterns = new ArrayList<String>(10);
        this.ignoreList = new ArrayList<String>();
        for (n = 0; n < 10; ++n) {
            string = prefs.get(PROP_FILENAME_PATTERN_PREFIX + n, null);
            if (string == null) continue;
            this.fileNamePatterns.add(string);
        }
        if (this.fileNamePatterns.isEmpty()) {
            FindDialogMemory.addDefaultFileNamePatterns(this.fileNamePatterns);
        }
        n = 0;
        while ((string = prefs.get(PROP_IGNORE_LIST_PREFIX + n, null)) != null) {
            this.ignoreList.add(string);
            ++n;
        }
    }

    public void storeFileNamePattern(String string) {
        int n = this.fileNamePatterns.indexOf(string);
        if (n != -1) {
            if (n == this.fileNamePatterns.size() - 1) {
                return;
            }
            this.fileNamePatterns.remove(n);
        } else if (this.fileNamePatterns.size() == 10) {
            this.fileNamePatterns.remove(0);
        }
        this.fileNamePatterns.add(string);
        for (int i = 0; i < this.fileNamePatterns.size(); ++i) {
            prefs.put(PROP_FILENAME_PATTERN_PREFIX + i, this.fileNamePatterns.get(i));
        }
    }

    public List<String> getFileNamePatterns() {
        return this.fileNamePatterns != null ? this.fileNamePatterns : Collections.emptyList();
    }

    private static void addDefaultFileNamePatterns(List<String> list) {
        String[] stringArray = new String[]{"*.properties", "*.txt", "*.php", "*.xml", "*.java"};
        int n = 10 - list.size();
        for (int i = 0; i < n && i < stringArray.length; ++i) {
            list.add(stringArray[i]);
        }
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean bl) {
        this.wholeWords = bl;
        prefs.putBoolean(PROP_WHOLE_WORDS, bl);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isPreserveCase() {
        return this.preserveCase;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
        prefs.putBoolean(PROP_CASE_SENSITIVE, bl);
    }

    public void setPreserveCase(boolean bl) {
        this.preserveCase = bl;
        prefs.putBoolean(PROP_PRESERVE_CASE, bl);
    }

    public SearchPattern.MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(SearchPattern.MatchType matchType) {
        this.matchType = matchType;
        prefs.put(PROP_MATCH_TYPE, matchType.name());
    }

    public String getScopeTypeId() {
        return this.scopeTypeId;
    }

    public void setScopeTypeId(String string) {
        this.scopeTypeId = string;
        prefs.put(PROP_SCOPE_TYPE_ID, string);
    }

    public boolean isTextPatternSpecified() {
        return this.textPatternSpecified;
    }

    void setTextPatternSpecified(boolean bl) {
        this.textPatternSpecified = bl;
    }

    public boolean isReplacePatternSpecified() {
        return this.replacePatternSpecified;
    }

    public void setReplacePatternSpecified(boolean bl) {
        this.replacePatternSpecified = bl;
    }

    boolean isFileNamePatternSpecified() {
        return this.fileNamePatternSpecified;
    }

    public void setFileNamePatternSpecified(boolean bl) {
        this.fileNamePatternSpecified = bl;
        prefs.putBoolean(PROP_FILENAME_PATTERN_SPECIFIED, bl);
    }

    boolean isSearchInArchives() {
        return this.searchInArchives;
    }

    void setSearchInArchives(boolean bl) {
        this.searchInArchives = bl;
        prefs.putBoolean(PROP_SEARCH_IN_GENERATED, bl);
    }

    boolean isSearchInGenerated() {
        return this.searchInGenerated;
    }

    void setSearchInGenerated(boolean bl) {
        this.searchInGenerated = bl;
        prefs.putBoolean(PROP_SEARCH_IN_GENERATED, bl);
    }

    boolean isFilePathRegex() {
        return this.filePathRegex;
    }

    void setFilePathRegex(boolean bl) {
        this.filePathRegex = bl;
        prefs.putBoolean(PROP_FILE_PATH_REGEX, bl);
    }

    boolean IsUseIgnoreList() {
        return this.useIgnoreList;
    }

    void setUseIgnoreList(boolean bl) {
        this.useIgnoreList = bl;
        prefs.putBoolean(PROP_USE_IGNORE_LIST, bl);
    }

    String getTextSandboxContent() {
        return this.textSandboxContent;
    }

    void setTextSandboxContent(String string) {
        this.textSandboxContent = string;
        prefs.put(PROP_TEXT_SANDBOX_CONTENT, string);
    }

    String getPathSandboxContent() {
        return this.pathSandboxContent;
    }

    void setPathSandboxContent(String string) {
        this.pathSandboxContent = string;
        prefs.put(PROP_PATH_SANDBOX_CONTENT, string);
    }

    List<String> getIgnoreList() {
        if (this.ignoreList == null) {
            return Collections.emptyList();
        }
        return this.ignoreList;
    }

    void setIgnoreList(List<String> list) {
        this.ignoreList = list;
        int n = 0;
        while (prefs.get(PROP_IGNORE_LIST_PREFIX + n, null) != null) {
            prefs.remove(PROP_IGNORE_LIST_PREFIX + n);
            ++n;
        }
        for (int i = 0; i < list.size(); ++i) {
            prefs.put(PROP_IGNORE_LIST_PREFIX + i, list.get(i));
        }
    }

    private String getText(String string) {
        return NbBundle.getMessage(FindDialogMemory.class, (String)string);
    }

    public String getResultsColumnWidths() {
        return this.resultsColumnWidths;
    }

    public void setResultsColumnWidths(String string) {
        this.resultsColumnWidths = string;
        prefs.put(PROP_RESULTS_COLUMN_WIDTHS, string);
    }

    public String getResultsColumnWidthsDetails() {
        return this.resultsColumnWidthsDetails;
    }

    public void setResultsColumnWidthsDetails(String string) {
        this.resultsColumnWidthsDetails = string;
        prefs.put(PROP_RESULTS_COLUMN_WIDTHS_DETAILS, string);
    }

    public String getResultsColumnWidthsReplacing() {
        return this.resultsColumnWidthsReplacing;
    }

    public void setResultsColumnWidthsReplacing(String string) {
        this.resultsColumnWidthsReplacing = string;
        prefs.put(PROP_RESULTS_COLUMN_WIDTHS_REPLACING, string);
    }

    public int getReplaceResultsDivider() {
        return this.replaceResultsDivider;
    }

    public void setReplaceResultsDivider(int n) {
        this.replaceResultsDivider = n;
        prefs.putInt(PROP_REPLACE_RESULTS_DIVIDER, n);
    }

    public String getResultsViewMode() {
        return this.resultsViewMode;
    }

    public void setResultsViewMode(String string) {
        this.resultsViewMode = string;
        prefs.put(PROP_RESULTS_VIEW_MODE, string);
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
        prefs.put(PROP_PROVIDER, string);
    }

    public boolean isOpenInNewTab() {
        return this.openInNewTab;
    }

    public void setOpenInNewTab(boolean bl) {
        this.openInNewTab = bl;
        prefs.putBoolean(PROP_OPEN_IN_NEW_TAB, bl);
    }
}

