/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class GeoBoundingBoxQueryBuilder
extends QueryBuilder {
    public static final String TOP_LEFT = "top_left";
    public static final String BOTTOM_RIGHT = "bottom_right";
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int BOTTOM = 2;
    private static final int RIGHT = 3;
    private final String name;
    private double[] box = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private String queryName;
    private String type;
    private Boolean coerce;
    private Boolean ignoreMalformed;

    public GeoBoundingBoxQueryBuilder(String name) {
        this.name = name;
    }

    public GeoBoundingBoxQueryBuilder topLeft(double lat, double lon) {
        this.box[0] = lat;
        this.box[1] = lon;
        return this;
    }

    public GeoBoundingBoxQueryBuilder topLeft(GeoPoint point) {
        return this.topLeft(point.lat(), point.lon());
    }

    public GeoBoundingBoxQueryBuilder topLeft(String geohash) {
        return this.topLeft(GeoPoint.fromGeohash(geohash));
    }

    public GeoBoundingBoxQueryBuilder bottomRight(double lat, double lon) {
        this.box[2] = lat;
        this.box[3] = lon;
        return this;
    }

    public GeoBoundingBoxQueryBuilder bottomRight(GeoPoint point) {
        return this.bottomRight(point.lat(), point.lon());
    }

    public GeoBoundingBoxQueryBuilder bottomRight(String geohash) {
        return this.bottomRight(GeoPoint.fromGeohash(geohash));
    }

    public GeoBoundingBoxQueryBuilder bottomLeft(double lat, double lon) {
        this.box[2] = lat;
        this.box[1] = lon;
        return this;
    }

    public GeoBoundingBoxQueryBuilder bottomLeft(GeoPoint point) {
        return this.bottomLeft(point.lat(), point.lon());
    }

    public GeoBoundingBoxQueryBuilder bottomLeft(String geohash) {
        return this.bottomLeft(GeoPoint.fromGeohash(geohash));
    }

    public GeoBoundingBoxQueryBuilder topRight(double lat, double lon) {
        this.box[0] = lat;
        this.box[3] = lon;
        return this;
    }

    public GeoBoundingBoxQueryBuilder topRight(GeoPoint point) {
        return this.topRight(point.lat(), point.lon());
    }

    public GeoBoundingBoxQueryBuilder topRight(String geohash) {
        return this.topRight(GeoPoint.fromGeohash(geohash));
    }

    public GeoBoundingBoxQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public GeoBoundingBoxQueryBuilder coerce(boolean coerce) {
        this.coerce = coerce;
        return this;
    }

    public GeoBoundingBoxQueryBuilder ignoreMalformed(boolean ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
        return this;
    }

    public GeoBoundingBoxQueryBuilder type(String type) {
        this.type = type;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (Double.isNaN(this.box[0])) {
            throw new IllegalArgumentException("geo_bounding_box requires top latitude to be set");
        }
        if (Double.isNaN(this.box[2])) {
            throw new IllegalArgumentException("geo_bounding_box requires bottom latitude to be set");
        }
        if (Double.isNaN(this.box[3])) {
            throw new IllegalArgumentException("geo_bounding_box requires right longitude to be set");
        }
        if (Double.isNaN(this.box[1])) {
            throw new IllegalArgumentException("geo_bounding_box requires left longitude to be set");
        }
        builder.startObject("geo_bbox");
        builder.startObject(this.name);
        builder.array(TOP_LEFT, this.box[1], this.box[0]);
        builder.array(BOTTOM_RIGHT, this.box[3], this.box[2]);
        builder.endObject();
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.type != null) {
            builder.field("type", this.type);
        }
        if (this.coerce != null) {
            builder.field("coerce", (Object)this.coerce);
        }
        if (this.ignoreMalformed != null) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed);
        }
        builder.endObject();
    }
}

