/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.quality.CodeNarc;
import org.gradle.api.plugins.quality.CodeNarcExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeNarcPlugin
extends AbstractCodeQualityPlugin<CodeNarc> {
    public static final String DEFAULT_CODENARC_VERSION = "0.24.1";
    private CodeNarcExtension extension;

    @Override
    protected String getToolName() {
        return "CodeNarc";
    }

    @Override
    protected Class<CodeNarc> getTaskType() {
        return CodeNarc.class;
    }

    @Override
    protected Class<? extends Plugin> getBasePlugin() {
        return GroovyBasePlugin.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (CodeNarcExtension)((Object)this.project.getExtensions().create("codenarc", CodeNarcExtension.class, new Object[]{this.project}));
        this.extension.setToolVersion(DEFAULT_CODENARC_VERSION);
        this.extension.setConfig(this.project.getResources().getText().fromFile((Object)this.project.getRootProject().file((Object)"config/codenarc/codenarc.xml")));
        this.extension.setMaxPriority1Violations(0);
        this.extension.setMaxPriority2Violations(0);
        this.extension.setMaxPriority3Violations(0);
        this.extension.setReportFormat("html");
        return this.extension;
    }

    @Override
    protected void configureTaskDefaults(CodeNarc task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt("codenarc");
        this.configureDefaultDependencies(configuration);
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)CodeNarcPlugin.this.project.getDependencies().create((Object)("org.codenarc:CodeNarc:" + CodeNarcPlugin.this.extension.getToolVersion())));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, CodeNarc task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("codenarcClasspath", Callables.returning((Object)configuration));
        taskMapping.map("config", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return CodeNarcPlugin.this.extension.getConfig();
            }
        });
        taskMapping.map("maxPriority1Violations", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return CodeNarcPlugin.this.extension.getMaxPriority1Violations();
            }
        });
        taskMapping.map("maxPriority2Violations", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return CodeNarcPlugin.this.extension.getMaxPriority2Violations();
            }
        });
        taskMapping.map("maxPriority3Violations", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return CodeNarcPlugin.this.extension.getMaxPriority3Violations();
            }
        });
        taskMapping.map("ignoreFailures", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return CodeNarcPlugin.this.extension.isIgnoreFailures();
            }
        });
    }

    private void configureReportsConventionMapping(CodeNarc task, final String baseName) {
        task.getReports().all((Action)new Action<SingleFileReport>(){

            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = CodeNarcPlugin.conventionMappingOf(report);
                reportMapping.map("enabled", (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return report.getName().equals(CodeNarcPlugin.this.extension.getReportFormat());
                    }
                });
                reportMapping.map("destination", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        String fileSuffix = report.getName().equals("text") ? "txt" : report.getName();
                        return new File(CodeNarcPlugin.this.extension.getReportsDir(), baseName + "." + fileSuffix);
                    }
                });
            }
        });
    }

    @Override
    protected void configureForSourceSet(final SourceSet sourceSet, CodeNarc task) {
        task.setDescription("Run CodeNarc analysis for " + sourceSet.getName() + " classes");
        task.getConventionMapping().map("source", (Callable)new Callable<SourceDirectorySet>(){

            @Override
            public SourceDirectorySet call() throws Exception {
                Convention sourceSetConvention = new DslObject((Object)sourceSet).getConvention();
                GroovySourceSet groovySourceSet = (GroovySourceSet)sourceSetConvention.findPlugin(GroovySourceSet.class);
                if (groovySourceSet == null) {
                    return null;
                }
                return groovySourceSet.getAllGroovy();
            }
        });
    }
}

