/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.changedetection.state.CachingTreeVisitor;
import org.gradle.api.internal.changedetection.state.OverlappingDirectoriesDetector;
import org.gradle.api.internal.file.BackingFileExtractor;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.Factory;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeVisitorCacheExpirationStrategy
implements TaskExecutionGraphListener,
TaskExecutionListener,
BuildListener {
    private static final Logger LOG = Logging.getLogger(TreeVisitorCacheExpirationStrategy.class);
    private final CachingTreeVisitor cachingTreeVisitor;
    private final Factory<OverlappingDirectoriesDetector> overlappingDirectoriesDetectorFactory;
    private Map<String, Collection<String>> lastTaskToHandleInputFile;
    private Set<String> tasksWithUnknownInputs;
    private Set<String> tasksWithUnknownOutputs;

    public TreeVisitorCacheExpirationStrategy(CachingTreeVisitor cachingTreeVisitor, Factory<OverlappingDirectoriesDetector> overlappingDirectoriesDetectorFactory) {
        this.cachingTreeVisitor = cachingTreeVisitor;
        this.overlappingDirectoriesDetectorFactory = overlappingDirectoriesDetectorFactory;
    }

    @Override
    public void graphPopulated(TaskExecutionGraph graph) {
        this.resolveCacheableFilesAndLastTasksToHandleEachFile(graph);
    }

    private void resolveCacheableFilesAndLastTasksToHandleEachFile(TaskExecutionGraph graph) {
        ArrayList<String> cacheableFilePaths = new ArrayList<String>();
        this.tasksWithUnknownInputs = new HashSet<String>();
        this.tasksWithUnknownOutputs = new HashSet<String>();
        HashMap<String, List<String>> inputFileToTaskPaths = new HashMap<String, List<String>>();
        HashSet<String> cumulatedInputsAndOutputs = new HashSet<String>();
        OverlappingDirectoriesDetector detector = (OverlappingDirectoriesDetector)this.overlappingDirectoriesDetectorFactory.create();
        for (Task task : graph.getAllTasks()) {
            String taskPath = task.getPath();
            List<String> inputPaths = this.extractFilePaths(task.getInputs().getFiles());
            if (inputPaths.size() > 0) {
                this.storeFilesToMapWithTaskPathAsKey(taskPath, inputPaths, inputFileToTaskPaths);
                for (String path : inputPaths) {
                    if (!cumulatedInputsAndOutputs.contains(path)) continue;
                    cacheableFilePaths.add(path);
                }
                cumulatedInputsAndOutputs.addAll(inputPaths);
            } else if (!task.getInputs().getHasInputs()) {
                this.tasksWithUnknownInputs.add(taskPath);
            }
            List<String> outputPaths = this.extractFilePaths(task.getOutputs().getFiles());
            if (outputPaths.size() > 0) {
                cumulatedInputsAndOutputs.addAll(outputPaths);
                detector.addPaths(outputPaths);
                continue;
            }
            if (task.getOutputs().getHasOutput()) continue;
            this.tasksWithUnknownOutputs.add(taskPath);
        }
        this.resolveLastTasksToHandleEachFile(inputFileToTaskPaths);
        cacheableFilePaths.removeAll(detector.resolveOverlappingPaths());
        this.cachingTreeVisitor.updateCacheableFilePaths(cacheableFilePaths);
    }

    private void resolveLastTasksToHandleEachFile(Map<String, List<String>> inputFileToTaskPaths) {
        this.lastTaskToHandleInputFile = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, List<String>> entry : inputFileToTaskPaths.entrySet()) {
            String lastTaskPath = entry.getValue().get(entry.getValue().size() - 1);
            Collection<String> filePaths = this.lastTaskToHandleInputFile.get(lastTaskPath);
            if (filePaths == null) {
                filePaths = new ArrayList<String>();
                this.lastTaskToHandleInputFile.put(lastTaskPath, filePaths);
            }
            filePaths.add(entry.getKey());
        }
    }

    private void storeFilesToMapWithTaskPathAsKey(String taskPath, List<String> files, Map<String, List<String>> map) {
        for (String filePath : files) {
            List<String> currentTaskPaths = map.get(filePath);
            if (currentTaskPaths == null) {
                currentTaskPaths = new ArrayList<String>();
                map.put(filePath, currentTaskPaths);
            }
            currentTaskPaths.add(taskPath);
        }
    }

    private List<String> extractFilePaths(FileCollection files) {
        List<BackingFileExtractor.FileEntry> entries = new BackingFileExtractor().extractFilesOrDirectories(files);
        return CollectionUtils.collect(entries, (Transformer)new Transformer<String, BackingFileExtractor.FileEntry>(){

            public String transform(BackingFileExtractor.FileEntry fileEntry) {
                return fileEntry.getFile().getAbsolutePath();
            }
        });
    }

    @Override
    public void beforeExecute(Task task) {
        String taskPath = task.getPath();
        if (this.tasksWithUnknownInputs != null && this.tasksWithUnknownInputs.contains(taskPath)) {
            LOG.info("Flushing directory cache because task {} has unknown inputs at configuration time.", (Object)taskPath);
            this.cachingTreeVisitor.clearCache();
        }
    }

    @Override
    public void afterExecute(Task task, TaskState state) {
        Collection<String> filePaths;
        String taskPath = task.getPath();
        if (this.tasksWithUnknownOutputs != null && this.tasksWithUnknownOutputs.contains(taskPath)) {
            LOG.info("Flushing directory cache because task {} has unknown outputs at configuration time.", (Object)taskPath);
            this.cachingTreeVisitor.clearCache();
        } else if (this.lastTaskToHandleInputFile != null && (filePaths = this.lastTaskToHandleInputFile.get(taskPath)) != null) {
            this.cachingTreeVisitor.invalidateFilePaths(filePaths);
        }
    }

    @Override
    public void buildStarted(Gradle gradle) {
    }

    @Override
    public void settingsEvaluated(Settings settings) {
    }

    @Override
    public void projectsLoaded(Gradle gradle) {
    }

    @Override
    public void projectsEvaluated(Gradle gradle) {
    }

    @Override
    public void buildFinished(BuildResult result) {
        this.cachingTreeVisitor.clearCache();
    }
}

