/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.tasks.util.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackingFileExtractor {
    public List<FileEntry> extractFilesOrDirectories(FileCollection fileCollection) {
        DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext(new IdentityFileResolver());
        context.add(fileCollection);
        List<FileCollectionInternal> fileCollections = context.resolveAsFileCollections();
        ArrayList<FileEntry> results = new ArrayList<FileEntry>();
        for (FileCollectionInternal files : fileCollections) {
            this.collectDirectories(files, results);
        }
        return results;
    }

    private void collectDirectories(FileCollectionInternal fileCollection, List<FileEntry> results) {
        if (fileCollection instanceof FileTreeAdapter) {
            this.collectTree(((FileTreeAdapter)fileCollection).getTree(), results);
        } else {
            for (File file : fileCollection.getFiles()) {
                results.add(new FileEntry(file));
            }
        }
    }

    private void collectTree(MinimalFileTree fileTree, List<FileEntry> results) {
        if (fileTree instanceof DirectoryTree) {
            DirectoryTree directoryTree = (DirectoryTree)((Object)fileTree);
            results.add(new FileEntry(directoryTree.getDir(), directoryTree.getPatterns()));
        }
    }

    public static class FileEntry {
        private final File file;
        private final PatternSet patterns;

        public FileEntry(File file) {
            this.file = file;
            this.patterns = null;
        }

        public FileEntry(File dir, PatternSet patterns) {
            this.file = dir;
            this.patterns = patterns;
        }

        public File getFile() {
            return this.file;
        }

        public PatternSet getPatterns() {
            return this.patterns;
        }
    }
}

