/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.ServiceLoader;
import org.gradle.api.Incubating;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.ScriptPluginFactoryProvider;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.service.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ScriptPluginFactorySelector
implements ScriptPluginFactory {
    private final ScriptPluginFactory defaultScriptPluginFactory;
    private final ServiceRegistry serviceRegistry;

    public ScriptPluginFactorySelector(ScriptPluginFactory defaultScriptPluginFactory, ServiceRegistry serviceRegistry) {
        this.defaultScriptPluginFactory = defaultScriptPluginFactory;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
        return this.scriptPluginFactoryFor(scriptSource.getFileName()).create(scriptSource, scriptHandler, targetScope, baseScope, topLevelScript);
    }

    private ScriptPluginFactory scriptPluginFactoryFor(String fileName) {
        return fileName.endsWith(".gradle") ? this.defaultScriptPluginFactory : this.findScriptPluginFactoryFor(fileName);
    }

    private ScriptPluginFactory findScriptPluginFactoryFor(String fileName) {
        for (ScriptPluginFactoryProvider scriptPluginFactoryProvider : this.scriptPluginFactoryProviders()) {
            ScriptPluginFactory scriptPluginFactory = scriptPluginFactoryProvider.getFor(fileName, this.serviceRegistry);
            if (scriptPluginFactory == null) continue;
            return scriptPluginFactory;
        }
        return this.defaultScriptPluginFactory;
    }

    private Iterable<ScriptPluginFactoryProvider> scriptPluginFactoryProviders() {
        return ServiceLoader.load(ScriptPluginFactoryProvider.class, this.getClass().getClassLoader());
    }
}

