/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractCompositeExcludeRuleFilter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExcludeRuleFilter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ArtifactExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeAllModulesSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.GroupNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExcludeRuleFilters;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleIdExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleNameExcludeSpec;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipleExcludeRulesFilter
extends AbstractCompositeExcludeRuleFilter {
    private final Set<AbstractModuleExcludeRuleFilter> excludeSpecs = new HashSet<AbstractModuleExcludeRuleFilter>();

    public MultipleExcludeRulesFilter(Collection<AbstractModuleExcludeRuleFilter> specs) {
        this.excludeSpecs.addAll(specs);
    }

    @Override
    Collection<AbstractModuleExcludeRuleFilter> getFilters() {
        return this.excludeSpecs;
    }

    @Override
    protected boolean acceptsAllModules() {
        for (AbstractModuleExcludeRuleFilter excludeSpec : this.excludeSpecs) {
            if (excludeSpec.acceptsAllModules()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptModule(ModuleIdentifier element) {
        for (AbstractModuleExcludeRuleFilter excludeSpec : this.excludeSpecs) {
            if (excludeSpec.acceptModule(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        for (AbstractModuleExcludeRuleFilter excludeSpec : this.excludeSpecs) {
            if (excludeSpec.acceptArtifact(module, artifact)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptsAllArtifacts() {
        for (AbstractModuleExcludeRuleFilter spec : this.excludeSpecs) {
            if (spec.acceptsAllArtifacts()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void unpackIntersection(Collection<AbstractModuleExcludeRuleFilter> specs) {
        specs.addAll(this.excludeSpecs);
    }

    @Override
    protected AbstractModuleExcludeRuleFilter maybeMergeIntoUnion(AbstractModuleExcludeRuleFilter other) {
        if (!(other instanceof MultipleExcludeRulesFilter)) {
            return null;
        }
        MultipleExcludeRulesFilter multipleExcludeRulesSpec = (MultipleExcludeRulesFilter)other;
        if (this.excludeSpecs.equals(multipleExcludeRulesSpec.excludeSpecs)) {
            return this;
        }
        for (AbstractModuleExcludeRuleFilter excludeSpec : this.excludeSpecs) {
            if (this.canMerge(excludeSpec)) continue;
            return null;
        }
        for (AbstractModuleExcludeRuleFilter excludeSpec : multipleExcludeRulesSpec.excludeSpecs) {
            if (this.canMerge(excludeSpec)) continue;
            return null;
        }
        ArrayList<AbstractModuleExcludeRuleFilter> merged = new ArrayList<AbstractModuleExcludeRuleFilter>();
        for (AbstractModuleExcludeRuleFilter thisSpec : this.excludeSpecs) {
            for (AbstractModuleExcludeRuleFilter otherSpec : multipleExcludeRulesSpec.excludeSpecs) {
                this.mergeExcludeRules(thisSpec, otherSpec, merged);
            }
        }
        if (merged.isEmpty()) {
            return ModuleExcludeRuleFilters.EXCLUDE_NONE;
        }
        return new MultipleExcludeRulesFilter(merged);
    }

    private boolean canMerge(AbstractModuleExcludeRuleFilter excludeSpec) {
        return excludeSpec instanceof ExcludeAllModulesSpec || excludeSpec instanceof ArtifactExcludeSpec || excludeSpec instanceof GroupNameExcludeSpec || excludeSpec instanceof ModuleNameExcludeSpec || excludeSpec instanceof ModuleIdExcludeSpec;
    }

    private void mergeExcludeRules(AbstractModuleExcludeRuleFilter spec1, AbstractModuleExcludeRuleFilter spec2, List<AbstractModuleExcludeRuleFilter> merged) {
        if (spec1 instanceof ExcludeAllModulesSpec) {
            merged.add(spec2);
        } else if (spec2 instanceof ExcludeAllModulesSpec) {
            merged.add(spec1);
        } else if (spec1 instanceof ArtifactExcludeSpec) {
            merged.add(spec1);
        } else if (spec2 instanceof ArtifactExcludeSpec) {
            merged.add(spec2);
        } else if (spec1 instanceof GroupNameExcludeSpec) {
            this.mergeExcludeRules((GroupNameExcludeSpec)spec1, spec2, merged);
        } else if (spec2 instanceof GroupNameExcludeSpec) {
            this.mergeExcludeRules((GroupNameExcludeSpec)spec2, spec1, merged);
        } else if (spec1 instanceof ModuleNameExcludeSpec) {
            this.mergeExcludeRules((ModuleNameExcludeSpec)spec1, spec2, merged);
        } else if (spec2 instanceof ModuleNameExcludeSpec) {
            this.mergeExcludeRules((ModuleNameExcludeSpec)spec2, spec1, merged);
        } else if (spec1 instanceof ModuleIdExcludeSpec && spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleSpec1 = (ModuleIdExcludeSpec)spec1;
            ModuleIdExcludeSpec moduleSpec2 = (ModuleIdExcludeSpec)spec2;
            if (moduleSpec1.moduleId.equals(moduleSpec2.moduleId)) {
                merged.add(moduleSpec1);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }

    private void mergeExcludeRules(GroupNameExcludeSpec spec1, AbstractModuleExcludeRuleFilter spec2, List<AbstractModuleExcludeRuleFilter> merged) {
        if (spec2 instanceof GroupNameExcludeSpec) {
            GroupNameExcludeSpec groupNameExcludeSpec = (GroupNameExcludeSpec)spec2;
            if (spec1.group.equals(groupNameExcludeSpec.group)) {
                merged.add(spec1);
            }
        } else if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
            merged.add(new ModuleIdExcludeSpec(spec1.group, moduleNameExcludeSpec.module));
        } else if (spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
            if (moduleIdExcludeSpec.moduleId.getGroup().equals(spec1.group)) {
                merged.add(spec2);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }

    private void mergeExcludeRules(ModuleNameExcludeSpec spec1, AbstractModuleExcludeRuleFilter spec2, List<AbstractModuleExcludeRuleFilter> merged) {
        if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
            if (spec1.module.equals(moduleNameExcludeSpec.module)) {
                merged.add(spec1);
            }
        } else if (spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
            if (moduleIdExcludeSpec.moduleId.getName().equals(spec1.module)) {
                merged.add(spec2);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }
}

