/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs2d;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javajs.J2SRequireImport;
import javajs.api.EventManager;
import javajs.api.GenericMouseInterface;
import javajs.awt.event.Event;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

@J2SRequireImport(value={Event.class})
public class Mouse
implements GenericMouseInterface {
    private Viewer vwr;
    private EventManager manager;
    private String keyBuffer = "";
    private boolean isMouseDown;
    private boolean wheeling;
    private int modifiersDown;
    private int xWhenPressed;
    private int yWhenPressed;
    private int modifiersWhenPressed10;

    public Mouse(double privateKey, Viewer vwr, Object display) {
        this.vwr = vwr;
        this.manager = this.vwr.acm;
    }

    @Override
    public void clear() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean processEvent(int id, int x, int y, int modifiers, long time) {
        if (id != -1) {
            modifiers = Mouse.applyLeftMouse(modifiers);
        }
        switch (id) {
            case -1: {
                this.wheeled(time, x, modifiers);
                break;
            }
            case 501: {
                this.xWhenPressed = x;
                this.yWhenPressed = y;
                this.modifiersWhenPressed10 = modifiers;
                this.pressed(time, x, y, modifiers, false);
                break;
            }
            case 506: {
                this.dragged(time, x, y, modifiers);
                break;
            }
            case 504: {
                this.entry(time, x, y, false);
                break;
            }
            case 505: {
                this.entry(time, x, y, true);
                break;
            }
            case 503: {
                this.moved(time, x, y, modifiers);
                break;
            }
            case 502: {
                this.released(time, x, y, modifiers);
                if (x != this.xWhenPressed || y != this.yWhenPressed || modifiers != this.modifiersWhenPressed10) break;
                this.clicked(time, x, y, modifiers, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void processTwoPointGesture(float[][][] touches) {
        if (touches[0].length < 2) {
            return;
        }
        float[][] t1 = touches[0];
        float[][] t2 = touches[1];
        float[] t1first = t1[0];
        float[] t1last = t1[t2.length - 1];
        float x1first = t1first[0];
        float x1last = t1last[0];
        float dx1 = x1last - x1first;
        float y1first = t1first[1];
        float y1last = t1last[1];
        float dy1 = y1last - y1first;
        V3 v1 = V3.new3(dx1, dy1, 0.0f);
        float d1 = v1.length();
        float[] t2first = t2[0];
        float[] t2last = t2[t2.length - 1];
        float x2first = t2first[0];
        float x2last = t2last[0];
        float dx2 = x2last - x2first;
        float y2first = t2first[1];
        float y2last = t2last[1];
        float dy2 = y2last - y2first;
        V3 v2 = V3.new3(dx2, dy2, 0.0f);
        float d2 = v2.length();
        if (d1 < 1.0f || d2 < 1.0f) {
            return;
        }
        v1.normalize();
        v2.normalize();
        float cos12 = v1.dot(v2);
        if ((double)cos12 > 0.8) {
            int deltaX = (int)(x1last - t1[t1.length - 2][0]);
            int deltaY = (int)(y1last - t1[t1.length - 2][1]);
            this.vwr.translateXYBy(deltaX, deltaY);
        } else if ((double)cos12 < -0.8) {
            v1 = V3.new3(x2first - x1first, y2first - y1first, 0.0f);
            v2 = V3.new3(x2last - x1last, y2last - y1last, 0.0f);
            float dx = v2.length() - v1.length();
            this.wheeled(System.currentTimeMillis(), dx < 0.0f ? -1 : 1, 32);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.clicked(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.getClickCount());
    }

    public void mouseEntered(MouseEvent e) {
        this.entry(e.getWhen(), e.getX(), e.getY(), false);
    }

    public void mouseExited(MouseEvent e) {
        this.entry(e.getWhen(), e.getX(), e.getY(), true);
    }

    public void mousePressed(MouseEvent e) {
        this.pressed(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.isPopupTrigger());
    }

    public void mouseReleased(MouseEvent e) {
        this.released(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    public void mouseDragged(MouseEvent e) {
        int modifiers = e.getModifiers();
        if ((modifiers & 0x1C) == 0) {
            modifiers |= 0x10;
        }
        this.dragged(e.getWhen(), e.getX(), e.getY(), modifiers);
    }

    public void mouseMoved(MouseEvent e) {
        this.moved(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        this.wheeled(e.getWhen(), e.getWheelRotation(), e.getModifiers());
    }

    public void keyTyped(KeyEvent ke) {
        ke.consume();
        if (!this.vwr.menuEnabled()) {
            return;
        }
        char ch = ke.getKeyChar();
        int modifiers = ke.getModifiers();
        if (Logger.debuggingHigh) {
            Logger.debug("MouseManager keyTyped: " + ch + " " + ('\u0000' + ch) + " " + modifiers);
        }
        if (modifiers != 0 && modifiers != 1) {
            switch (ch) {
                case '\u000b': 
                case 'k': {
                    boolean isON = !this.vwr.getBooleanProperty("allowKeyStrokes");
                    switch (modifiers) {
                        case 2: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", isON);
                            this.vwr.setBooleanProperty("showKeyStrokes", true);
                            break;
                        }
                        case 1: 
                        case 10: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", isON);
                            this.vwr.setBooleanProperty("showKeyStrokes", false);
                        }
                    }
                    this.clearKeyBuffer();
                    this.vwr.refresh(3, "showkey");
                    break;
                }
                case '\u0016': 
                case 'v': {
                    switch (modifiers) {
                        default: 
                    }
                    break;
                }
                case '\u001a': 
                case 'z': {
                    switch (modifiers) {
                        case 2: {
                            this.vwr.undoMoveAction(4165, 1);
                            break;
                        }
                        case 3: {
                            this.vwr.undoMoveAction(4139, 1);
                        }
                    }
                    break;
                }
                case '\u0019': 
                case 'y': {
                    switch (modifiers) {
                        case 2: {
                            this.vwr.undoMoveAction(4139, 1);
                        }
                    }
                }
            }
            return;
        }
        if (!this.vwr.getBooleanProperty("allowKeyStrokes")) {
            return;
        }
        this.addKeyBuffer(ke.getModifiers() == 1 ? Character.toUpperCase(ch) : ch);
    }

    public void keyPressed(KeyEvent ke) {
        if (this.vwr.isApplet) {
            ke.consume();
        }
        this.manager.keyPressed(ke.getKeyCode(), ke.getModifiers());
    }

    public void keyReleased(KeyEvent ke) {
        ke.consume();
        this.manager.keyReleased(ke.getKeyCode());
    }

    private void clearKeyBuffer() {
        if (this.keyBuffer.length() == 0) {
            return;
        }
        this.keyBuffer = "";
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo \"\"", true, true);
        }
    }

    private void addKeyBuffer(char ch) {
        if (ch == '\n') {
            this.sendKeyBuffer();
            return;
        }
        if (ch == '\b') {
            if (this.keyBuffer.length() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
            }
        } else {
            this.keyBuffer = this.keyBuffer + ch;
        }
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc("\u0001" + this.keyBuffer), true, true);
        }
    }

    private void sendKeyBuffer() {
        String kb = this.keyBuffer;
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc(this.keyBuffer), true, true);
        }
        this.clearKeyBuffer();
        this.vwr.evalStringQuietSync(kb, false, true);
    }

    private void entry(long time, int x, int y, boolean isExit) {
        this.wheeling = false;
        this.isMouseDown = false;
        this.modifiersDown = 0;
        this.manager.mouseEnterExit(time, x, y, isExit);
    }

    private void clicked(long time, int x, int y, int modifiers, int clickCount) {
        this.clearKeyBuffer();
        this.manager.mouseAction(2, time, x, y, 1, modifiers);
    }

    private void moved(long time, int x, int y, int modifiers) {
        this.clearKeyBuffer();
        if (this.isMouseDown) {
            this.manager.mouseAction(1, time, x, y, 0, this.modifiersDown);
        } else {
            this.manager.mouseAction(0, time, x, y, 0, modifiers);
        }
    }

    private void wheeled(long time, int rotation, int modifiers) {
        this.clearKeyBuffer();
        this.wheeling = true;
        this.manager.mouseAction(3, time, 0, rotation, 0, modifiers & 0xFFFFFFE3 | 0x20);
    }

    private void pressed(long time, int x, int y, int modifiers, boolean isPopupTrigger) {
        this.clearKeyBuffer();
        this.isMouseDown = true;
        this.modifiersDown = modifiers;
        this.wheeling = false;
        this.manager.mouseAction(4, time, x, y, 0, modifiers);
    }

    private void released(long time, int x, int y, int modifiers) {
        this.isMouseDown = false;
        this.modifiersDown = 0;
        this.wheeling = false;
        this.manager.mouseAction(5, time, x, y, 0, modifiers);
    }

    private void dragged(long time, int x, int y, int modifiers) {
        if (this.wheeling) {
            return;
        }
        if ((this.modifiersDown & 0x14) == 20) {
            this.modifiersDown = this.modifiersDown & 0xFFFFFFFB | 2;
        }
        this.manager.mouseAction(1, time, x, y, 0, this.modifiersDown);
    }

    private static int applyLeftMouse(int modifiers) {
        return (modifiers & 0x1C) == 0 ? modifiers | 0x10 : modifiers;
    }
}

