/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.ConditionProfile;

@Deprecated
public final class CountingConditionProfile
extends ConditionProfile {
    @CompilerDirectives.CompilationFinal
    private int trueCount;
    @CompilerDirectives.CompilationFinal
    private int falseCount;

    CountingConditionProfile() {
    }

    @Override
    public boolean profile(boolean value) {
        if (value) {
            if (this.trueCount == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (CompilerDirectives.inInterpreter() && this.trueCount < Integer.MAX_VALUE) {
                ++this.trueCount;
            }
        } else {
            if (this.falseCount == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (CompilerDirectives.inInterpreter() && this.falseCount < Integer.MAX_VALUE) {
                ++this.falseCount;
            }
        }
        return CompilerDirectives.injectBranchProbability((double)this.trueCount / (double)(this.trueCount + this.falseCount), value);
    }

    public int getTrueCount() {
        return this.trueCount;
    }

    public int getFalseCount() {
        return this.falseCount;
    }

    public String toString() {
        return String.format("%s(trueCount=%s, falseCount=%s)@%x", this.getClass().getSimpleName(), this.trueCount, this.falseCount, this.hashCode());
    }
}

