/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.configuration;

import de.jensd.fx.glyphs.GlyphsStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StylesConfig {
    private static final Logger LOG = LoggerFactory.getLogger(StylesConfig.class);
    private List<String> styles = new ArrayList<String>();

    public StylesConfig(Theme theme) {
        RequireUtils.requireNotNull((Object)theme, "Theme cannot be null");
        LOG.debug(DefaultI18nContext.getInstance().i18n("Installing theme {0}.", theme.friendlyName()));
        theme.styleSheets().stream().map(s -> this.getClass().getResource((String)s).toExternalForm()).forEach(this.styles::add);
        this.styles.add(this.getClass().getResource(GlyphsStyle.DEFAULT.getStylePath()).toExternalForm());
        if (!Platform.isSupported((ConditionalFeature)ConditionalFeature.TRANSPARENT_WINDOW)) {
            this.styles.add(this.getClass().getResource("/themes/transparent-incapable.css").toExternalForm());
            LOG.info("Transparent windows not supported by the platform");
        }
    }

    public List<String> styles() {
        return Collections.unmodifiableList(this.styles);
    }
}

