/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.module;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModulePriority;

public final class ModuleDescriptor {
    private ModuleCategory category;
    private String name;
    private String description;
    private int priority = ModulePriority.DEFAULT.getPriority();
    private String supportURL;

    ModuleDescriptor(ModuleCategory category, String name, String description, int priority, String supportURL) {
        this.category = category;
        this.name = name;
        this.description = description;
        this.priority = priority;
        this.supportURL = supportURL;
    }

    public ModuleCategory getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPriority() {
        return this.priority;
    }

    public Optional<String> getSupportURL() {
        return Optional.ofNullable(StringUtils.defaultIfBlank(this.supportURL, null));
    }
}

