/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.splitbybookmarks;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.module.PdfsamModule;
import org.pdfsam.module.RequiredPdfData;
import org.pdfsam.splitbybookmarks.SplitByOutlineLevelParametersBuilder;
import org.pdfsam.splitbybookmarks.SplitOptionsPane;
import org.pdfsam.ui.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.prefix.PrefixPane;
import org.pdfsam.ui.selection.single.TaskParametersBuilderSingleSelectionPane;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.parameter.SplitByOutlineLevelParameters;
import org.sejda.model.prefix.Prefix;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@PdfsamModule
public class SplitByBookmarksModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "split.bybookmarks";
    private TaskParametersBuilderSingleSelectionPane selectionPane;
    private BrowsableOutputDirectoryField destinationDirectoryField;
    private PdfDestinationPane destinationPane;
    private SplitOptionsPane splitOptions = new SplitOptionsPane();
    private PrefixPane prefix = new PrefixPane();
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.SPLIT).name(DefaultI18nContext.getInstance().i18n("Split by bookmarks")).description(DefaultI18nContext.getInstance().i18n("Split a PDF document at bookmarked pages by specifying a bookmark level.")).priority(ModulePriority.DEFAULT.getPriority()).supportURL("http://www.pdfsam.org/pdf-split-by-bookmark").build();

    @Inject
    public SplitByBookmarksModule(@Named(value="split.bybookmarksfield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="split.bybookmarkspane") PdfDestinationPane destinationPane) {
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.selectionPane = new TaskParametersBuilderSingleSelectionPane(this.id());
        this.selectionPane.setPromptText(DefaultI18nContext.getInstance().i18n("Select or drag and drop the PDF you want to split"));
        this.selectionPane.addOnLoaded(d -> this.splitOptions.setMaxBookmarkLevel(d.getMaxGoToActionDepth()));
    }

    @Override
    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.splitOptions.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo((Map)data);
        this.destinationPane.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    @Override
    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.splitOptions.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom((Map)data);
        this.destinationPane.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    @Override
    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    protected Builder<SplitByOutlineLevelParameters> getBuilder(Consumer<String> onError) {
        SplitByOutlineLevelParametersBuilder builder = new SplitByOutlineLevelParametersBuilder();
        this.splitOptions.apply(builder, onError);
        this.selectionPane.apply(builder, onError);
        this.destinationDirectoryField.apply(builder, onError);
        this.destinationPane.apply(builder, onError);
        this.prefix.apply(builder, onError);
        return builder;
    }

    @Override
    protected Pane getInnerPanel(Pane footer) {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        TitledPane prefixTitled = Views.titledPane(DefaultI18nContext.getInstance().i18n("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(Prefix.CURRENTPAGE);
        this.prefix.addMenuItemFor(Prefix.FILENUMBER);
        this.prefix.addMenuItemFor(Prefix.BOOKMARK);
        this.prefix.addMenuItemFor(Prefix.BOOKMARK_STRICT);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane(DefaultI18nContext.getInstance().i18n("Split settings"), (Node)this.splitOptions), Views.titledPane(DefaultI18nContext.getInstance().i18n("Output settings"), (Node)this.destinationPane), prefixTitled, footer});
        return pane;
    }

    @Override
    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @Override
    public RequiredPdfData[] requires() {
        return new RequiredPdfData[]{RequiredPdfData.DEFAULT, RequiredPdfData.BOOMARKS};
    }

    @Override
    public Node graphic() {
        return new ImageView("split_by_bookmarks.png");
    }

    @Configuration
    public static class ModuleConfig {
        @Bean(name={"split.bybookmarksfield"})
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Bean(name={"split.bybookmarkspane"})
        public PdfDestinationPane destinationPane(@Named(value="split.bybookmarksfield") BrowsableOutputDirectoryField outputField, UserContext userContext) {
            PdfDestinationPane panel = new PdfDestinationPane(outputField, SplitByBookmarksModule.MODULE_ID, userContext, PdfDestinationPane.DestinationPanelFields.DISCARD_BOOKMARKS);
            panel.enableSameAsSourceItem();
            return panel;
        }
    }
}

