/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.VBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.support.Style;

class DestinationPane
extends VBox {
    private CheckBox overwrite = new CheckBox(DefaultI18nContext.getInstance().i18n("Overwrite if already exists"));
    private BrowsableField destination;

    public DestinationPane(BrowsableField destination) {
        super(5.0);
        RequireUtils.requireNotNull(destination, "Destination field cannot be null");
        this.destination = destination;
        this.overwrite.setSelected(false);
        this.overwrite.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Tick the box if you want to overwrite the output files if they already exist.")));
        this.overwrite.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        destination.getStyleClass().addAll((Object[])Style.VITEM.css());
        this.getChildren().addAll((Object[])new Node[]{destination, this.overwrite});
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
    }

    protected CheckBox overwrite() {
        return this.overwrite;
    }

    protected BrowsableField destination() {
        return this.destination;
    }
}

