/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.io;

import java.io.File;
import java.io.IOException;
import org.sejda.model.exception.TaskIOException;

public final class IOUtils {
    private static final String BUFFER_NAME = "SejdaTmpBuffer";
    private static final int TEMP_DIR_ATTEMPTS = 1000;

    private IOUtils() {
    }

    public static File createTemporaryPdfBuffer() throws TaskIOException {
        return IOUtils.createTemporaryBuffer(".pdf");
    }

    public static File createTemporaryBuffer() throws TaskIOException {
        return IOUtils.createTemporaryBuffer(".tmp");
    }

    public static File createTemporaryBuffer(String extension) throws TaskIOException {
        try {
            File buffer = File.createTempFile(BUFFER_NAME, extension);
            buffer.deleteOnExit();
            return buffer;
        }
        catch (IOException e) {
            throw new TaskIOException("Unable to create temporary buffer", e);
        }
    }

    public static File createTemporaryFolder() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = "sejdaTmp" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 1000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 1000 attempts (tried " + baseName + "0 to " + baseName + 999 + ')');
    }
}

