/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PageImageWriter;
import org.sejda.impl.sambox.component.PageTextWriter;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.EditParameters;
import org.sejda.model.parameter.edit.AddImageOperation;
import org.sejda.model.parameter.edit.AddTextOperation;
import org.sejda.model.parameter.edit.DeletePageOperation;
import org.sejda.model.parameter.edit.InsertPageOperation;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditTask
extends BaseTask<EditParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(EditTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(EditParameters parameters) {
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(EditParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            this.stopTaskIfCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.documentHandler = source.open(this.documentLoader);
            this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.MODIFY);
            this.documentHandler.setCreatorOnPDDocument();
            File tmpFile = IOUtils.createTemporaryPdfBuffer();
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
            this.documentHandler.setCompress(parameters.isCompress());
            int[] pagesToDeleteSorted = parameters.getDeletePageOperations().stream().mapToInt(DeletePageOperation::getPageNumber).sorted().toArray();
            for (int i = pagesToDeleteSorted.length - 1; i >= 0; --i) {
                int pageNumber = pagesToDeleteSorted[i];
                LOG.debug("Deleting page {}", (Object)pageNumber);
                this.documentHandler.removePage(pageNumber);
            }
            for (InsertPageOperation insertPageOperation : parameters.getInsertPageOperations()) {
                int pageNumber = insertPageOperation.getPageNumber();
                if (pageNumber > 1) {
                    LOG.debug("Adding new page after page {}", (Object)(pageNumber - 1));
                    this.documentHandler.addBlankPageAfter(pageNumber - 1);
                    continue;
                }
                LOG.debug("Adding new page before page {}", (Object)pageNumber);
                this.documentHandler.addBlankPageBefore(pageNumber);
            }
            int totalPages = this.documentHandler.getNumberOfPages();
            for (AddTextOperation textOperation : parameters.getTextOperations()) {
                PageTextWriter textWriter = new PageTextWriter(this.documentHandler.getUnderlyingPDDocument());
                Set pageNumbers = textOperation.getPageRange().getPages(totalPages);
                Iterator iterator = pageNumbers.iterator();
                while (iterator.hasNext()) {
                    int pageNumber = (Integer)iterator.next();
                    PDPage page = this.documentHandler.getPage(pageNumber);
                    PDFont font = ObjectUtils.defaultIfNull(FontUtils.getStandardType1Font(textOperation.getFont()), PDType1Font.HELVETICA);
                    textWriter.write(page, textOperation.getPosition(), textOperation.getText(), font, textOperation.getFontSize(), textOperation.getColor());
                }
            }
            for (AddImageOperation imageOperation : parameters.getImageOperations()) {
                PageImageWriter imageWriter = new PageImageWriter(this.documentHandler.getUnderlyingPDDocument());
                PDImageXObject image = PageImageWriter.toPDXImageObject(imageOperation.getImageSource());
                Set pageNumbers = imageOperation.getPageRange().getPages(totalPages);
                Iterator iterator = pageNumbers.iterator();
                while (iterator.hasNext()) {
                    int pageNumber = (Integer)iterator.next();
                    PDPage page = this.documentHandler.getPage(pageNumber);
                    imageWriter.write(page, image, imageOperation.getPosition(), imageOperation.getWidth(), imageOperation.getHeight());
                }
            }
            this.documentHandler.savePDDocument(tmpFile);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

