/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.sejda.fonts.OptionalUnicodeType0Font;
import org.sejda.fonts.UnicodeType0Font;
import org.sejda.model.pdf.FontResource;
import org.sejda.model.pdf.StandardType1Font;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType0Font;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FontUtils.class);
    private static final Map<StandardType1Font, PDType1Font> STANDARD_TYPE1_FONTS;

    private FontUtils() {
    }

    public static PDType1Font getStandardType1Font(StandardType1Font st1Font) {
        return STANDARD_TYPE1_FONTS.get(st1Font);
    }

    public static PDFont fontOrFallback(String text, PDFont font, Supplier<PDFont> fallbackSupplier) {
        if (Objects.nonNull(fallbackSupplier) && !FontUtils.canDisplay(text, font)) {
            LOG.info("Text cannot be written with font {}, using fallback", (Object)font.getName());
            return fallbackSupplier.get();
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PDFont loadFont(PDDocument document, FontResource font) {
        InputStream in = font.getFontStream();
        try {
            PDType0Font loaded = PDType0Font.load(document, in);
            LOG.trace("Loaded font {}", (Object)loaded.getName());
            PDType0Font pDType0Font = loaded;
            return pDType0Font;
        }
        catch (IOException e) {
            LOG.warn("Failed to load font " + font, e);
            PDFont pDFont = null;
            return pDFont;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static final PDFont findFontFor(PDDocument document, String text) {
        try {
            Class.forName("org.sejda.fonts.UnicodeType0Font");
            PDFont found = FontUtils.findFontAmong(document, text, UnicodeType0Font.values());
            if (Objects.nonNull(found)) {
                return found;
            }
            Class.forName("org.sejda.fonts.OptionalUnicodeType0Font");
            return FontUtils.findFontAmong(document, text, (FontResource[])OptionalUnicodeType0Font.values());
        }
        catch (ClassNotFoundException clf) {
            LOG.warn("Fallback fonts not available");
            return null;
        }
    }

    private static PDFont findFontAmong(PDDocument document, String text, FontResource ... fonts) {
        for (FontResource font : fonts) {
            PDFont loaded = FontUtils.loadFont(document, font);
            if (!FontUtils.canDisplay(text, loaded)) continue;
            LOG.debug("Found suitable font {}", (Object)loaded.getName());
            return loaded;
        }
        return null;
    }

    public static boolean canDisplay(String text, PDFont font) {
        try {
            if (Objects.nonNull(font)) {
                font.encode(text);
                return true;
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
        return false;
    }

    static {
        HashMap<StandardType1Font, PDType1Font> fontsCache = new HashMap<StandardType1Font, PDType1Font>();
        fontsCache.put(StandardType1Font.CURIER, PDType1Font.COURIER);
        fontsCache.put(StandardType1Font.CURIER_BOLD, PDType1Font.COURIER_BOLD);
        fontsCache.put(StandardType1Font.CURIER_BOLD_OBLIQUE, PDType1Font.COURIER_BOLD_OBLIQUE);
        fontsCache.put(StandardType1Font.CURIER_OBLIQUE, PDType1Font.COURIER_OBLIQUE);
        fontsCache.put(StandardType1Font.HELVETICA, PDType1Font.HELVETICA);
        fontsCache.put(StandardType1Font.HELVETICA_BOLD, PDType1Font.HELVETICA_BOLD);
        fontsCache.put(StandardType1Font.HELVETICA_BOLD_OBLIQUE, PDType1Font.HELVETICA_BOLD_OBLIQUE);
        fontsCache.put(StandardType1Font.HELVETICA_OBLIQUE, PDType1Font.HELVETICA_OBLIQUE);
        fontsCache.put(StandardType1Font.SYMBOL, PDType1Font.SYMBOL);
        fontsCache.put(StandardType1Font.ZAPFDINGBATS, PDType1Font.ZAPF_DINGBATS);
        fontsCache.put(StandardType1Font.TIMES_BOLD, PDType1Font.TIMES_BOLD);
        fontsCache.put(StandardType1Font.TIMES_BOLD_ITALIC, PDType1Font.TIMES_BOLD_ITALIC);
        fontsCache.put(StandardType1Font.TIMES_ITALIC, PDType1Font.TIMES_ITALIC);
        fontsCache.put(StandardType1Font.TIMES_ROMAN, PDType1Font.TIMES_ROMAN);
        STANDARD_TYPE1_FONTS = Collections.unmodifiableMap(fontsCache);
    }
}

