/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.filter.FilterFactory;
import org.sejda.sambox.pdmodel.common.COSDictionaryMap;
import org.sejda.sambox.pdmodel.common.PDMetadata;
import org.sejda.sambox.pdmodel.common.filespecification.FileSpecifications;
import org.sejda.sambox.pdmodel.common.filespecification.PDFileSpecification;

public class PDStream
implements COSObjectable {
    private COSStream stream;

    public PDStream() {
        this.stream = new COSStream();
    }

    public PDStream(COSStream str) {
        this.stream = str;
    }

    public PDStream(InputStream input) throws IOException {
        this(input, (COSBase)null);
    }

    public PDStream(InputStream input, COSName filter) throws IOException {
        this(input, (COSBase)filter);
    }

    public PDStream(InputStream input, COSArray filters) throws IOException {
        this(input, (COSBase)filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDStream(InputStream input, COSBase filter) throws IOException {
        this.stream = new COSStream();
        try (OutputStream output = this.stream.createFilteredStream(filter);){
            IOUtils.copy(input, output);
        }
        finally {
            org.sejda.util.IOUtils.close(input);
        }
    }

    @Override
    public COSStream getCOSObject() {
        return this.stream;
    }

    public OutputStream createOutputStream() {
        return this.stream.createUnfilteredStream();
    }

    public OutputStream createOutputStream(COSName filter) {
        return this.stream.createFilteredStream(filter);
    }

    public InputStream createInputStream() throws IOException {
        return this.stream.getUnfilteredStream();
    }

    public InputStream createInputStream(List<String> stopFilters) throws IOException {
        InputStream is = this.stream.getFilteredStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        List<COSName> filters = this.getFilters();
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                COSName nextFilter = filters.get(i);
                if (stopFilters != null && stopFilters.contains(nextFilter.getName())) break;
                Filter filter = FilterFactory.INSTANCE.getFilter(nextFilter);
                filter.decode(is, os, this.stream, i);
                org.sejda.util.IOUtils.closeQuietly(is);
                is = new ByteArrayInputStream(os.toByteArray());
                os.reset();
            }
        }
        return is;
    }

    public int getLength() {
        return this.stream.getInt(COSName.LENGTH, 0);
    }

    public List<COSName> getFilters() {
        COSBase filters = this.stream.getFilters();
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            return new COSArrayList<COSName>(name, name, this.stream, COSName.FILTER);
        }
        if (filters instanceof COSArray) {
            return ((COSArray)filters).toList();
        }
        return null;
    }

    public void setFilters(List<COSName> filters) {
        COSArray obj = COSArrayList.converterToCOSArray(filters);
        this.stream.setItem(COSName.FILTER, (COSBase)obj);
    }

    public List<Object> getDecodeParms() throws IOException {
        COSArrayList<COSDictionaryMap<String, Object>> retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.DECODE_PARMS);
        if (dp == null) {
            dp = this.stream.getDictionaryObject(COSName.DP);
        }
        if (dp instanceof COSDictionary) {
            COSDictionaryMap<String, Object> map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList<COSDictionaryMap<String, Object>>(map, dp, this.stream, COSName.DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap<String, Object>> actuals = new ArrayList<COSDictionaryMap<String, Object>>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setDecodeParms(List<?> decodeParams) {
        this.stream.setItem(COSName.DECODE_PARMS, (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public PDFileSpecification getFile() {
        return FileSpecifications.fileSpecificationFor(this.stream.getDictionaryObject(COSName.F));
    }

    public void setFile(PDFileSpecification f) {
        this.stream.setItem(COSName.F, (COSObjectable)f);
    }

    public List<String> getFileFilters() {
        List<String> retval = null;
        COSBase filters = this.stream.getDictionaryObject(COSName.F_FILTER);
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList<String>(name.getName(), name, this.stream, COSName.F_FILTER);
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFileFilters(List<String> filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.stream.setItem(COSName.F_FILTER, (COSBase)obj);
    }

    public List<Object> getFileDecodeParams() throws IOException {
        COSArrayList<COSDictionaryMap<String, Object>> retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.F_DECODE_PARMS);
        if (dp instanceof COSDictionary) {
            COSDictionaryMap<String, Object> map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList<COSDictionaryMap<String, Object>>(map, dp, this.stream, COSName.F_DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap<String, Object>> actuals = new ArrayList<COSDictionaryMap<String, Object>>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setFileDecodeParams(List<?> decodeParams) {
        this.stream.setItem("FDecodeParams", (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try (InputStream is = this.createInputStream();){
            int amountRead;
            while ((amountRead = is.read(buf)) != -1) {
                output.write(buf, 0, amountRead);
            }
        }
        return output.toByteArray();
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSBase mdStream = this.stream.getDictionaryObject(COSName.METADATA);
        if (mdStream != null) {
            if (mdStream instanceof COSStream) {
                retval = new PDMetadata((COSStream)mdStream);
            } else if (!(mdStream instanceof COSNull)) {
                throw new IllegalStateException("Expected a COSStream but was a " + mdStream.getClass().getSimpleName());
            }
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.stream.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getDecodedStreamLength() {
        return this.stream.getInt(COSName.DL);
    }

    public void setDecodedStreamLength(int decodedStreamLength) {
        this.stream.setInt(COSName.DL, decodedStreamLength);
    }
}

