/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation;

import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceCMYK;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceRGB;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;

public class PDAppearanceCharacteristicsDictionary
implements COSObjectable {
    private final COSDictionary dictionary;

    public PDAppearanceCharacteristicsDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public int getRotation() {
        return this.getCOSObject().getInt(COSName.R, 0);
    }

    public void setRotation(int rotation) {
        this.getCOSObject().setInt(COSName.R, rotation);
    }

    public PDColor getBorderColour() {
        return this.getColor(COSName.BC);
    }

    public void setBorderColour(PDColor c) {
        this.getCOSObject().setItem(COSName.BC, (COSBase)c.toComponentsCOSArray());
    }

    public PDColor getBackground() {
        return this.getColor(COSName.BG);
    }

    public void setBackground(PDColor c) {
        this.getCOSObject().setItem(COSName.BG, (COSBase)c.toComponentsCOSArray());
    }

    public String getNormalCaption() {
        return this.getCOSObject().getString("CA");
    }

    public void setNormalCaption(String caption) {
        this.getCOSObject().setString("CA", caption);
    }

    public String getRolloverCaption() {
        return this.getCOSObject().getString("RC");
    }

    public void setRolloverCaption(String caption) {
        this.getCOSObject().setString("RC", caption);
    }

    public String getAlternateCaption() {
        return this.getCOSObject().getString("AC");
    }

    public void setAlternateCaption(String caption) {
        this.getCOSObject().setString("AC", caption);
    }

    public PDFormXObject getNormalIcon() {
        COSBase i = this.getCOSObject().getDictionaryObject("I");
        if (i instanceof COSStream) {
            return new PDFormXObject((COSStream)i);
        }
        return null;
    }

    public PDFormXObject getRolloverIcon() {
        COSBase i = this.getCOSObject().getDictionaryObject("RI");
        if (i instanceof COSStream) {
            return new PDFormXObject((COSStream)i);
        }
        return null;
    }

    public PDFormXObject getAlternateIcon() {
        COSBase i = this.getCOSObject().getDictionaryObject("IX");
        if (i instanceof COSStream) {
            return new PDFormXObject((COSStream)i);
        }
        return null;
    }

    private PDColor getColor(COSName itemName) {
        COSBase c = this.getCOSObject().getItem(itemName);
        if (c instanceof COSArray) {
            PDDeviceColorSpace colorSpace = null;
            switch (((COSArray)c).size()) {
                case 1: {
                    colorSpace = PDDeviceGray.INSTANCE;
                    break;
                }
                case 3: {
                    colorSpace = PDDeviceRGB.INSTANCE;
                    break;
                }
                case 4: {
                    colorSpace = PDDeviceCMYK.INSTANCE;
                    break;
                }
            }
            return new PDColor((COSArray)c, (PDColorSpace)colorSpace);
        }
        return null;
    }
}

