/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;

public final class ScriptStackElement
implements Serializable {
    static final long serialVersionUID = -6416688260860477449L;
    public final String fileName;
    public final String functionName;
    public final int lineNumber;

    public ScriptStackElement(String string, String string2, int n) {
        this.fileName = string;
        this.functionName = string2;
        this.lineNumber = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderMozillaStyle(stringBuilder);
        return stringBuilder.toString();
    }

    public void renderJavaStyle(StringBuilder stringBuilder) {
        stringBuilder.append("\tat ").append(this.fileName);
        if (this.lineNumber > -1) {
            stringBuilder.append(':').append(this.lineNumber);
        }
        if (this.functionName != null) {
            stringBuilder.append(" (").append(this.functionName).append(')');
        }
    }

    public void renderMozillaStyle(StringBuilder stringBuilder) {
        if (this.functionName != null) {
            stringBuilder.append(this.functionName).append("()");
        }
        stringBuilder.append('@').append(this.fileName);
        if (this.lineNumber > -1) {
            stringBuilder.append(':').append(this.lineNumber);
        }
    }

    public void renderV8Style(StringBuilder stringBuilder) {
        stringBuilder.append("    at ");
        if (this.functionName == null || "anonymous".equals(this.functionName) || "undefined".equals(this.functionName)) {
            this.appendV8Location(stringBuilder);
        } else {
            stringBuilder.append(this.functionName).append(" (");
            this.appendV8Location(stringBuilder);
            stringBuilder.append(')');
        }
    }

    private void appendV8Location(StringBuilder stringBuilder) {
        stringBuilder.append(this.fileName);
        if (this.lineNumber > -1) {
            stringBuilder.append(':').append(this.lineNumber);
        }
    }
}

