#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: semigroupoids
version: 5.1
id: semigroupoids-5.1-5jnCvjsOzwJ9gIFAA8m8gv
key: semigroupoids-5.1-5jnCvjsOzwJ9gIFAA8m8gv
license: BSD3
copyright: Copyright (C) 2011-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
synopsis: Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.
    .
    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.
    .
    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.
    .
    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
    .
    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
    .
    Ideally the following relationships would hold:
    .
    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >
    .
    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
    .
    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.
    .
    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
exposed: True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances
abi: 9c980d88b815545bcc60b949ce3dbaef
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/semigroupoids-5.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/semigroupoids-5.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/semigroupoids-5.1
hs-libraries: HSsemigroupoids-5.1-5jnCvjsOzwJ9gIFAA8m8gv
depends:
    base-4.9.0.0 base-orphans-0.5.4-5IQvrjd7gNP548VkOOyIq6
    bifunctors-5.3-DOlu5HrqdrmIgON0ZSxlNq
    comonad-5-Fqo2X68HwzQ5YCuLU8LFXN containers-0.5.7.1
    contravariant-1.4-KR4p8mcznnoInwULOlg5FR
    distributive-0.5.0.2-8lDT4wd8x255lSvuhyWdwG
    semigroups-0.18.1-ESRONlmV7qgKe0wL9ZoBKD
    tagged-0.8.4-9gtrXrOYlY5BIFTjUM7KTh transformers-0.5.2.0
    transformers-compat-0.5.1.4-81lZyuOJOvsD0zyCv2TKld
haddock-interfaces: /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock
haddock-html: /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
