/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import jnr.ffi.Runtime;
import jnr.posix.DefaultNativeTimeval;
import jnr.posix.Timeval;
import org.jruby.RubyThread;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.InterruptMode;
import org.jruby.truffle.core.fiber.FiberManager;
import org.jruby.truffle.core.fiber.FiberNodes;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.core.thread.ThreadNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.SafepointAction;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.ReturnException;
import org.jruby.truffle.language.control.ThreadExitException;

public class ThreadManager {
    private final RubyContext context;
    private final DynamicObject rootThread;
    private final ThreadLocal<DynamicObject> currentThread = new ThreadLocal();
    private final Set<DynamicObject> runningRubyThreads = Collections.newSetFromMap(new ConcurrentHashMap());

    public ThreadManager(RubyContext context) {
        this.context = context;
        this.rootThread = ThreadManager.createRubyThread(context, context.getCoreLibrary().getThreadClass());
    }

    public static DynamicObject createRubyThread(RubyContext context, DynamicObject rubyClass) {
        DynamicObject threadLocals = ThreadManager.createThreadLocals(context);
        DynamicObject object = Layouts.THREAD.createThread(Layouts.CLASS.getInstanceFactory(rubyClass), threadLocals, InterruptMode.IMMEDIATE, RubyThread.Status.RUN, new ArrayList<Lock>(), null, new CountDownLatch(1), ThreadManager.getGlobalAbortOnException(context), null, null, null, new AtomicBoolean(false), 0);
        Layouts.THREAD.setFiberManagerUnsafe(object, new FiberManager(context, object));
        return object;
    }

    public static boolean getGlobalAbortOnException(RubyContext context) {
        DynamicObject threadClass = context.getCoreLibrary().getThreadClass();
        return (Boolean)threadClass.get("@abort_on_exception");
    }

    private static DynamicObject createThreadLocals(RubyContext context) {
        DynamicObjectFactory instanceFactory = Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getObjectClass());
        DynamicObject threadLocals = Layouts.BASIC_OBJECT.createBasicObject(instanceFactory);
        threadLocals.define("$!", context.getCoreLibrary().getNilObject(), 0);
        threadLocals.define("$~", context.getCoreLibrary().getNilObject(), 0);
        threadLocals.define("$?", context.getCoreLibrary().getNilObject(), 0);
        return threadLocals;
    }

    public static void initialize(final DynamicObject thread, RubyContext context, Node currentNode, final Object[] arguments, final DynamicObject block) {
        String info = Layouts.PROC.getSharedMethodInfo(block).getSourceSection().getShortDescription();
        ThreadManager.initialize(thread, context, currentNode, info, new Runnable(){

            @Override
            public void run() {
                Object value = ProcOperations.rootCall(block, arguments);
                Layouts.THREAD.setValue(thread, value);
            }
        });
    }

    public static void initialize(final DynamicObject thread, final RubyContext context, final Node currentNode, final String info, final Runnable task) {
        assert (RubyGuards.isRubyThread(thread));
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadManager.run(thread, context, currentNode, info, task);
            }
        }).start();
        FiberNodes.waitForInitialization(context, Layouts.THREAD.getFiberManager(thread).getRootFiber(), currentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(DynamicObject thread, RubyContext context, Node currentNode, String info, Runnable task) {
        assert (RubyGuards.isRubyThread(thread));
        String name = "Ruby Thread@" + info;
        Thread.currentThread().setName(name);
        DynamicObject fiber = Layouts.THREAD.getFiberManager(thread).getRootFiber();
        ThreadManager.start(context, thread);
        FiberNodes.start(context, fiber);
        try {
            task.run();
        }
        catch (ThreadExitException e) {
            Layouts.THREAD.setValue(thread, context.getCoreLibrary().getNilObject());
            return;
        }
        catch (RaiseException e) {
            ThreadManager.setException(context, thread, e.getException(), currentNode);
        }
        catch (ReturnException e) {
            ThreadManager.setException(context, thread, context.getCoreExceptions().unexpectedReturn(currentNode), currentNode);
        }
        finally {
            FiberNodes.cleanup(context, fiber);
            ThreadManager.cleanup(context, thread);
        }
    }

    private static void setException(RubyContext context, DynamicObject thread, DynamicObject exception, Node currentNode) {
        boolean isSystemExit;
        DynamicObject mainThread = context.getThreadManager().getRootThread();
        boolean bl = isSystemExit = Layouts.BASIC_OBJECT.getLogicalClass(exception) == context.getCoreLibrary().getSystemExitClass();
        if (thread != mainThread && (isSystemExit || Layouts.THREAD.getAbortOnException(thread))) {
            ThreadNodes.ThreadRaisePrimitiveNode.raiseInThread(context, mainThread, exception, currentNode);
        }
        Layouts.THREAD.setException(thread, exception);
    }

    public static void start(RubyContext context, DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        Layouts.THREAD.setThread(thread, Thread.currentThread());
        context.getThreadManager().registerThread(thread);
    }

    public static void cleanup(RubyContext context, DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        Layouts.THREAD.setStatus(thread, RubyThread.Status.ABORTING);
        context.getThreadManager().unregisterThread(thread);
        Layouts.THREAD.setStatus(thread, RubyThread.Status.DEAD);
        Layouts.THREAD.setThread(thread, null);
        assert (RubyGuards.isRubyThread(thread));
        for (Lock lock : Layouts.THREAD.getOwnedLocks(thread)) {
            lock.unlock();
        }
        Layouts.THREAD.getFinishedLatch(thread).countDown();
    }

    public static void shutdown(RubyContext context, DynamicObject thread, Node currentNode) {
        assert (RubyGuards.isRubyThread(thread));
        Layouts.THREAD.getFiberManager(thread).shutdown();
        if (thread == context.getThreadManager().getRootThread()) {
            throw new RaiseException(context.getCoreExceptions().systemExit(0, currentNode));
        }
        throw new ThreadExitException();
    }

    public void initialize() {
        ThreadManager.start(this.context, this.rootThread);
        FiberNodes.start(this.context, Layouts.THREAD.getFiberManager(this.rootThread).getRootFiber());
    }

    public DynamicObject getRootThread() {
        return this.rootThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilResult(Node currentNode, BlockingAction<T> action) {
        T result = null;
        do {
            DynamicObject runningThread = this.getCurrentThread();
            Layouts.THREAD.setStatus(runningThread, RubyThread.Status.SLEEP);
            try {
                try {
                    result = action.block();
                }
                finally {
                    Layouts.THREAD.setStatus(runningThread, RubyThread.Status.RUN);
                }
            }
            catch (InterruptedException e) {
                this.context.getSafepointManager().pollFromBlockingCall(currentNode);
            }
        } while (result == null);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilSuccessKeepRunStatus(Node currentNode, BlockingAction<T> action) {
        T result = null;
        do {
            try {
                result = action.block();
            }
            catch (InterruptedException e) {
                this.context.getSafepointManager().poll(currentNode);
            }
        } while (result == null);
        return result;
    }

    public <T> ResultOrTimeout<T> runUntilTimeout(Node currentNode, int timeoutMicros, final BlockingTimeoutAction<T> action) {
        DefaultNativeTimeval timeoutToUse = new DefaultNativeTimeval(Runtime.getSystemRuntime());
        if (timeoutMicros == 0) {
            timeoutToUse.setTime(new long[]{0L, 0L});
            return new ResultWithinTime<T>(this.runUntilResult(currentNode, new BlockingAction<T>((Timeval)timeoutToUse){
                final /* synthetic */ Timeval val$timeoutToUse;
                {
                    this.val$timeoutToUse = timeval;
                }

                @Override
                public T block() throws InterruptedException {
                    return action.block(this.val$timeoutToUse);
                }
            }));
        }
        int pollTime = 500000000;
        final long requestedTimeoutAt = System.nanoTime() + (long)timeoutMicros * 1000L;
        return (ResultOrTimeout)this.runUntilResult(currentNode, new BlockingAction<ResultOrTimeout<T>>((Timeval)timeoutToUse, action){
            final /* synthetic */ Timeval val$timeoutToUse;
            final /* synthetic */ BlockingTimeoutAction val$action;
            {
                this.val$timeoutToUse = timeval;
                this.val$action = blockingTimeoutAction;
            }

            @Override
            public ResultOrTimeout<T> block() throws InterruptedException {
                long timeUntilRequestedTimeout = requestedTimeoutAt - System.nanoTime();
                if (timeUntilRequestedTimeout <= 0L) {
                    return new TimedOut();
                }
                boolean timeoutForPoll = 500000000L <= timeUntilRequestedTimeout;
                long effectiveTimeout = Math.min(500000000L, timeUntilRequestedTimeout);
                long effectiveTimeoutMicros = effectiveTimeout / 1000L;
                this.val$timeoutToUse.setTime(new long[]{effectiveTimeoutMicros / 1000000L, effectiveTimeoutMicros % 1000000L});
                Object result = this.val$action.block(this.val$timeoutToUse);
                if (result == null) {
                    if (timeoutForPoll && requestedTimeoutAt - System.nanoTime() > 0L) {
                        throw new InterruptedException();
                    }
                    return new TimedOut();
                }
                return new ResultWithinTime(result);
            }
        });
    }

    public void initializeCurrentThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.currentThread.set(thread);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getCurrentThread() {
        return this.currentThread.get();
    }

    public synchronized void registerThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.initializeCurrentThread(thread);
        this.runningRubyThreads.add(thread);
    }

    public synchronized void unregisterThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.runningRubyThreads.remove(thread);
        this.currentThread.set(null);
    }

    @CompilerDirectives.TruffleBoundary
    public void shutdown() {
        try {
            if (this.runningRubyThreads.size() > 1) {
                this.killOtherThreads();
            }
        }
        finally {
            Layouts.THREAD.getFiberManager(this.rootThread).shutdown();
            FiberNodes.cleanup(this.context, Layouts.THREAD.getFiberManager(this.rootThread).getRootFiber());
            ThreadManager.cleanup(this.context, this.rootThread);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] getThreadList() {
        return this.runningRubyThreads.toArray(new Object[this.runningRubyThreads.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    private void killOtherThreads() {
        while (true) {
            try {
                this.context.getSafepointManager().pauseAllThreadsAndExecute(null, false, new SafepointAction(){

                    @Override
                    public synchronized void run(DynamicObject thread, Node currentNode) {
                        if (thread != ThreadManager.this.rootThread && Thread.currentThread() == Layouts.THREAD.getThread(thread)) {
                            ThreadManager.shutdown(ThreadManager.this.context, thread, currentNode);
                        }
                    }
                });
            }
            catch (RaiseException e) {
                DynamicObject rubyException = e.getException();
                BacktraceFormatter.createDefaultFormatter(this.context).printBacktrace(this.context, rubyException, Layouts.EXCEPTION.getBacktrace(rubyException));
                continue;
            }
            break;
        }
    }

    public static class TimedOut<T>
    implements ResultOrTimeout<T> {
    }

    public static class ResultWithinTime<T>
    implements ResultOrTimeout<T> {
        private final T value;

        public ResultWithinTime(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static interface ResultOrTimeout<T> {
    }

    public static interface BlockingTimeoutAction<T> {
        public T block(Timeval var1) throws InterruptedException;
    }

    public static interface BlockingAction<T> {
        public static final boolean SUCCESS = true;

        public T block() throws InterruptedException;
    }
}

