/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Platform;
import com.sun.glass.ui.delegate.ClipboardDelegate;
import com.sun.glass.ui.delegate.MenuBarDelegate;
import com.sun.glass.ui.delegate.MenuDelegate;
import com.sun.glass.ui.delegate.MenuItemDelegate;

public abstract class PlatformFactory {
    private static PlatformFactory instance;

    public static PlatformFactory getPlatformFactory() {
        if (instance == null) {
            try {
                String platform = Platform.DeterminePlatform();
                String factory = "com.sun.glass.ui." + platform.toLowerCase() + "." + platform + "PlatformFactory";
                Class<?> c = Class.forName(factory);
                if (c == null) {
                    System.out.println("Failed to load factory");
                    return null;
                }
                instance = (PlatformFactory)c.newInstance();
            }
            catch (Exception e) {
                System.out.println("Failed to load Glass factory class");
            }
        }
        return instance;
    }

    public abstract Application createApplication();

    public abstract MenuBarDelegate createMenuBarDelegate(MenuBar var1);

    public abstract MenuDelegate createMenuDelegate(Menu var1);

    public abstract MenuItemDelegate createMenuItemDelegate(MenuItem var1);

    public abstract ClipboardDelegate createClipboardDelegate();
}

