/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.Date;
import org.netbeans.core.UIExceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClassEditor
extends PropertyEditorSupport {
    @Override
    public String getJavaInitializationString() {
        Class clazz = (Class)this.getValue();
        if (clazz == null) {
            return "null";
        }
        return "Class.forName (\"" + clazz.getName() + "\")";
    }

    @Override
    public String getAsText() {
        Class clazz = (Class)this.getValue();
        if (clazz == null) {
            return "null";
        }
        return clazz.getName();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            this.setValue(classLoader.loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(classNotFoundException.getMessage());
            String string2 = MessageFormat.format(NbBundle.getMessage(ClassEditor.class, (String)"FMT_EXC_CANT_LOAD_CLASS"), string);
            UIExceptions.annotateUser(illegalArgumentException, classNotFoundException.getMessage(), string2, classNotFoundException, new Date());
            throw illegalArgumentException;
        }
    }
}

