/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.authentication.ContextAuthenticationPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.model.Context;

public class PopupFlagLoggedInIndicatorMenu
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 3236789106409466394L;
    private String selectedText = null;
    private int contextId;

    public PopupFlagLoggedInIndicatorMenu(Context context) {
        this.contextId = context.getIndex();
        this.setText(MessageFormat.format(Constant.messages.getString("authentication.popup.indicator.loggedIn"), context.getName()));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupFlagLoggedInIndicatorMenu.this.performAction();
            }
        });
    }

    public void performAction() {
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
        Context context = sessionDialog.getUISharedContext(this.contextId);
        context.getAuthenticationMethod().setLoggedInIndicatorPattern(Pattern.quote(this.getSelectedText()));
        View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.contextId), false);
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.flag.popup");
    }

    @Override
    public int getParentMenuIndex() {
        return 1;
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        if (component instanceof JTextComponent) {
            boolean bl;
            JTextComponent jTextComponent = (JTextComponent)component;
            boolean bl2 = bl = SwingUtilities.getAncestorOfClass(HttpPanelResponse.class, jTextComponent) != null;
            if (!bl) {
                this.selectedText = null;
                return false;
            }
            this.selectedText = jTextComponent.getSelectedText();
            if (this.selectedText == null || this.selectedText.length() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return true;
        }
        this.selectedText = null;
        return false;
    }

    public String getSelectedText() {
        return this.selectedText;
    }
}

