/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginModuleRegistry
implements PluginModuleRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginModuleRegistry.class);
    private final ModuleRegistry moduleRegistry;

    public DefaultPluginModuleRegistry(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public Set<Module> getPluginModules() {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        Properties properties = this.loadPluginProperties();
        for (String pluginModule : properties.getProperty("plugins").split(",")) {
            try {
                modules.add(this.moduleRegistry.getModule(pluginModule));
            }
            catch (UnknownModuleException e) {
                LOGGER.debug("Cannot find module for plugin {}. Ignoring.", (Object)pluginModule);
            }
        }
        return modules;
    }

    private Properties loadPluginProperties() {
        return GUtil.loadProperties((URL)this.getClass().getResource("/gradle-plugins.properties"));
    }
}

