/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.shape.Mesh;
import org.jmol.shapesurface.Isosurface;

public class Pmesh
extends Isosurface {
    @Override
    public void initShape() {
        super.initShape();
        this.myType = "pmesh";
    }

    @Override
    public Object getProperty(String property, int index) {
        if (property == "face") {
            Mesh m = this.currentMesh;
            if (index >= 0 && (index >= this.meshCount || (m = this.meshes[index]) == null)) {
                return null;
            }
            return m == null ? null : this.getFace(m);
        }
        return this.getPropI(property, index);
    }

    private P3[] getFace(Mesh m) {
        int[] edge;
        int n;
        int v0;
        Object face;
        if (m.haveQuads) {
            return null;
        }
        T3[] vs = m.vs;
        Hashtable<String, int[]> htEdges = new Hashtable<String, int[]>();
        boolean bl = false;
        int n2 = 0;
        int i = m.pc;
        while (--i >= 0) {
            if (m.bsSlabDisplay != null && !m.bsSlabDisplay.get(i)) continue;
            face = m.pis[i];
            int mask = face[3];
            for (int j = 0; j < 3; ++j) {
                if ((mask & 1 << j) == 0) continue;
                Object object = face[j];
                Object v2 = face[(j + 1) % 3];
                String key = (int)v2 + "_" + (int)object;
                if (htEdges.containsKey(key)) {
                    htEdges.remove(key);
                    --n2;
                    continue;
                }
                ++n2;
                htEdges.put((int)object + "_" + (int)v2, new int[]{(int)object, (int)v2});
                htEdges.put("" + (int)object, new int[]{(int)object, (int)v2});
            }
        }
        if (n2 == 0) {
            return null;
        }
        int[][] a = new int[n2][2];
        face = htEdges.keySet().iterator();
        if (face.hasNext()) {
            String e = (String)face.next();
            a[0] = (int[])htEdges.get(e);
        }
        V3 vectorBA = new V3();
        V3 vectorBC = new V3();
        int v01 = v0 = a[0][0];
        int n3 = a[0][1];
        int pt = 0;
        while (n != v0 && (edge = (int[])htEdges.get("" + n)) != null) {
            float angle = Measure.computeAngle(vs[v01], vs[n], vs[edge[1]], vectorBA, vectorBC, true);
            n = edge[1];
            if (angle < 179.0f) {
                a[++pt] = edge;
                v01 = edge[0];
                continue;
            }
            a[pt][1] = n;
        }
        if (Measure.computeAngle(vs[v01], vs[n], vs[a[0][1]], vectorBA, vectorBC, true) >= 179.0f) {
            a[0][0] = a[pt--][0];
        }
        n2 = ++pt;
        P3[] pts = new P3[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            pts[i2] = P3.newP(vs[a[i2][0]]);
        }
        return pts;
    }
}

