/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import javajs.util.Lst;
import org.jmol.api.JmolScriptManager;
import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class ScriptQueueThread
extends JmolThread {
    private JmolScriptManager scriptManager;
    private boolean startedByCommandThread = false;
    private int pt;

    public ScriptQueueThread(JmolScriptManager scriptManager, Viewer vwr, boolean startedByCommandThread, int pt) {
        this.setViewer(vwr, "QueueThread" + pt);
        this.scriptManager = scriptManager;
        this.vwr = vwr;
        this.startedByCommandThread = startedByCommandThread;
        this.pt = pt;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        block5: while (true) {
            switch (mode) {
                case -1: {
                    mode = 0;
                    break;
                }
                case 0: {
                    if (this.stopped || this.scriptManager.getScriptQueue().size() == 0) {
                        mode = -2;
                        break;
                    }
                    if (this.runNextScript() || this.runSleep(100, 0)) continue block5;
                    return;
                }
                case -2: {
                    this.scriptManager.queueThreadFinished(this.pt);
                    return;
                }
            }
        }
    }

    private boolean runNextScript() {
        Lst<Lst<Object>> queue = this.scriptManager.getScriptQueue();
        if (queue.size() == 0) {
            return false;
        }
        Lst<Object> scriptItem = this.scriptManager.getScriptItem(false, this.startedByCommandThread);
        if (scriptItem == null) {
            return false;
        }
        String script = (String)scriptItem.get(0);
        String statusList = (String)scriptItem.get(1);
        String returnType = (String)scriptItem.get(2);
        boolean isQuiet = (Boolean)scriptItem.get(3);
        if (Logger.debugging) {
            Logger.debug("Queue[" + this.pt + "][" + queue.size() + "] scripts; running: " + script);
        }
        queue.remove(0);
        this.vwr.evalStringWaitStatusQueued(returnType, script, statusList, isQuiet, true);
        return queue.size() != 0;
    }
}

