/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.UIManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class MultiSplitLayout
implements LayoutManager {
    private final Map<String, Component> childMap = new HashMap<String, Component>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Node model;
    private int dividerSize;
    private boolean floatingDividers = true;

    public MultiSplitLayout() {
        this(new Leaf("default"));
    }

    public MultiSplitLayout(Node node) {
        this.model = node;
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        if (this.dividerSize == 0) {
            this.dividerSize = 7;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private void firePCS(String string, Object object, Object object2) {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.pcs.firePropertyChange(string, object, object2);
        }
    }

    public Node getModel() {
        return this.model;
    }

    public void setModel(Node node) {
        if (node == null || node instanceof Divider) {
            throw new IllegalArgumentException("invalid model");
        }
        Node node2 = node;
        this.model = node;
        this.firePCS("model", node2, node);
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid dividerSize");
        }
        int n2 = this.dividerSize;
        this.dividerSize = n;
        this.firePCS("dividerSize", n2, n);
    }

    public boolean getFloatingDividers() {
        return this.floatingDividers;
    }

    public void setFloatingDividers(boolean bl) {
        boolean bl2 = this.floatingDividers;
        this.floatingDividers = bl;
        this.firePCS("floatingDividers", bl2, bl);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            throw new IllegalArgumentException("name not specified");
        }
        this.childMap.put(string, component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        String string = component.getName();
        if (string != null) {
            this.childMap.remove(string);
        }
    }

    private Component childForNode(Node node) {
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            String string = leaf.getName();
            return string != null ? this.childMap.get(string) : null;
        }
        return null;
    }

    private Dimension preferredComponentSize(Node node) {
        Component component = this.childForNode(node);
        return component != null ? component.getPreferredSize() : new Dimension(0, 0);
    }

    private Dimension preferredNodeSize(Node node) {
        if (node instanceof Leaf) {
            return this.preferredComponentSize(node);
        }
        if (node instanceof Divider) {
            int n = this.getDividerSize();
            return new Dimension(n, n);
        }
        Split split = (Split)node;
        List<Node> list = split.getChildren();
        int n = 0;
        int n2 = 0;
        if (split.isRowLayout()) {
            for (Node node2 : list) {
                Dimension dimension = this.preferredNodeSize(node2);
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
        } else {
            for (Node node3 : list) {
                Dimension dimension = this.preferredNodeSize(node3);
                n = Math.max(n, dimension.width);
                n2 += dimension.height;
            }
        }
        return new Dimension(n, n2);
    }

    private Dimension minimumNodeSize(Node node) {
        if (node instanceof Leaf) {
            Component component = this.childForNode(node);
            return component != null ? component.getMinimumSize() : new Dimension(0, 0);
        }
        if (node instanceof Divider) {
            int n = this.getDividerSize();
            return new Dimension(n, n);
        }
        Split split = (Split)node;
        List<Node> list = split.getChildren();
        int n = 0;
        int n2 = 0;
        if (split.isRowLayout()) {
            for (Node node2 : list) {
                Dimension dimension = this.minimumNodeSize(node2);
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
        } else {
            for (Node node3 : list) {
                Dimension dimension = this.minimumNodeSize(node3);
                n = Math.max(n, dimension.width);
                n2 += dimension.height;
            }
        }
        return new Dimension(n, n2);
    }

    private static Dimension sizeWithInsets(Container container, Dimension dimension) {
        Insets insets = container.getInsets();
        int n = dimension.width + insets.left + insets.right;
        int n2 = dimension.height + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.preferredNodeSize(this.getModel());
        return MultiSplitLayout.sizeWithInsets(container, dimension);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.minimumNodeSize(this.getModel());
        return MultiSplitLayout.sizeWithInsets(container, dimension);
    }

    private static Rectangle boundsWithYandHeight(Rectangle rectangle, double d, double d2) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setBounds((int)rectangle.getX(), (int)d, (int)rectangle.getWidth(), (int)d2);
        return rectangle2;
    }

    private static Rectangle boundsWithXandWidth(Rectangle rectangle, double d, double d2) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setBounds((int)d, (int)rectangle.getY(), (int)d2, (int)rectangle.getHeight());
        return rectangle2;
    }

    private static void minimizeSplitBounds(Split split, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 0, 0);
        List<Node> list = split.getChildren();
        Node node = list.get(list.size() - 1);
        Rectangle rectangle3 = node.getBounds();
        if (split.isRowLayout()) {
            int n = rectangle3.x + rectangle3.width;
            rectangle2.add(n, rectangle.y + rectangle.height);
        } else {
            int n = rectangle3.y + rectangle3.height;
            rectangle2.add(rectangle.x + rectangle.width, n);
        }
        split.setBounds(rectangle2);
    }

    private void layoutShrink(Split split, Rectangle rectangle) {
        Rectangle rectangle2 = split.getBounds();
        ListIterator<Node> listIterator = split.getChildren().listIterator();
        if (split.isRowLayout()) {
            boolean bl;
            double d;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (Node node : split.getChildren()) {
                int n4 = node.getBounds().width;
                int n5 = Math.min(n4, this.minimumNodeSize((Node)node).width);
                n += n4;
                if (!(node.getWeight() > 0.0)) continue;
                n2 += n5;
                n3 += n4;
            }
            double d2 = rectangle.getX();
            double d3 = d = rectangle2.getWidth() - rectangle.getWidth();
            boolean bl2 = bl = (double)(n3 - n2) > d;
            while (listIterator.hasNext()) {
                Rectangle rectangle3;
                double d4;
                double d5;
                Node node = listIterator.next();
                Rectangle rectangle4 = node.getBounds();
                double d6 = this.minimumNodeSize(node).getWidth();
                double d7 = d5 = bl ? node.getWeight() : rectangle4.getWidth() / (double)n;
                if (!listIterator.hasNext()) {
                    d4 = Math.max(d6, rectangle.getMaxX() - d2);
                    rectangle3 = MultiSplitLayout.boundsWithXandWidth(rectangle, d2, d4);
                    this.layout2(node, rectangle3);
                } else if (d3 > 0.0 && d5 > 0.0) {
                    d4 = Math.rint(d5 * d);
                    double d8 = rectangle4.getWidth();
                    double d9 = Math.max(d6, d8 - d4);
                    Rectangle rectangle5 = MultiSplitLayout.boundsWithXandWidth(rectangle, d2, d9);
                    this.layout2(node, rectangle5);
                    d3 -= d8 - node.getBounds().getWidth();
                } else {
                    d4 = rectangle4.getWidth();
                    rectangle3 = MultiSplitLayout.boundsWithXandWidth(rectangle, d2, d4);
                    this.layout2(node, rectangle3);
                }
                d2 = node.getBounds().getMaxX();
            }
        } else {
            boolean bl;
            double d;
            int n = 0;
            int n6 = 0;
            int n7 = 0;
            for (Node node : split.getChildren()) {
                int n8 = node.getBounds().height;
                int n9 = Math.min(n8, this.minimumNodeSize((Node)node).height);
                n += n8;
                if (!(node.getWeight() > 0.0)) continue;
                n6 += n9;
                n7 += n8;
            }
            double d10 = rectangle.getY();
            double d11 = d = rectangle2.getHeight() - rectangle.getHeight();
            boolean bl3 = bl = (double)(n7 - n6) > d;
            while (listIterator.hasNext()) {
                double d12;
                double d13;
                Node node = listIterator.next();
                Rectangle rectangle6 = node.getBounds();
                double d14 = this.minimumNodeSize(node).getHeight();
                double d15 = d13 = bl ? node.getWeight() : rectangle6.getHeight() / (double)n;
                if (!listIterator.hasNext()) {
                    d12 = rectangle6.getHeight();
                    double d16 = Math.max(d14, rectangle.getMaxY() - d10);
                    Rectangle rectangle7 = MultiSplitLayout.boundsWithYandHeight(rectangle, d10, d16);
                    this.layout2(node, rectangle7);
                    d11 -= d12 - node.getBounds().getHeight();
                } else if (d11 > 0.0 && d13 > 0.0) {
                    d12 = Math.rint(d13 * d);
                    double d17 = rectangle6.getHeight();
                    double d18 = Math.max(d14, d17 - d12);
                    Rectangle rectangle8 = MultiSplitLayout.boundsWithYandHeight(rectangle, d10, d18);
                    this.layout2(node, rectangle8);
                    d11 -= d17 - node.getBounds().getHeight();
                } else {
                    d12 = rectangle6.getHeight();
                    Rectangle rectangle9 = MultiSplitLayout.boundsWithYandHeight(rectangle, d10, d12);
                    this.layout2(node, rectangle9);
                }
                d10 = node.getBounds().getMaxY();
            }
        }
        MultiSplitLayout.minimizeSplitBounds(split, rectangle);
    }

    private void layoutGrow(Split split, Rectangle rectangle) {
        Rectangle rectangle2 = split.getBounds();
        ListIterator<Node> listIterator = split.getChildren().listIterator();
        Node node = split.lastWeightedChild();
        if (split.isRowLayout()) {
            double d;
            double d2 = rectangle.getX();
            double d3 = d = rectangle.getWidth() - rectangle2.getWidth();
            while (listIterator.hasNext()) {
                Rectangle rectangle3;
                double d4;
                Node node2 = listIterator.next();
                Rectangle rectangle4 = node2.getBounds();
                double d5 = node2.getWeight();
                if (!listIterator.hasNext()) {
                    d4 = rectangle.getMaxX() - d2;
                    rectangle3 = MultiSplitLayout.boundsWithXandWidth(rectangle, d2, d4);
                    this.layout2(node2, rectangle3);
                } else if (d3 > 0.0 && d5 > 0.0) {
                    d4 = node2.equals(node) ? d3 : Math.rint(d5 * d);
                    double d6 = rectangle4.getWidth() + d4;
                    Rectangle rectangle5 = MultiSplitLayout.boundsWithXandWidth(rectangle, d2, d6);
                    this.layout2(node2, rectangle5);
                    d3 -= d4;
                } else {
                    d4 = rectangle4.getWidth();
                    rectangle3 = MultiSplitLayout.boundsWithXandWidth(rectangle, d2, d4);
                    this.layout2(node2, rectangle3);
                }
                d2 = node2.getBounds().getMaxX();
            }
        } else {
            double d;
            double d7 = rectangle.getY();
            double d8 = d = rectangle.getMaxY() - rectangle2.getHeight();
            while (listIterator.hasNext()) {
                double d9;
                Node node3 = listIterator.next();
                Rectangle rectangle6 = node3.getBounds();
                double d10 = node3.getWeight();
                if (!listIterator.hasNext()) {
                    d9 = rectangle.getMaxY() - d7;
                    Rectangle rectangle7 = MultiSplitLayout.boundsWithYandHeight(rectangle, d7, d9);
                    this.layout2(node3, rectangle7);
                } else if (d8 > 0.0 && d10 > 0.0) {
                    d9 = node3.equals(node) ? d8 : Math.rint(d10 * d);
                    double d11 = rectangle6.getHeight() + d9;
                    Rectangle rectangle8 = MultiSplitLayout.boundsWithYandHeight(rectangle, d7, d11);
                    this.layout2(node3, rectangle8);
                    d8 -= d9;
                } else {
                    d9 = rectangle6.getHeight();
                    Rectangle rectangle9 = MultiSplitLayout.boundsWithYandHeight(rectangle, d7, d9);
                    this.layout2(node3, rectangle9);
                }
                d7 = node3.getBounds().getMaxY();
            }
        }
    }

    private void layout2(Node node, Rectangle rectangle) {
        if (node instanceof Leaf) {
            Component component = this.childForNode(node);
            if (component != null) {
                component.setBounds(rectangle);
            }
            node.setBounds(rectangle);
        } else if (node instanceof Divider) {
            node.setBounds(rectangle);
        } else if (node instanceof Split) {
            boolean bl;
            Split split = (Split)node;
            boolean bl2 = split.isRowLayout() ? split.getBounds().width <= rectangle.width : (bl = split.getBounds().height <= rectangle.height);
            if (bl) {
                this.layoutGrow(split, rectangle);
                node.setBounds(rectangle);
            } else {
                this.layoutShrink(split, rectangle);
            }
        }
    }

    private void layout1(Node node, Rectangle rectangle) {
        if (node instanceof Leaf) {
            node.setBounds(rectangle);
        } else if (node instanceof Split) {
            Split split = (Split)node;
            Iterator<Node> iterator = split.getChildren().iterator();
            int n = this.getDividerSize();
            if (split.isRowLayout()) {
                double d = rectangle.getX();
                while (iterator.hasNext()) {
                    Divider divider;
                    Node node2 = iterator.next();
                    Divider divider2 = divider = iterator.hasNext() ? (Divider)iterator.next() : null;
                    double d2 = this.getFloatingDividers() ? this.preferredNodeSize(node2).getWidth() : (divider != null ? divider.getBounds().getX() - d : split.getBounds().getMaxX() - d);
                    Rectangle rectangle2 = MultiSplitLayout.boundsWithXandWidth(rectangle, d, d2);
                    this.layout1(node2, rectangle2);
                    if (this.getFloatingDividers() && divider != null) {
                        double d3 = rectangle2.getMaxX();
                        Rectangle rectangle3 = MultiSplitLayout.boundsWithXandWidth(rectangle, d3, n);
                        divider.setBounds(rectangle3);
                    }
                    if (divider == null) continue;
                    d = divider.getBounds().getMaxX();
                }
            } else {
                double d = rectangle.getY();
                while (iterator.hasNext()) {
                    Divider divider;
                    Node node3 = iterator.next();
                    Divider divider3 = divider = iterator.hasNext() ? (Divider)iterator.next() : null;
                    double d4 = this.getFloatingDividers() ? this.preferredNodeSize(node3).getHeight() : (divider != null ? divider.getBounds().getY() - d : split.getBounds().getMaxY() - d);
                    Rectangle rectangle4 = MultiSplitLayout.boundsWithYandHeight(rectangle, d, d4);
                    this.layout1(node3, rectangle4);
                    if (this.getFloatingDividers() && divider != null) {
                        double d5 = rectangle4.getMaxY();
                        Rectangle rectangle5 = MultiSplitLayout.boundsWithYandHeight(rectangle, d5, n);
                        divider.setBounds(rectangle5);
                    }
                    if (divider == null) continue;
                    d = divider.getBounds().getMaxY();
                }
            }
            MultiSplitLayout.minimizeSplitBounds(split, rectangle);
        }
    }

    private static void throwInvalidLayout(String string, Node node) {
        throw new InvalidLayoutException(string, node);
    }

    private static void checkLayout(Node node) {
        if (node instanceof Split) {
            Split split = (Split)node;
            if (split.getChildren().size() <= 2) {
                MultiSplitLayout.throwInvalidLayout("Split must have > 2 children", node);
            }
            Iterator<Node> iterator = split.getChildren().iterator();
            double d = 0.0;
            while (iterator.hasNext()) {
                Node node2;
                Node node3 = iterator.next();
                if (node3 instanceof Divider) {
                    MultiSplitLayout.throwInvalidLayout("expected a Split or Leaf Node", node3);
                }
                if (iterator.hasNext() && !((node2 = iterator.next()) instanceof Divider)) {
                    MultiSplitLayout.throwInvalidLayout("expected a Divider Node", node2);
                }
                d += node3.getWeight();
                MultiSplitLayout.checkLayout(node3);
            }
            if (d > 1.000000001) {
                MultiSplitLayout.throwInvalidLayout("Split children's total weight > 1.0", node);
            }
        }
    }

    @Override
    public void layoutContainer(Container container) {
        MultiSplitLayout.checkLayout(this.getModel());
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.width - (insets.left + insets.right);
        int n2 = dimension.height - (insets.top + insets.bottom);
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n, n2);
        this.layout1(this.getModel(), rectangle);
        this.layout2(this.getModel(), rectangle);
    }

    private static Divider dividerAt(Node node, int n, int n2) {
        if (node instanceof Divider) {
            Divider divider = (Divider)node;
            return divider.getBounds().contains(n, n2) ? divider : null;
        }
        if (node instanceof Split) {
            Split split = (Split)node;
            for (Node node2 : split.getChildren()) {
                if (!node2.getBounds().contains(n, n2)) continue;
                return MultiSplitLayout.dividerAt(node2, n, n2);
            }
        }
        return null;
    }

    public Divider dividerAt(int n, int n2) {
        return MultiSplitLayout.dividerAt(this.getModel(), n, n2);
    }

    private static boolean nodeOverlapsRectangle(Node node, Rectangle rectangle) {
        Rectangle rectangle2 = node.getBounds();
        return rectangle2.x <= rectangle.x + rectangle.width && rectangle2.x + rectangle2.width >= rectangle.x && rectangle2.y <= rectangle.y + rectangle.height && rectangle2.y + rectangle2.height >= rectangle.y;
    }

    private static List<Divider> dividersThatOverlap(Node node, Rectangle rectangle) {
        if (MultiSplitLayout.nodeOverlapsRectangle(node, rectangle) && node instanceof Split) {
            ArrayList<Divider> arrayList = new ArrayList<Divider>();
            for (Node node2 : ((Split)node).getChildren()) {
                if (node2 instanceof Divider) {
                    if (!MultiSplitLayout.nodeOverlapsRectangle(node2, rectangle)) continue;
                    arrayList.add((Divider)node2);
                    continue;
                }
                if (!(node2 instanceof Split)) continue;
                arrayList.addAll(MultiSplitLayout.dividersThatOverlap(node2, rectangle));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public List<Divider> dividersThatOverlap(Rectangle rectangle) {
        CheckParameterUtil.ensureParameterNotNull(rectangle, "r");
        return MultiSplitLayout.dividersThatOverlap(this.getModel(), rectangle);
    }

    public static class Divider
    extends Node {
        public final boolean isVertical() {
            Split split = this.parent_get();
            return split != null && split.isRowLayout();
        }

        @Override
        public void setWeight(double d) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "MultiSplitLayout.Divider " + this.getBounds();
        }
    }

    public static class Leaf
    extends Node {
        private String name = "";

        public Leaf() {
        }

        public Leaf(String string) {
            CheckParameterUtil.ensureParameterNotNull(string, "name");
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            CheckParameterUtil.ensureParameterNotNull(string, "name");
            this.name = string;
        }

        public String toString() {
            return "MultiSplitLayout.Leaf \"" + this.getName() + "\" weight=" + this.getWeight() + ' ' + this.getBounds();
        }
    }

    public static class Split
    extends Node {
        private List<Node> children = Collections.emptyList();
        private boolean rowLayout = true;

        public boolean isRowLayout() {
            return this.rowLayout;
        }

        public void setRowLayout(boolean bl) {
            this.rowLayout = bl;
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.children);
        }

        public void setChildren(List<Node> list) {
            if (list == null) {
                throw new IllegalArgumentException("children must be a non-null List");
            }
            for (Node node : this.children) {
                node.parent_set(null);
            }
            this.children = new ArrayList<Node>(list);
            for (Node node : this.children) {
                node.parent_set(this);
            }
        }

        public final Node lastWeightedChild() {
            List<Node> list = this.getChildren();
            Node node = null;
            for (Node node2 : list) {
                if (!(node2.getWeight() > 0.0)) continue;
                node = node2;
            }
            return node;
        }

        public String toString() {
            int n = this.getChildren().size();
            StringBuilder stringBuilder = new StringBuilder("MultiSplitLayout.Split");
            stringBuilder.append(this.isRowLayout() ? " ROW [" : " COLUMN [").append(n + (n == 1 ? " child" : " children")).append("] ").append(this.getBounds());
            return stringBuilder.toString();
        }
    }

    public static abstract class Node {
        private Split parent;
        private Rectangle bounds = new Rectangle();
        private double weight;

        public Split parent_get() {
            return this.parent;
        }

        public void parent_set(Split split) {
            this.parent = split;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.bounds);
        }

        public void setBounds(Rectangle rectangle) {
            CheckParameterUtil.ensureParameterNotNull(rectangle, "bounds");
            this.bounds = new Rectangle(rectangle);
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double d) {
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = d;
        }

        private Node siblingAtOffset(int n) {
            Split split = this.parent_get();
            if (split == null) {
                return null;
            }
            List<Node> list = split.getChildren();
            int n2 = list.indexOf(this);
            if (n2 == -1) {
                return null;
            }
            return (n2 += n) > -1 && n2 < list.size() ? list.get(n2) : null;
        }

        public Node nextSibling() {
            return this.siblingAtOffset(1);
        }

        public Node previousSibling() {
            return this.siblingAtOffset(-1);
        }
    }

    public static class InvalidLayoutException
    extends RuntimeException {
        private final transient Node node;

        public InvalidLayoutException(String string, Node node) {
            super(string);
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

