/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.sejda.core.support.io.IOUtils;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.FileSource;
import org.sejda.model.input.Source;
import org.sejda.model.input.SourceDispatcher;
import org.sejda.model.input.StreamSource;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;

public class PageImageWriter {
    private PDDocument document;

    public PageImageWriter(PDDocument document) {
        this.document = document;
    }

    public void write(PDPage page, PDImageXObject image, Point2D position, float width, float height) throws TaskIOException {
        try (PDPageContentStream contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
            contentStream.drawImage(image, (float)position.getX(), (float)position.getY(), width, height);
            contentStream.close();
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred writing image to the page.", e);
        }
    }

    public static PDImageXObject toPDXImageObject(Source<?> imageSource) throws TaskIOException {
        return imageSource.dispatch(new SourceDispatcher<PDImageXObject>(){

            @Override
            public PDImageXObject dispatch(FileSource source) throws TaskIOException {
                try {
                    return PDImageXObject.createFromFile(source.getSource().getPath());
                }
                catch (IOException e) {
                    throw new TaskIOException("An error occurred creating PDImageXObject from file source", e);
                }
            }

            @Override
            public PDImageXObject dispatch(StreamSource source) throws TaskIOException {
                try {
                    String extension = FilenameUtils.getExtension(source.getName());
                    File tmp = IOUtils.createTemporaryBuffer("." + extension);
                    try (FileOutputStream fos = new FileOutputStream(tmp);){
                        org.apache.commons.io.IOUtils.copyLarge(source.getSource(), fos);
                    }
                    return PDImageXObject.createFromFile(tmp.getPath());
                }
                catch (IOException e) {
                    throw new TaskIOException("An error occurred creating PDImageXObject from file source", e);
                }
            }
        });
    }
}

