/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModifierOrderCheck
extends Check {
    private static final String[] JLS_ORDER = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp"};

    public int[] getDefaultTokens() {
        return new int[]{5};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST error;
        ArrayList<AST> mods = new ArrayList<AST>();
        AST modifier = aAST.getFirstChild();
        while (modifier != null) {
            mods.add(modifier);
            modifier = modifier.getNextSibling();
        }
        if (!mods.isEmpty() && (error = this.checkOrderSuggestedByJLS(mods)) != null) {
            this.log(error.getLineNo(), error.getColumnNo(), "mod.order", (Object)error.getText());
        }
    }

    DetailAST checkOrderSuggestedByJLS(List aModifiers) {
        DetailAST modifier;
        int i = 0;
        Iterator it = aModifiers.iterator();
        do {
            if (!it.hasNext()) {
                return null;
            }
            modifier = (DetailAST)it.next();
            while (i < JLS_ORDER.length && !JLS_ORDER[i].equals(modifier.getText())) {
                ++i;
            }
        } while (i < JLS_ORDER.length);
        return modifier;
    }
}

