/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jde.debugger.Debugger;
import jde.debugger.EventSetEvent;
import jde.debugger.EventSetListener;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;

class ThreadDisplay
extends JPanel
implements Protocol {
    private final JTree m_tree;
    private final JLabel m_message;
    private final DefaultMutableTreeNode m_root = new DefaultMutableTreeNode();
    private final Color m_defaultLabelColor;
    private final Debugger m_debugger;
    private final Collection m_interestingCommands;
    private static final int NUM_THREAD_CHILDREN = 4;

    public ThreadDisplay(Debugger debugger) {
        super(new BorderLayout());
        this.m_tree = this.createJTree(this.m_root);
        this.m_tree.setRootVisible(false);
        this.m_debugger = debugger;
        this.m_interestingCommands = new HashSet();
        JScrollPane scroll = new JScrollPane(this.m_tree, 20, 30);
        this.add((Component)scroll, "Center");
        this.m_message = new JLabel();
        this.m_defaultLabelColor = this.m_message.getForeground();
        this.add((Component)this.m_message, "South");
        debugger.addEventSetListener(new EventSetListener(){

            public void eventSetReceived(EventSetEvent evt) {
            }

            public void debuggerSuspended(EventSetEvent evt) {
                ThreadDisplay.this.updateThreads(evt);
            }

            public void debuggerResumed(EventSetEvent evt) {
            }
        });
        JDE.debug(64, "ThreadDisplay registered EventSetListener.");
    }

    private void updateThreads(EventSetEvent evt) {
        JDE.debug(64, "updateThreads()");
        try {
            this.p_message("");
            List<ThreadGroupReference> l = this.m_debugger.getVM().topLevelThreadGroups();
            Iterator<ThreadGroupReference> it = l.iterator();
            JDE.debug(64, "top level thread= " + l);
            while (it.hasNext()) {
                this.updateThreadGroup(this.m_root, it.next());
            }
        }
        catch (JDEException exc) {
            this.p_error(exc.getMessage());
        }
    }

    private void updateThreadGroup(DefaultMutableTreeNode treeNode, ThreadGroupReference tRef) throws JDEException {
        JDE.debug(64, "updateThreadGroup(" + treeNode + ", " + tRef.name() + ")");
        DefaultMutableTreeNode childNode = this.findTreeNode(treeNode, tRef);
        List<ObjectReference> list = tRef.threadGroups();
        Iterator<ObjectReference> it = list.iterator();
        while (it.hasNext()) {
            this.updateThreadGroup(childNode, it.next());
        }
        list = tRef.threads();
        it = list.iterator();
        while (it.hasNext()) {
            this.updateThread(childNode, (ThreadReference)it.next());
        }
    }

    private void updateThread(DefaultMutableTreeNode treeNode, ThreadReference tRef) throws JDEException {
        JDE.debug(64, "updateThread(" + treeNode + ", " + tRef.name() + ")");
        boolean reload = treeNode.getChildCount() == 0;
        DefaultMutableTreeNode childNode = this.findTreeNode(treeNode, tRef);
        DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
        String status = this.getStatusString(tRef);
        MutableTreeNode statusNode = (MutableTreeNode)childNode.getChildAt(1);
        statusNode.setUserObject(status);
        model.nodeChanged(statusNode);
        String state = this.getStateString(tRef);
        MutableTreeNode stateNode = (MutableTreeNode)childNode.getChildAt(2);
        stateNode.setUserObject(state);
        model.nodeChanged(stateNode);
        DefaultMutableTreeNode stackNode = (DefaultMutableTreeNode)childNode.getChildAt(3);
        stackNode.setUserObject("Stack");
        model.nodeChanged(stackNode);
        this.updateStack(model, stackNode, tRef);
        if (reload) {
            model.reload();
        }
    }

    private DefaultMutableTreeNode findTreeNode(DefaultMutableTreeNode parent, ThreadGroupReference tRef) {
        DefaultMutableTreeNode child = this.findExistingTreeNode(parent, tRef);
        if (null == child) {
            child = new DefaultMutableTreeNode(new UserData(tRef));
            this.addChildOnSwingThread(parent, child);
        }
        return child;
    }

    private DefaultMutableTreeNode findTreeNode(DefaultMutableTreeNode parent, ThreadReference tRef) {
        DefaultMutableTreeNode child = this.findExistingTreeNode(parent, tRef);
        if (null == child) {
            child = new DefaultMutableTreeNode(new UserData(tRef));
            child.add(new DefaultMutableTreeNode("id: " + tRef.uniqueID()));
            int index = 1;
            while (index < 4) {
                child.add(new DefaultMutableTreeNode());
                ++index;
            }
            this.addChildOnSwingThread(parent, child);
        }
        return child;
    }

    private DefaultMutableTreeNode findExistingTreeNode(DefaultMutableTreeNode parent, ObjectReference objRef) {
        long uniqueID = objRef.uniqueID();
        if (parent.getChildCount() > 0) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)parent.getFirstChild();
            while (null != treeNode) {
                UserData userData = (UserData)treeNode.getUserObject();
                if (userData.uniqueID == uniqueID) {
                    return treeNode;
                }
                treeNode = treeNode.getNextSibling();
            }
        }
        return null;
    }

    private void updateStack(DefaultTreeModel model, DefaultMutableTreeNode stackNode, ThreadReference thread) {
        int index = 0;
        try {
            List<StackFrame> stackFrames = thread.frames();
            Iterator<StackFrame> it = stackFrames.iterator();
            while (it.hasNext()) {
                StackFrame frame = it.next();
                String frameString = this.getStackFrameString(frame);
                if (index < stackNode.getChildCount()) {
                    MutableTreeNode frameNode = (MutableTreeNode)stackNode.getChildAt(index);
                    frameNode.setUserObject(frameString);
                    model.nodeChanged(frameNode);
                } else {
                    this.addChildOnSwingThread(stackNode, new DefaultMutableTreeNode(frameString));
                }
                ++index;
            }
        }
        catch (IncompatibleThreadStateException exc) {}
        while (index < stackNode.getChildCount()) {
            MutableTreeNode child = (MutableTreeNode)stackNode.getChildAt(index);
            model.removeNodeFromParent(child);
            ++index;
        }
    }

    private void addChildOnSwingThread(final DefaultMutableTreeNode parent, final DefaultMutableTreeNode child) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultTreeModel model = (DefaultTreeModel)ThreadDisplay.this.m_tree.getModel();
                model.insertNodeInto(child, parent, parent.getChildCount());
            }
        });
    }

    private String getStatusString(ThreadReference thread) {
        int status = thread.status();
        String statusString = "unknown";
        switch (status) {
            case 3: {
                statusString = "waiting on monitor";
                break;
            }
            case 5: {
                statusString = "not started";
                break;
            }
            case 1: {
                statusString = "runnable";
                break;
            }
            case 2: {
                statusString = "sleeping";
                break;
            }
            case 4: {
                statusString = "waiting";
                break;
            }
            case 0: {
                statusString = "zombie";
                break;
            }
            case -1: {
                statusString = "unknown";
                break;
            }
        }
        return "status: " + statusString;
    }

    private String getStateString(ThreadReference thread) {
        String stateString = "normal";
        if (thread.isAtBreakpoint()) {
            stateString = "suspended at breakpoint";
        } else if (thread.suspendCount() > 0) {
            stateString = "suspended by debugger";
        }
        return "state: " + stateString;
    }

    private String getStackFrameString(StackFrame frame) {
        try {
            Location loc = frame.location();
            Method method = loc.method();
            String result = loc.declaringType().name() + "." + method.name() + "(" + loc.sourceName() + ":" + loc.lineNumber() + ")";
            return result;
        }
        catch (AbsentInformationException ex) {
            return "Information not available";
        }
    }

    private void p_error(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ThreadDisplay.this.m_message.setText(msg);
                ThreadDisplay.this.m_message.setForeground(Color.red);
            }
        });
    }

    private void p_message(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ThreadDisplay.this.m_message.setText(msg);
                ThreadDisplay.this.m_message.setForeground(ThreadDisplay.this.m_defaultLabelColor);
            }
        });
    }

    private JTree createJTree(DefaultMutableTreeNode root) {
        JTree tree = new JTree(root);
        return tree;
    }

    private static void dumpTree(TreeNode node) {
        JDE.debug(64, "tree dump");
        ThreadDisplay.dumpTree(node, "");
    }

    private static void dumpTree(TreeNode node, String prefix) {
        JDE.debug(64, prefix + "<" + node.toString() + ">");
        prefix = prefix + ".";
        int index = 0;
        while (node.getAllowsChildren() && index < node.getChildCount()) {
            ThreadDisplay.dumpTree(node.getChildAt(index), prefix);
            ++index;
        }
    }

    private class ThreadGroupData {
        public final long uniqueId;
        public String name;

        ThreadGroupData(ThreadGroupReference tRef) {
            this.uniqueId = tRef.uniqueID();
            this.name = tRef.name();
        }

        public String toString() {
            return this.name;
        }
    }

    private class UserData {
        public final long uniqueID;
        public String name;

        UserData(ThreadGroupReference tRef) {
            this.uniqueID = tRef.uniqueID();
            this.name = tRef.name();
        }

        UserData(ThreadReference tRef) {
            this.uniqueID = tRef.uniqueID();
            this.name = tRef.name();
        }

        public String toString() {
            return this.name;
        }
    }
}

