/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import java.util.concurrent.ScheduledExecutorService;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.health.DaemonHealthServices;
import org.gradle.launcher.daemon.server.health.DaemonHealthTracker;
import org.gradle.launcher.daemon.server.health.DaemonStats;
import org.gradle.launcher.daemon.server.health.DaemonStatus;
import org.gradle.launcher.daemon.server.health.HealthLogger;
import org.gradle.launcher.daemon.server.health.HintGCAfterBuild;

public class DefaultDaemonHealthServices
implements DaemonHealthServices {
    private final HintGCAfterBuild hygieneAction = new HintGCAfterBuild();
    private final DaemonStats stats;
    private final DaemonStatus status;
    private final HealthLogger logger = new HealthLogger();
    private final DaemonHealthTracker tracker;

    public DefaultDaemonHealthServices(ScheduledExecutorService scheduledExecutorService) {
        this.stats = new DaemonStats(scheduledExecutorService);
        this.status = new DaemonStatus(this.stats);
        this.tracker = new DaemonHealthTracker(this.stats, this.status, this.logger);
    }

    public DaemonCommandAction getGCHintAction() {
        return this.hygieneAction;
    }

    public DaemonCommandAction getHealthTrackerAction() {
        return this.tracker;
    }

    public DaemonStats getDaemonStats() {
        return this.stats;
    }

    public DaemonStatus getDaemonStatus() {
        return this.status;
    }
}

