/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript.compile.internal.rhino;

import org.gradle.api.Action;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.plugins.javascript.base.SourceTransformationException;
import org.gradle.plugins.javascript.coffeescript.compile.internal.CoffeeScriptCompileDestinationCalculator;
import org.gradle.plugins.javascript.coffeescript.compile.internal.SerializableCoffeeScriptCompileSpec;
import org.gradle.plugins.javascript.coffeescript.compile.internal.rhino.CoffeeScriptCompilerProtocol;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class CoffeeScriptCompilerWorker
implements CoffeeScriptCompilerProtocol {
    public void process(SerializableCoffeeScriptCompileSpec spec) {
        Scriptable coffeeScriptScope = RhinoWorkerUtils.parse(spec.getCoffeeScriptJs(), "UTF-8", new Action<Context>(){

            public void execute(Context context) {
                context.setOptimizationLevel(-1);
            }
        });
        String encoding = spec.getOptions().getEncoding();
        CoffeeScriptCompileDestinationCalculator destinationCalculator = new CoffeeScriptCompileDestinationCalculator(spec.getDestinationDir());
        for (RelativeFile target : spec.getSource()) {
            String source = RhinoWorkerUtils.readFile(target.getFile(), encoding);
            String output = this.compile(coffeeScriptScope, source, target.getRelativePath().getPathString());
            RhinoWorkerUtils.writeFile(output, destinationCalculator.transform(target.getRelativePath()), encoding);
        }
    }

    private String compile(Scriptable rootScope, final String source, final String sourceName) {
        return RhinoWorkerUtils.childScope(rootScope, new RhinoWorkerUtils.DefaultScopeOperation<String>(){

            @Override
            public String action(Scriptable compileScope, Context context) {
                compileScope.put("coffeeScriptSource", compileScope, (Object)source);
                try {
                    return (String)context.evaluateString(compileScope, "CoffeeScript.compile(coffeeScriptSource, {});", sourceName, 0, null);
                }
                catch (JavaScriptException jse) {
                    throw new SourceTransformationException(String.format("Failed to compile coffeescript file: %s", sourceName), jse);
                }
            }
        });
    }
}

