/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.jshint;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.plugins.javascript.base.JavaScriptExtension;
import org.gradle.plugins.javascript.jshint.JsHint;
import org.gradle.plugins.javascript.jshint.JsHintExtension;
import org.gradle.plugins.javascript.rhino.RhinoExtension;
import org.gradle.plugins.javascript.rhino.RhinoPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsHintPlugin
extends GroovyObjectSupport
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(RhinoPlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        JavaScriptExtension jsExtension = (JavaScriptExtension)project.getExtensions().getByType(JavaScriptExtension.class);
        final JsHintExtension jsHintExtension = (JsHintExtension)((ExtensionAware)jsExtension).getExtensions().create("jsHint", JsHintExtension.class, new Object[0]);
        final Configuration configuration = this.addConfiguration(project.getConfigurations(), project.getDependencies(), jsHintExtension);
        ConventionMapping conventionMapping = ((IConventionAware)jsHintExtension).getConventionMapping();
        conventionMapping.map("js", (Callable)new Callable<Configuration>(){

            @Override
            public Configuration call() {
                return configuration;
            }
        });
        conventionMapping.map("version", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return "r07";
            }
        });
        final RhinoExtension rhinoExtension = (RhinoExtension)((ExtensionAware)jsExtension).getExtensions().getByType(RhinoExtension.class);
        final ReportingExtension reportingExtension = (ReportingExtension)project.getExtensions().getByType(ReportingExtension.class);
        project.getTasks().withType(JsHint.class, (Action)new Action<JsHint>(){

            public void execute(final JsHint task) {
                task.getConventionMapping().map("rhinoClasspath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return rhinoExtension.getClasspath();
                    }
                });
                task.getConventionMapping().map("jsHint", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return jsHintExtension.getJs();
                    }
                });
                task.getConventionMapping().map("jsonReport", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return reportingExtension.file(task.getName() + "/report.json");
                    }
                });
            }
        });
    }

    public Configuration addConfiguration(ConfigurationContainer configurations, final DependencyHandler dependencies, final JsHintExtension extension) {
        Configuration configuration = (Configuration)configurations.create("jsHintPlugin");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet configDependencies) {
                String notation = "com.jshint:jshint:" + extension.getVersion() + "@js";
                Dependency dependency = dependencies.create((Object)notation);
                configDependencies.add((Object)dependency);
            }
        });
        return configuration;
    }
}

