/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.apache.ivy.Ivy;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualArtifactResolver
implements ArtifactResolver {
    private final CacheLockingManager lockingManager;
    private final IvyContextManager ivyContextManager;
    private final ArtifactResolver delegate;

    public ContextualArtifactResolver(CacheLockingManager lockingManager, IvyContextManager ivyContextManager, ArtifactResolver delegate) {
        this.lockingManager = lockingManager;
        this.ivyContextManager = ivyContextManager;
        this.delegate = delegate;
    }

    @Override
    public void resolveModuleArtifacts(final ComponentResolveMetaData component, final ArtifactType artifactType, final BuildableArtifactSetResolveResult result) {
        String description = "Resolve " + artifactType + " for " + component;
        this.executeInContext(description, new Action<Ivy>(){

            public void execute(Ivy ivy) {
                ContextualArtifactResolver.this.delegate.resolveModuleArtifacts(component, artifactType, result);
            }
        });
    }

    @Override
    public void resolveModuleArtifacts(final ComponentResolveMetaData component, final ComponentUsage usage, final BuildableArtifactSetResolveResult result) {
        String description = "Resolve " + usage + " for " + component;
        this.executeInContext(description, new Action<Ivy>(){

            public void execute(Ivy ivy) {
                ContextualArtifactResolver.this.delegate.resolveModuleArtifacts(component, usage, result);
            }
        });
    }

    @Override
    public void resolveArtifact(final ComponentArtifactMetaData artifact, final ModuleSource moduleSource, final BuildableArtifactResolveResult result) {
        this.executeInContext("Resolve ".concat(artifact.toString()), new Action<Ivy>(){

            public void execute(Ivy ivy) {
                ContextualArtifactResolver.this.delegate.resolveArtifact(artifact, moduleSource, result);
            }
        });
    }

    private void executeInContext(String description, final Action<Ivy> action) {
        this.lockingManager.useCache(description, new Runnable(){

            public void run() {
                ContextualArtifactResolver.this.ivyContextManager.withIvy((Action<? super Ivy>)action);
            }
        });
    }
}

