/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.remote.internal.inet.InetEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketInetAddress
implements InetEndpoint {
    private final InetAddress address;
    private final int port;

    public SocketInetAddress(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public String getDisplayName() {
        return this.address + ":" + this.port;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SocketInetAddress other = (SocketInetAddress)o;
        return other.address.equals(this.address) && other.port == this.port;
    }

    public int hashCode() {
        return this.address.hashCode() ^ this.port;
    }

    @Override
    public List<InetAddress> getCandidates() {
        return Collections.singletonList(this.address);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

