/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.EventQueue;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class EditBus {
    private static final HandlerList components = new HandlerList();

    public static void addToBus(EBComponent eBComponent) {
        EditBus.addToBus((Object)eBComponent);
    }

    public static void addToBus(Object object) {
        components.addComponent(object);
    }

    public static void removeFromBus(EBComponent eBComponent) {
        EditBus.removeFromBus((Object)eBComponent);
    }

    public static void removeFromBus(Object object) {
        components.removeComponent(object);
    }

    public static void send(EBMessage eBMessage) {
        SendMessage sendMessage = new SendMessage(eBMessage);
        if (EventQueue.isDispatchThread()) {
            sendMessage.run();
        } else {
            ThreadUtilities.runInDispatchThreadNow(sendMessage);
        }
    }

    public static void sendAsync(EBMessage eBMessage) {
        EventQueue.invokeLater(new SendMessage(eBMessage));
    }

    private EditBus() {
    }

    private static void dispatch(EBMessageHandler eBMessageHandler, EBMessage eBMessage) throws Exception {
        if (eBMessageHandler.handler != null) {
            eBMessageHandler.handler.invoke(eBMessageHandler.comp, eBMessage);
        } else {
            assert (eBMessageHandler.comp instanceof EBComponent);
            ((EBComponent)eBMessageHandler.comp).handleMessage(eBMessage);
        }
    }

    private static void sendImpl(EBMessage eBMessage) {
        boolean bl = true;
        Class<?> clazz = eBMessage.getClass();
        while (!clazz.equals(Object.class)) {
            List list = (List)components.get(clazz);
            if (list != null) {
                try {
                    for (EBMessageHandler eBMessageHandler : list) {
                        if (!bl && eBMessageHandler.source != null && eBMessageHandler.source.exact()) continue;
                        if (Debug.EB_TIMER) {
                            long l = System.nanoTime();
                            EditBus.dispatch(eBMessageHandler, eBMessage);
                            long l2 = System.nanoTime() - l;
                            if (l2 < 1000000L) continue;
                            Log.log(1, EditBus.class, eBMessageHandler.comp + ": " + l2 + " ns");
                            continue;
                        }
                        EditBus.dispatch(eBMessageHandler, eBMessage);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.log(9, EditBus.class, "Exception while sending message on EditBus:");
                    Log.log(9, EditBus.class, invocationTargetException.getCause());
                }
                catch (Throwable throwable) {
                    Log.log(9, EditBus.class, "Exception while sending message on EditBus:");
                    Log.log(9, EditBus.class, throwable);
                }
            }
            clazz = clazz.getSuperclass();
            bl = false;
        }
    }

    private static class SendMessage
    implements Runnable {
        private EBMessage message;

        public SendMessage(EBMessage eBMessage) {
            this.message = eBMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.log(1, EditBus.class, this.message.toString());
            components.lock();
            try {
                EditBus.sendImpl(this.message);
            }
            finally {
                components.unlock();
            }
        }
    }

    private static class HandlerList
    extends HashMap<Class<?>, List<EBMessageHandler>> {
        private int lock;
        private List<Object> add = new LinkedList<Object>();
        private List<Object> remove = new LinkedList<Object>();

        private HandlerList() {
        }

        public List<EBMessageHandler> safeGet(Class<?> clazz) {
            LinkedList linkedList = (LinkedList)super.get(clazz);
            if (linkedList == null) {
                linkedList = new LinkedList();
                super.put(clazz, linkedList);
            }
            return linkedList;
        }

        public synchronized void lock() {
            ++this.lock;
        }

        public synchronized void unlock() {
            --this.lock;
            if (this.lock == 0) {
                for (Object object : this.add) {
                    this.addComponent(object);
                }
                for (Object object : this.remove) {
                    this.removeComponent(object);
                }
                this.add.clear();
                this.remove.clear();
            }
        }

        public synchronized void removeComponent(Object object) {
            if (this.lock != 0) {
                this.remove.add(object);
                return;
            }
            for (Map.Entry entry : this.entrySet()) {
                Class clazz = (Class)entry.getKey();
                List list = (List)entry.getValue();
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    EBMessageHandler eBMessageHandler = (EBMessageHandler)iterator.next();
                    if (eBMessageHandler.comp != object) continue;
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addComponent(Object object) {
            if (this.lock != 0) {
                this.add.add(object);
                return;
            }
            for (Method method : object.getClass().getMethods()) {
                EBHandler eBHandler = method.getAnnotation(EBHandler.class);
                if (eBHandler == null) continue;
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    Log.log(9, EditBus.class, "Invalid EBHandler method " + method.getName() + " in class " + object.getClass().getName() + ": too many parameters.");
                    continue;
                }
                if (!EBMessage.class.isAssignableFrom(classArray[0])) {
                    Log.log(9, EditBus.class, "Invalid parameter " + classArray[0].getName() + " in method " + method.getName() + " of class " + object.getClass().getName());
                    continue;
                }
                HandlerList handlerList = components;
                synchronized (handlerList) {
                    this.safeGet(classArray[0]).add(new EBMessageHandler(object, method, eBHandler));
                }
            }
            if (object instanceof EBComponent) {
                this.safeGet(EBMessage.class).add(new EBMessageHandler(object, null, null));
            }
        }
    }

    private static class EBMessageHandler {
        Object comp;
        Method handler;
        EBHandler source;

        EBMessageHandler(Object object, Method method, EBHandler eBHandler) {
            this.comp = object;
            this.handler = method;
            this.source = eBHandler;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface EBHandler {
        public boolean exact() default false;
    }
}

