/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.java.BS;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.util.C;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class NucleicRenderer {
    private boolean renderEdges;
    private boolean ladderOnly;
    private boolean renderRibose;
    private P3[] rPt;
    private P3[] rPt5;
    private P3[] rScr;
    private P3[] rScr5;
    private P3 basePt;
    private P3 backbonePt;
    private P3 baseScreen;
    private P3 backboneScreen;
    private Viewer vwr;
    private TransformManager tm;
    private JmolRendererInterface g3d;
    private BioShapeRenderer bsr;
    private short colix;

    void renderNucleic(BioShapeRenderer renderer) {
        if (this.vwr == null) {
            this.rPt = new P3[10];
            this.rScr = new P3[10];
            this.rPt5 = new P3[5];
            this.rScr5 = new P3[5];
            this.backboneScreen = new P3();
            this.backbonePt = new P3();
            this.bsr = renderer;
            this.tm = renderer.vwr.tm;
            this.vwr = renderer.vwr;
        }
        this.g3d = renderer.g3d;
        P3[] screens = renderer.controlPointScreens;
        P3[] pts = renderer.controlPoints;
        this.renderEdges = this.vwr.getBoolean(603979816);
        this.ladderOnly = this.vwr.getBoolean(603979818);
        this.renderRibose = this.vwr.getBoolean(603979819);
        boolean isTraceAlpha = this.vwr.getBoolean(603979966);
        BS bsVisible = this.bsr.bsVisible;
        int i = bsVisible.nextSetBit(0);
        while (i >= 0) {
            P3 scr = screens[i + 1];
            if (isTraceAlpha) {
                this.backboneScreen.ave(screens[i], scr);
                this.backbonePt.ave(pts[i], pts[i + 1]);
            } else {
                this.backboneScreen.setT(scr);
                this.backbonePt.setT(pts[i + 1]);
            }
            this.bsr.renderHermiteConic(i, false, 4);
            this.colix = this.bsr.getLeadColix(i);
            if (this.bsr.setBioColix(this.colix)) {
                this.renderNucleicBaseStep(i);
            }
            i = bsVisible.nextSetBit(i + 1);
        }
    }

    private void renderNucleicBaseStep(int im) {
        P3 stepPt;
        P3 stepScreen;
        boolean hasRing5;
        if (this.bsr.isPhosphorusOnly) {
            return;
        }
        NucleicMonomer nucleotide = (NucleicMonomer)this.bsr.monomers[im];
        int thisMad = this.bsr.mads[im];
        if (this.rScr[0] == null) {
            int i = 10;
            while (--i >= 0) {
                this.rScr[i] = new P3();
            }
            i = 5;
            while (--i >= 0) {
                this.rScr5[i] = new P3();
            }
            this.baseScreen = new P3();
            this.basePt = new P3();
            this.rPt[9] = new P3();
        }
        if (this.renderEdges) {
            this.renderLeontisWesthofEdges(nucleotide);
            return;
        }
        nucleotide.getBaseRing6Points(this.rPt);
        this.transformPoints(6, this.rPt, this.rScr);
        if (!this.ladderOnly) {
            this.renderRing6();
        }
        if (hasRing5 = nucleotide.maybeGetBaseRing5Points(this.rPt5)) {
            if (this.ladderOnly) {
                stepScreen = this.rScr[2];
                stepPt = this.rPt[2];
            } else {
                this.transformPoints(5, this.rPt5, this.rScr5);
                this.renderRing5();
                stepScreen = this.rScr5[3];
                stepPt = this.rPt5[3];
            }
        } else {
            int pt = this.ladderOnly ? 4 : 2;
            stepScreen = this.rScr[pt];
            stepPt = this.rPt[pt];
        }
        short mad = (short)(thisMad > 1 ? thisMad / 2 : thisMad);
        float r = (float)mad / 2000.0f;
        int w = (int)this.vwr.tm.scaleToScreen((int)this.backboneScreen.z, mad);
        if (this.ladderOnly || !this.renderRibose) {
            this.g3d.fillCylinderScreen3I((byte)3, w, this.backboneScreen, stepScreen, this.backbonePt, stepPt, r);
        }
        if (this.ladderOnly) {
            return;
        }
        this.drawEdges(this.rScr, this.rPt, 6);
        if (hasRing5) {
            this.drawEdges(this.rScr5, this.rPt5, 5);
        } else {
            this.renderEdge(this.rScr, this.rPt, 0, 5);
        }
        if (this.renderRibose) {
            this.baseScreen.setT(stepScreen);
            this.basePt.setT(stepPt);
            nucleotide.getRiboseRing5Points(this.rPt);
            P3 c = this.rPt[9];
            c.set(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < 5; ++i) {
                c.add(this.rPt[i]);
            }
            c.scale(0.2f);
            this.transformPoints(10, this.rPt, this.rScr);
            this.renderRibose();
            this.renderEdge(this.rScr, this.rPt, 2, 5);
            this.renderEdge(this.rScr, this.rPt, 3, 6);
            this.renderEdge(this.rScr, this.rPt, 6, 7);
            this.renderEdge(this.rScr, this.rPt, 7, 8);
            this.renderCyl(this.rScr[0], this.baseScreen, this.rPt[0], this.basePt);
            this.drawEdges(this.rScr, this.rPt, 5);
        }
    }

    private void transformPoints(int count, T3[] angstroms, P3[] screens) {
        int i = count;
        while (--i >= 0) {
            this.tm.transformPtScrT3(angstroms[i], screens[i]);
        }
    }

    private void drawEdges(P3[] scr, P3[] pt, int n) {
        int i = n;
        while (--i >= 0) {
            scr[i].z -= 1.0f;
        }
        i = n;
        while (--i > 0) {
            this.renderEdge(scr, pt, i, i - 1);
        }
    }

    private void renderLeontisWesthofEdges(NucleicMonomer nucleotide) {
        if (!nucleotide.getEdgePoints(this.rPt)) {
            return;
        }
        this.transformPoints(6, this.rPt, this.rScr);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, true);
        this.renderEdge(this.rScr, this.rPt, 0, 1);
        this.renderEdge(this.rScr, this.rPt, 1, 2);
        boolean isTranslucent = C.isColixTranslucent(this.colix);
        float tl = C.getColixTranslucencyLevel(this.colix);
        short colixSugarEdge = C.getColixTranslucent3((short)10, isTranslucent, tl);
        short colixWatsonCrickEdge = C.getColixTranslucent3((short)11, isTranslucent, tl);
        short colixHoogsteenEdge = C.getColixTranslucent3((short)7, isTranslucent, tl);
        this.g3d.setC(colixSugarEdge);
        this.renderEdge(this.rScr, this.rPt, 2, 3);
        this.g3d.setC(colixWatsonCrickEdge);
        this.renderEdge(this.rScr, this.rPt, 3, 4);
        this.g3d.setC(colixHoogsteenEdge);
        this.renderEdge(this.rScr, this.rPt, 4, 5);
    }

    private void renderEdge(P3[] scr, P3[] pt, int i, int j) {
        this.renderCyl(scr[i], scr[j], pt[i], pt[j]);
    }

    private void renderCyl(P3 s1, P3 s2, P3 p1, P3 p2) {
        this.g3d.fillCylinderScreen3I((byte)3, 3, s1, s2, p1, p2, 0.005f);
    }

    private void renderTriangle(P3[] scr, P3[] pt, int i, int j, int k, boolean doShade) {
        this.g3d.fillTriangle3i(scr[i], scr[j], scr[k], pt[i], pt[j], pt[k], doShade);
    }

    private void renderRing6() {
        this.renderTriangle(this.rScr, this.rPt, 0, 2, 4, true);
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 2, false);
        this.renderTriangle(this.rScr, this.rPt, 0, 4, 5, false);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, false);
    }

    private void renderRing5() {
        this.renderTriangle(this.rScr5, this.rPt5, 0, 1, 2, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 2, 3, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 3, 4, false);
    }

    private void renderRibose() {
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 1, 2, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 3, 4, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 4, 0, 9, true);
    }
}

